/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncPart;

public class SyncEnergyType
extends SyncPart {
    public EnergyType type = EnergyType.FE;

    public SyncEnergyType(int id) {
        super(id);
    }

    public SyncEnergyType(int id, EnergyType def) {
        super(id);
        this.type = def;
    }

    public EnergyType getEnergyType() {
        return this.type;
    }

    public void setEnergyType(EnergyType type) {
        this.type = type;
        this.markChanged();
    }

    public void incrementType() {
        SonarHelper.incrementEnum((Enum)this.type, (Enum[])EnergyType.values());
        this.markChanged();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.type = EnergyType.values()[buf.readInt()];
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.type = EnergyType.readFromNBT(nbt, "energyType");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        EnergyType.writeToNBT(this.type, nbt, "energyType");
        return nbt;
    }
}

