/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.pipeline;

import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.model.CollectedQuadBakedBlockModel;
import crazypants.enderio.base.render.model.NullModel;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.pipeline.PaintWrangler;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.Profiler;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;

public class BlockStateWrapperRelay
extends BlockStateWrapperBase {
    private static final NullModel NULL = new NullModel();

    public BlockStateWrapperRelay(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        super(state, world, pos, null);
    }

    @Override
    public void bakeModel() {
        String cacheResult;
        long start = Profiler.instance.start();
        QuadCollector paintQuads = new QuadCollector();
        boolean hasPaintRendered = false;
        if (!(!(this.block instanceof IPaintable.IBlockPaintableBlock) || this.block instanceof IPaintable.IWrenchHideablePaint && this.getYetaDisplayMode().isHideFacades())) {
            hasPaintRendered = PaintWrangler.wrangleBakedModel(this.world, this.pos, ((IPaintable.IBlockPaintableBlock)this.block).getPaintSource(this.state, this.world, this.pos), paintQuads);
        }
        if (!hasPaintRendered) {
            if (MinecraftForgeClient.getRenderLayer() == null || MinecraftForgeClient.getRenderLayer() == this.block.func_180664_k()) {
                this.model = null;
                cacheResult = "relaying";
            } else {
                this.model = NULL;
                cacheResult = "none";
            }
        } else {
            this.model = new CollectedQuadBakedBlockModel(paintQuads);
            cacheResult = "paint only";
        }
        Profiler.instance.stop(start, this.state.func_177230_c().func_149732_F() + " (bake, cache=" + cacheResult + ")");
    }

    @Override
    public IBakedModel getModel() {
        return this.model;
    }
}

