/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.wireless;

import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.base.power.wireless.WirelessChargerController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3i;

public class WirelessChargedLocation
implements Comparator<IWirelessCharger> {
    @Nonnull
    private final TileEntity te;

    @Override
    public int compare(IWirelessCharger o1, IWirelessCharger o2) {
        return Double.compare(o1.getLocation().func_177951_i((Vec3i)this.te.func_174877_v()), o2.getLocation().func_177951_i((Vec3i)this.te.func_174877_v()));
    }

    public WirelessChargedLocation(@Nonnull TileEntity te) {
        this.te = te;
    }

    @Nonnull
    private List<IWirelessCharger> getChargers() {
        ArrayList<IWirelessCharger> chargers = new ArrayList<IWirelessCharger>();
        WirelessChargerController.instance.getChargers(this.te.func_145831_w(), this.te.func_174877_v(), chargers);
        if (chargers.size() > 1) {
            chargers.sort(this);
        }
        return chargers;
    }

    public boolean chargeItems(@Nonnull NonNullList<ItemStack> items) {
        for (IWirelessCharger wc : this.getChargers()) {
            if (!wc.chargeItems(items)) continue;
            return true;
        }
        return false;
    }

    public int takeEnergy(int max) {
        int charged = 0;
        for (IWirelessCharger wc : this.getChargers()) {
            if ((charged += wc.takeEnergy(max - charged)) >= max) break;
        }
        return charged;
    }
}

