/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.InfinityConfig;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.gui.BlockSceneRenderer;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.material.Material;
import info.loenwind.autoconfig.factory.IValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class InfinityRecipeCategory
implements IRecipeCategory<InfinityRecipeWrapper> {
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private static final String UUID = "infinityPowder";

    public static void registerExtras(final IModRegistry registry) {
        final Boolean onFire = (Boolean)InfinityConfig.inWorldCraftingEnabled.get();
        final Boolean onWater = (Boolean)InfinityConfig.inWorldCraftingFireWaterEnabled.get();
        if (!(onFire.booleanValue() || onWater.booleanValue() || ((Things)InfinityConfig.bedrock.get()).isEmpty())) {
            return;
        }
        ((Things)InfinityConfig.bedrock.get()).getItemStacks().apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack stack) {
                registry.addRecipeCatalyst((Object)stack, new String[]{InfinityRecipeCategory.UUID});
            }
        });
        if (onFire.booleanValue()) {
            registry.addRecipeCatalyst((Object)new ItemStack(Items.field_151033_d, 1, 0), new String[]{UUID});
        }
        final Block fire_water = Fluids.FIRE_WATER.getFluid().getBlock();
        if (onWater.booleanValue() && fire_water != null) {
            registry.addRecipeCatalyst((Object)Fluids.FIRE_WATER.getBucket(), new String[]{UUID});
        }
        long start = System.nanoTime();
        final ArrayList result = new ArrayList();
        ((Things)InfinityConfig.bedrock.get()).getBlocks().apply((NNList.Callback)new NNList.Callback<Block>(){

            public void apply(@Nonnull Block block) {
                if (onFire.booleanValue()) {
                    result.add(new InfinityRecipeWrapper(block, (Block)Blocks.field_150480_ab, InfinityConfig.dropChance));
                }
                if (onWater.booleanValue() && fire_water != null) {
                    result.add(new InfinityRecipeWrapper(block, fire_water, InfinityConfig.dropChanceFirewater));
                }
            }
        });
        long end = System.nanoTime();
        registry.addRecipes(result, UUID);
        Log.info(String.format("InfinityRecipeCategory: Added %d infinity recipe(s) to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9));
    }

    public InfinityRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("infinity");
        this.background = guiHelper.createDrawable(backgroundLocation, 0, 10, 128, 50);
    }

    @Nonnull
    public String getUid() {
        return UUID;
    }

    @Nonnull
    public String getTitle() {
        return Material.POWDER_INFINITY.getStack().func_82833_r();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull InfinityRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 85, 20);
        itemStacks.set(ingredients);
        recipeWrapper.currentX = ((RecipeLayout)recipeLayout).getPosX();
        recipeWrapper.currentY = ((RecipeLayout)recipeLayout).getPosY();
    }

    @Nonnull
    public String getModName() {
        return "enderio";
    }

    public static class InfinityRecipeWrapper
    implements IRecipeWrapper {
        @Nonnull
        private final BlockSceneRenderer bsr;
        @Nonnull
        private final IValue<Float> dropchance;
        private int currentX = 0;
        private int currentY = 0;

        public InfinityRecipeWrapper(@Nonnull Block block1, @Nonnull Block block2, @Nonnull IValue<Float> dropchance) {
            this.bsr = new BlockSceneRenderer((NNList<Pair<BlockPos, IBlockState>>)new NNList((Object[])new Pair[]{Pair.of((Object)new BlockPos(0, 0, 0), (Object)block1.func_176223_P()), Pair.of((Object)new BlockPos(0, 1, 0), (Object)block2.func_176223_P())}));
            this.dropchance = dropchance;
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setOutput(ItemStack.class, (Object)Material.POWDER_INFINITY.getStack());
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int x = 15 + this.currentX;
            int y = 0 + this.currentY;
            int w = 26;
            int h = 50;
            GlStateManager.func_179094_E();
            this.bsr.drawScreen(x, y, w, h);
            GlStateManager.func_179121_F();
            String text = "<" + (int)(((Float)this.dropchance.get()).floatValue() * 100.0f) + "%";
            int stringWidth = minecraft.field_71466_p.func_78256_a(text);
            minecraft.field_71466_p.func_175065_a(text, (float)(59 - stringWidth / 2), 26.0f, 0xFFFFFF, false);
            if (!((Boolean)InfinityConfig.enableInAllDimensions.get()).booleanValue()) {
                if (((int[])InfinityConfig.enableInDimensions.get()).length == 1 && ((int[])InfinityConfig.enableInDimensions.get())[0] == 0) {
                    minecraft.field_71466_p.func_78276_b(Lang.GUI_INFINTY_RECIPE_DIMENSIONS.get(), 45, 40, ColorUtil.getRGB((Color)Color.GRAY));
                } else {
                    minecraft.field_71466_p.func_78276_b(Lang.GUI_INFINTY_RECIPE_DIMENSIONS_MULTI.get(), 45, 40, ColorUtil.getRGB((Color)Color.GRAY));
                }
            }
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (!(mouseX < 45 || mouseY < 40 || mouseY >= 40 + Minecraft.func_71410_x().field_71466_p.field_78288_b || ((Boolean)InfinityConfig.enableInAllDimensions.get()).booleanValue() || ((int[])InfinityConfig.enableInDimensions.get()).length == 1 && ((int[])InfinityConfig.enableInDimensions.get())[0] == 0 || mouseX >= 45 + Minecraft.func_71410_x().field_71466_p.func_78256_a(Lang.GUI_INFINTY_RECIPE_DIMENSIONS_MULTI.get()))) {
                ArrayList<String> result = new ArrayList<String>();
                result.add(Lang.GUI_INFINTY_RECIPE_DIMENSIONS_THESE.get());
                result.add("");
                boolean inCurrent = false;
                for (int dim : (int[])InfinityConfig.enableInDimensions.get()) {
                    if (Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.getDimension() == dim) {
                        result.add(Lang.GUI_INFINTY_RECIPE_DIMENSIONS_LIST_HERE.get(TelepadTarget.getDimenionName(dim)));
                        inCurrent = true;
                        continue;
                    }
                    result.add(Lang.GUI_INFINTY_RECIPE_DIMENSIONS_LIST.get(TelepadTarget.getDimenionName(dim)));
                }
                if (!inCurrent) {
                    result.add("");
                    result.add(Lang.GUI_INFINTY_RECIPE_DIMENSIONS_NOTHERE.get());
                }
                return result;
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

