/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.StringUtils;

public class JEDJsonUtils {
    public static final Gson GSON = new GsonBuilder().create();
    public static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();

    public static boolean hasBoolean(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsBoolean();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasInteger(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsInt();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasFloat(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsFloat();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasDouble(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsDouble();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasString(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        if (el != null && el.isJsonPrimitive()) {
            try {
                el.getAsString();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasObject(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonObject();
    }

    public static boolean hasArray(JsonObject obj, String name) {
        JsonElement el = obj.get(name);
        return el != null && el.isJsonArray();
    }

    public static String getStringOrDefault(JsonObject obj, String name, String defaultValue, boolean allowEmpty) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                String str = obj.get(name).getAsString();
                return !allowEmpty && StringUtils.isBlank((CharSequence)str) ? defaultValue : str;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static byte getByteOrDefault(JsonObject obj, String name, byte defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsByte();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntegerOrDefault(JsonObject obj, String name, int defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(JsonObject obj, String name, float defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsFloat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(JsonObject obj, String name, double defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanOrDefault(JsonObject obj, String name, boolean defaultValue) {
        if (obj.has(name) && obj.get(name).isJsonPrimitive()) {
            try {
                return obj.get(name).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(JsonObject obj, String name) {
        return JEDJsonUtils.getBooleanOrDefault(obj, name, false);
    }

    public static byte getByte(JsonObject obj, String name) {
        return JEDJsonUtils.getByteOrDefault(obj, name, (byte)0);
    }

    public static int getInteger(JsonObject obj, String name) {
        return JEDJsonUtils.getIntegerOrDefault(obj, name, 0);
    }

    public static float getFloat(JsonObject obj, String name) {
        return JEDJsonUtils.getFloatOrDefault(obj, name, 0.0f);
    }

    public static double getDouble(JsonObject obj, String name) {
        return JEDJsonUtils.getDoubleOrDefault(obj, name, 0.0);
    }

    public static String getString(JsonObject obj, String name) {
        return JEDJsonUtils.getStringOrDefault(obj, name, null, true);
    }

    @Nullable
    public static JsonObject getOrCreateNestedObject(JsonObject parent, String key) {
        return JEDJsonUtils.getNestedObject(parent, key, true);
    }

    @Nullable
    public static JsonObject getNestedObject(JsonObject parent, String key, boolean create) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            if (!create) {
                return null;
            }
            JsonObject obj = new JsonObject();
            parent.add(key, (JsonElement)obj);
            return obj;
        }
        return parent.get(key).getAsJsonObject();
    }

    public static Vec3d getVec3dOrDefault(JsonObject obj, String arrayName, Vec3d defaultValue) {
        if (obj.has(arrayName) && obj.get(arrayName).isJsonArray()) {
            JsonArray arr = obj.get(arrayName).getAsJsonArray();
            try {
                Vec3d vec = new Vec3d(arr.get(0).getAsDouble(), arr.get(1).getAsDouble(), arr.get(2).getAsDouble());
                return vec;
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to parse a Vec3d value '{}' from JSON", (Object)arrayName, (Object)e);
            }
        }
        return defaultValue;
    }

    @Nullable
    public static JsonObject deepCopy(@Nullable JsonObject jsonObject) {
        if (jsonObject != null) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                result.add((String)entry.getKey(), JEDJsonUtils.deepCopy((JsonElement)entry.getValue()));
            }
            return result;
        }
        return null;
    }

    @Nonnull
    public static JsonArray deepCopy(@Nonnull JsonArray jsonArray) {
        JsonArray result = new JsonArray();
        for (JsonElement e : jsonArray) {
            result.add(JEDJsonUtils.deepCopy(e));
        }
        return result;
    }

    @Nonnull
    public static JsonElement deepCopy(@Nonnull JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive() || jsonElement.isJsonNull()) {
            return jsonElement;
        }
        if (jsonElement.isJsonObject()) {
            return JEDJsonUtils.deepCopy(jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonArray()) {
            return JEDJsonUtils.deepCopy(jsonElement.getAsJsonArray());
        }
        throw new UnsupportedOperationException("Unsupported element: " + jsonElement);
    }

    public static String serialize(@Nonnull JsonElement element) {
        return GSON.toJson(element);
    }

    @Nullable
    public static JsonElement deserialize(String input) throws JsonParseException, JsonSyntaxException {
        JsonParser parser = new JsonParser();
        return parser.parse(input);
    }

    @Nullable
    public static JsonElement parseJsonFile(File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            String fileName = file.getAbsolutePath();
            try {
                JsonParser parser = new JsonParser();
                return parser.parse((Reader)new FileReader(file));
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("Failed to parse the JSON file '{}'", (Object)fileName, (Object)e);
            }
        }
        return null;
    }
}

