/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util;

import com.google.common.io.Files;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import java.io.File;

public class ConfigFileUtils {
    public static void createDirIfNotExists(File dir) {
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to create the directory '{}'", (Object)dir.getAbsolutePath(), (Object)e);
            }
        }
    }

    public static void tryCopyOrMoveConfigIfMissingOrOlder(File fileToReplace, File replacementFile, FileAction action, ConfigComparator configComparator) {
        if (replacementFile.exists() && replacementFile.isFile() && replacementFile.canRead() && (!fileToReplace.exists() || configComparator.shouldReplace(fileToReplace, replacementFile))) {
            try {
                if (action == FileAction.COPY) {
                    JustEnoughDimensions.logger.info("Copying the file '{}' to the new location '{}'", (Object)replacementFile.getAbsolutePath(), (Object)fileToReplace.getAbsolutePath());
                    Files.copy((File)replacementFile, (File)fileToReplace);
                } else if (action == FileAction.MOVE) {
                    JustEnoughDimensions.logger.info("Moving the file '{}' to the new location '{}'", (Object)replacementFile.getAbsolutePath(), (Object)fileToReplace.getAbsolutePath());
                    Files.move((File)replacementFile, (File)fileToReplace);
                }
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to {} the file '{}' to the new location '{}'", (Object)action.name().toLowerCase(), (Object)replacementFile.getAbsolutePath(), (Object)fileToReplace.getAbsolutePath(), (Object)e);
            }
        }
    }

    public static enum FileAction {
        COPY,
        MOVE;

    }

    public static abstract class ConfigComparator {
        public abstract boolean shouldReplace(File var1, File var2);
    }
}

