/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.event;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.util.EntityUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldFileUtils;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;

public class DataTracker {
    private static DataTracker instance;
    private Map<UUID, PlayerData> playerData = new HashMap<UUID, PlayerData>();
    private boolean dirty = false;

    public static DataTracker getInstance() {
        if (instance == null) {
            instance = new DataTracker();
        }
        return instance;
    }

    private PlayerData getOrCreatePlayerData(UUID uuid) {
        PlayerData data = this.playerData.get(uuid);
        if (data == null) {
            data = new PlayerData();
            this.playerData.put(uuid, data);
        }
        return data;
    }

    public void playerLoginOrRespawn(EntityPlayer playerIn) {
        if (EntityUtils.isValidPlayerMP(playerIn)) {
            int dimTo;
            int dimFrom;
            PlayerData data = this.playerData.get(playerIn.func_110124_au());
            if (data != null && (dimFrom = data.dimension) != (dimTo = playerIn.func_130014_f_().field_73011_w.getDimension())) {
                this.playerChangedDimension(playerIn, dimFrom, dimTo);
            }
            this.storePlayerDimension(playerIn);
        }
    }

    public void playerDied(EntityPlayer player) {
        if (player.func_130014_f_().func_72912_H().func_76093_s()) {
            this.getOrCreatePlayerData((UUID)player.func_110124_au()).deadInHardcore = true;
            this.dirty = true;
        }
    }

    public void playerInitialSpawn(EntityPlayer player) {
        UUID uuid = player.func_110124_au();
        if (EntityUtils.isValidPlayerMP(player) && this.dimensionHasForcedGameMode(player.field_71093_bK) && !this.playerData.containsKey(uuid)) {
            PlayerData data = this.getOrCreatePlayerData(uuid);
            data.normalGameMode = Configs.normalGameMode;
            data.dimension = player.field_71093_bK;
            this.dirty = true;
            JustEnoughDimensions.logInfo("DataTracker: Set the \"normal game mode\" of player '{}' to '{}' after their initial join to a ForceGameMode dimension {}", player.func_70005_c_(), Configs.normalGameMode, player.field_71093_bK);
        }
    }

    public void playerChangedDimension(EntityPlayer playerIn, int dimFrom, int dimTo) {
        if (EntityUtils.isValidPlayerMP(playerIn)) {
            this.storePlayerDimension(playerIn);
            if (Configs.enableForcedGameModes) {
                PlayerData data = this.getOrCreatePlayerData(playerIn.func_110124_au());
                if (data.deadInHardcore) {
                    return;
                }
                EntityPlayerMP player = (EntityPlayerMP)playerIn;
                boolean forcedFrom = this.dimensionHasForcedGameMode(dimFrom);
                boolean forcedTo = this.dimensionHasForcedGameMode(dimTo);
                if (forcedTo) {
                    if (!forcedFrom) {
                        this.storeNonForcedGameMode(player);
                    }
                    this.setPlayerGameMode(player, player.func_130014_f_().func_72912_H().func_76077_q());
                    JustEnoughDimensions.logInfo("DataTracker: Set gamemode '{}' for player '{}'", player.field_71134_c.func_73081_b(), player.func_70005_c_());
                } else {
                    this.restoreStoredGameModeIfExists(player);
                }
            }
        }
    }

    private boolean dimensionHasForcedGameMode(int dimension) {
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(dimension);
        return props != null && props.getForceGameMode();
    }

    private void storeNonForcedGameMode(EntityPlayerMP player) {
        this.getOrCreatePlayerData((UUID)player.func_110124_au()).normalGameMode = player.field_71134_c.func_73081_b();
        this.dirty = true;
        JustEnoughDimensions.logInfo("DataTracker: Stored a non-forced gamemode '{}' for player '{}'", player.field_71134_c.func_73081_b(), player.func_70005_c_());
    }

    private void restoreStoredGameModeIfExists(EntityPlayerMP player) {
        PlayerData data = this.getOrCreatePlayerData(player.func_110124_au());
        if (data.normalGameMode != null) {
            this.setPlayerGameMode(player, data.normalGameMode);
            data.normalGameMode = null;
            this.dirty = true;
            JustEnoughDimensions.logInfo("DataTracker: Restored gamemode '{}' for player '{}'", player.field_71134_c.func_73081_b(), player.func_70005_c_());
        }
    }

    private void setPlayerGameMode(EntityPlayerMP player, GameType type) {
        player.func_71033_a(type);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("jed.info.gamemode.changed", new Object[]{type.toString()}));
    }

    private void storePlayerDimension(EntityPlayer player) {
        int dimension;
        this.getOrCreatePlayerData((UUID)player.func_110124_au()).dimension = dimension = player.func_130014_f_().field_73011_w.getDimension();
        this.dirty = true;
        JustEnoughDimensions.logInfo("DataTracker: Stored dimension '{}' for player '{}'", dimension, player.func_70005_c_());
    }

    @Nullable
    public Integer getPlayersDimension(EntityPlayer player) {
        return this.getOrCreatePlayerData((UUID)player.func_110124_au()).dimension;
    }

    public int getPlayerCountInDimension(int dimension) {
        int count = 0;
        for (PlayerData data : this.playerData.values()) {
            if (data.dimension != dimension) continue;
            ++count;
        }
        return count;
    }

    public void readFromDisk(@Nullable File worldDir) {
        File jedDataDir;
        File file;
        this.playerData.clear();
        if (worldDir != null && (file = new File(jedDataDir = WorldFileUtils.getWorldJEDDataDirectory(worldDir), "data_tracker.dat")).exists() && file.isFile() && file.canRead()) {
            try {
                FileInputStream is = new FileInputStream(file);
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)is));
                is.close();
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to read DataTracker data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
    }

    public void writeToDisk() {
        if (this.dirty) {
            try {
                File saveDir = DimensionManager.getCurrentSaveRootDirectory();
                if (saveDir == null) {
                    return;
                }
                File jedDataDir = WorldFileUtils.getWorldJEDDataDirectory(saveDir);
                if (!jedDataDir.exists() && !jedDataDir.mkdirs()) {
                    JustEnoughDimensions.logger.warn("Failed to create the save directory '{}'", (Object)jedDataDir.getAbsolutePath());
                    return;
                }
                NBTTagCompound nbt = this.writeToNBT(new NBTTagCompound());
                ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
                    File fileTmp = new File(jedDataDir, "data_tracker.dat.tmp");
                    File fileReal = new File(jedDataDir, "data_tracker.dat");
                    try {
                        FileOutputStream os = new FileOutputStream(fileTmp);
                        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)os);
                        os.close();
                        if (fileReal.exists()) {
                            fileReal.delete();
                        }
                        fileTmp.renameTo(fileReal);
                    }
                    catch (Exception e) {
                        JustEnoughDimensions.logger.warn("Failed to write DataTracker data to file", (Throwable)e);
                    }
                    return false;
                });
                this.dirty = false;
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to write DataTracker data to file", (Throwable)e);
            }
        }
    }

    private void readFromNBTOld(NBTTagCompound nbt) {
        if (nbt != null) {
            NBTTagCompound tag;
            int i;
            int count;
            NBTTagList tagList;
            if (nbt.func_150297_b("PlayerGameModes", 9)) {
                tagList = nbt.func_150295_c("PlayerGameModes", 10);
                count = tagList.func_74745_c();
                for (i = 0; i < count; ++i) {
                    GameType type;
                    tag = tagList.func_150305_b(i);
                    if (!tag.func_150297_b("UUIDM", 4) || !tag.func_150297_b("UUIDL", 4) || !tag.func_150297_b("GameMode", 1) || (type = GameType.func_77146_a((int)tag.func_74771_c("GameMode"))) == GameType.NOT_SET) continue;
                    this.getOrCreatePlayerData((UUID)new UUID((long)tag.func_74763_f((String)"UUIDM"), (long)tag.func_74763_f((String)"UUIDL"))).normalGameMode = type;
                }
            }
            if (nbt.func_150297_b("PlayerDimensions", 9)) {
                tagList = nbt.func_150295_c("PlayerDimensions", 10);
                count = tagList.func_74745_c();
                for (i = 0; i < count; ++i) {
                    tag = tagList.func_150305_b(i);
                    if (!tag.func_150297_b("UUIDM", 4) || !tag.func_150297_b("UUIDL", 4) || !tag.func_150297_b("Dimension", 3)) continue;
                    this.getOrCreatePlayerData((UUID)new UUID((long)tag.func_74763_f((String)"UUIDM"), (long)tag.func_74763_f((String)"UUIDL"))).dimension = tag.func_74762_e("Dimension");
                }
            }
        }
    }

    private void readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("PlayerData", 9)) {
                NBTTagList tagList = nbt.func_150295_c("PlayerData", 10);
                int count = tagList.func_74745_c();
                for (int i = 0; i < count; ++i) {
                    GameType type;
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    if (!tag.func_150297_b("UUIDM", 4) || !tag.func_150297_b("UUIDL", 4)) continue;
                    PlayerData data = new PlayerData();
                    data.dimension = tag.func_74762_e("Dimension");
                    data.deadInHardcore = tag.func_74767_n("HardcoreDead");
                    if (tag.func_150297_b("GameMode", 1) && (type = GameType.func_77146_a((int)tag.func_74771_c("GameMode"))) != GameType.NOT_SET) {
                        data.normalGameMode = type;
                    }
                    this.playerData.put(new UUID(tag.func_74763_f("UUIDM"), tag.func_74763_f("UUIDL")), data);
                }
            } else {
                this.readFromNBTOld(nbt);
            }
        }
    }

    private NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.entrySet()) {
            PlayerData data = entry.getValue();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("UUIDM", entry.getKey().getMostSignificantBits());
            tag.func_74772_a("UUIDL", entry.getKey().getLeastSignificantBits());
            tag.func_74768_a("Dimension", data.dimension);
            tag.func_74757_a("HardcoreDead", data.deadInHardcore);
            if (data.normalGameMode != null) {
                tag.func_74774_a("GameMode", (byte)data.normalGameMode.func_77148_a());
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("PlayerData", (NBTBase)tagList);
        return nbt;
    }

    private static class PlayerData {
        public boolean deadInHardcore;
        public int dimension;
        @Nullable
        public GameType normalGameMode;

        private PlayerData() {
        }
    }
}

