/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.lang.reflect.Field;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SyncedField<T> {
    private final Field field;
    private final Object te;
    private T lastValue;
    private int arrayIndex = -1;
    private boolean isLazy;
    private Class annotation;

    SyncedField(Object te, Field field) {
        this.field = field;
        field.setAccessible(true);
        this.te = te;
    }

    SyncedField setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
        return this;
    }

    public SyncedField setLazy(boolean lazy) {
        this.isLazy = lazy;
        return this;
    }

    public String toString() {
        return "[" + this.te + "/" + this.field.getName() + "=" + this.getValue() + "]";
    }

    public boolean update() {
        try {
            T value;
            T t = value = this.arrayIndex >= 0 ? this.getValueForArray(this.field.get(this.te), this.arrayIndex) : this.retrieveValue(this.field, this.te);
            if (this.lastValue == null && value != null || this.lastValue != null && !this.equals(this.lastValue, value)) {
                this.lastValue = value == null ? null : this.copyWhenNecessary(value);
                return !this.isLazy;
            }
        }
        catch (Throwable e) {
            Log.error("A problem occurred when trying to sync the field of " + this.te.toString() + ". Field: " + this.field.toString());
            e.printStackTrace();
        }
        return false;
    }

    protected boolean equals(T oldValue, T newValue) {
        return oldValue.equals(newValue);
    }

    protected T copyWhenNecessary(T oldValue) {
        return oldValue;
    }

    protected T retrieveValue(Field field, Object te) throws Exception {
        return (T)field.get(te);
    }

    protected void injectValue(Field field, Object te, T value) throws Exception {
        field.set(te, value);
    }

    protected abstract T getValueForArray(Object var1, int var2);

    protected abstract void setValueForArray(Object var1, int var2, T var3) throws Exception;

    public T getValue() {
        return this.lastValue;
    }

    @SideOnly(value=Side.CLIENT)
    public void setValue(T value) {
        try {
            if (this.arrayIndex >= 0) {
                this.setValueForArray(this.field.get(this.te), this.arrayIndex, value);
            } else {
                this.injectValue(this.field, this.te, value);
            }
        }
        catch (Exception e) {
            Log.error("A problem occurred when trying to sync the field of " + this.te.toString() + ". Field: " + this.field.toString());
            e.printStackTrace();
        }
    }

    public void setAnnotation(Class annotation) {
        this.annotation = annotation;
    }

    public Class getAnnotation() {
        return this.annotation;
    }

    public static class SyncedItemStackHandler
    extends SyncedField<ItemStackHandler> {
        SyncedItemStackHandler(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected ItemStackHandler getValueForArray(Object array, int index) {
            return ((ItemStackHandler[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, ItemStackHandler value) {
            ((ItemStackHandler[])array)[index] = value;
        }

        @Override
        protected ItemStackHandler retrieveValue(Field field, Object te) throws Exception {
            return (ItemStackHandler)field.get(te);
        }

        @Override
        protected void injectValue(Field field, Object te, ItemStackHandler value) throws Exception {
            ItemStackHandler handler = (ItemStackHandler)field.get(te);
            for (int i = 0; i < value.getSlots(); ++i) {
                handler.setStackInSlot(i, value.getStackInSlot(i));
            }
        }

        @Override
        protected boolean equals(ItemStackHandler oldValue, ItemStackHandler newValue) {
            if (oldValue.getSlots() != newValue.getSlots()) {
                return false;
            }
            for (int i = 0; i < oldValue.getSlots(); ++i) {
                if (oldValue.getStackInSlot(i).func_190926_b() && newValue.getStackInSlot(i).func_190926_b()) {
                    return true;
                }
                if (ItemStack.func_179545_c((ItemStack)oldValue.getStackInSlot(i), (ItemStack)newValue.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected ItemStackHandler copyWhenNecessary(ItemStackHandler oldValue) {
            ItemStackHandler result = new ItemStackHandler(oldValue.getSlots());
            for (int i = 0; i < oldValue.getSlots(); ++i) {
                ItemStack stack = oldValue.getStackInSlot(i);
                result.setStackInSlot(i, stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l());
            }
            return result;
        }
    }

    public static class SyncedFluidTank
    extends SyncedField<FluidStack> {
        SyncedFluidTank(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected FluidStack getValueForArray(Object array, int index) {
            return ((FluidTank[])array)[index].getFluid();
        }

        @Override
        protected void setValueForArray(Object array, int index, FluidStack value) {
            ((FluidTank[])array)[index].setFluid(value);
        }

        @Override
        protected FluidStack retrieveValue(Field field, Object te) throws Exception {
            FluidTank tank = (FluidTank)field.get(te);
            return tank.getFluid();
        }

        @Override
        protected void injectValue(Field field, Object te, FluidStack value) throws Exception {
            FluidTank tank = (FluidTank)field.get(te);
            tank.setFluid(value);
        }

        @Override
        protected boolean equals(FluidStack oldValue, FluidStack newValue) {
            return oldValue == null ? newValue == null : oldValue.isFluidStackIdentical(newValue);
        }

        @Override
        protected FluidStack copyWhenNecessary(FluidStack oldValue) {
            return oldValue.copy();
        }
    }

    public static class SyncedItemStack
    extends SyncedField<ItemStack> {
        SyncedItemStack(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected ItemStack getValueForArray(Object array, int index) {
            return ((ItemStack[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, ItemStack value) {
            ((ItemStack[])array)[index] = value;
        }
    }

    public static class SyncedEnum
    extends SyncedField<Byte> {
        SyncedEnum(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Byte getValueForArray(Object array, int index) {
            return ((byte[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Byte value) {
            ((byte[])array)[index] = value;
        }

        @Override
        protected Byte retrieveValue(Field field, Object te) throws Exception {
            Object[] enumTypes = field.getType().getEnumConstants();
            return (byte)ArrayUtils.indexOf((Object[])enumTypes, (Object)field.get(te));
        }

        @Override
        protected void injectValue(Field field, Object te, Byte value) throws Exception {
            if (value == -1) {
                field.set(te, null);
            } else {
                Object enumType = field.getType().getEnumConstants()[value];
                field.set(te, enumType);
            }
        }
    }

    public static class SyncedString
    extends SyncedField<String> {
        SyncedString(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected String getValueForArray(Object array, int index) {
            return ((String[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, String value) {
            ((String[])array)[index] = value;
        }
    }

    public static class SyncedBoolean
    extends SyncedField<Boolean> {
        SyncedBoolean(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Boolean getValueForArray(Object array, int index) {
            return ((boolean[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Boolean value) {
            ((boolean[])array)[index] = value;
        }
    }

    public static class SyncedDouble
    extends SyncedField<Double> {
        SyncedDouble(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Double getValueForArray(Object array, int index) {
            return ((double[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Double value) {
            ((double[])array)[index] = value;
        }
    }

    public static class SyncedFloat
    extends SyncedField<Float> {
        SyncedFloat(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Float getValueForArray(Object array, int index) {
            return Float.valueOf(((float[])array)[index]);
        }

        @Override
        protected void setValueForArray(Object array, int index, Float value) {
            ((float[])array)[index] = value.floatValue();
        }
    }

    public static class SyncedInt
    extends SyncedField<Integer> {
        public SyncedInt(Object te, Field field) {
            super(te, field);
        }

        @Override
        protected Integer getValueForArray(Object array, int index) {
            return ((int[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Integer value) {
            ((int[])array)[index] = value;
        }
    }
}

