/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.inventory.ContainerEnergy;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAerialInterface;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

@SideOnly(value=Side.CLIENT)
public class GuiAerialInterface
extends GuiPneumaticContainerBase<TileEntityAerialInterface> {
    private final GuiButtonSpecial[] modeButtons = new GuiButtonSpecial[3];
    private GuiButtonSpecial xpButton;

    public GuiAerialInterface(InventoryPlayer player, TileEntityAerialInterface te) {
        super(new ContainerEnergy(player, te), te, "pneumaticcraft:textures/gui/gui_pressure_chamber.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingRF.info.title", Textures.GUI_BUILDCRAFT_ENERGY, -6282718, false).setText("gui.tab.info.aerialInterface.interfacingRF.info");
        if (((TileEntityAerialInterface)this.te).hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)((TileEntityAerialInterface)this.te).getCapability(CapabilityEnergy.ENERGY, null);
            this.addWidget(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, storage));
        }
        if (((TileEntityAerialInterface)this.te).dispenserUpgradeInserted) {
            if (PneumaticCraftAPIHandler.getInstance().liquidXPs.size() > 0) {
                GuiAnimatedStat xpStat = this.addAnimatedStat("gui.tab.info.aerialInterface.liquidXp.info.title", new ItemStack(Items.field_151062_by), -11141291, false);
                xpStat.setText(this.getLiquidXPText());
                this.xpButton = new GuiButtonSpecial(4, 20, 15, 20, 20, "");
                this.xpButton.setListener(this);
                this.setupXPButton();
                xpStat.addWidget(this.xpButton);
            }
            GuiAnimatedStat optionStat = this.addAnimatedStat("gui.tab.aerialInterface.feedMode", new ItemStack(Items.field_151082_bd), -13312, false);
            optionStat.addPadding(4, 16);
            GuiButtonSpecial button = new GuiButtonSpecial(1, 5, 20, 20, 20, "");
            button.setRenderStacks(new ItemStack(Items.field_151082_bd));
            button.setTooltipText(I18n.func_135052_a((String)"gui.tab.aerialInterface.feedMode.feedFullyUtilize", (Object[])new Object[0]));
            optionStat.addWidget(button);
            this.modeButtons[0] = button;
            button = new GuiButtonSpecial(2, 30, 20, 20, 20, "");
            button.setRenderStacks(new ItemStack(Items.field_151034_e));
            button.setTooltipText(I18n.func_135052_a((String)"gui.tab.aerialInterface.feedMode.feedWhenPossible", (Object[])new Object[0]));
            optionStat.addWidget(button);
            this.modeButtons[1] = button;
            button = new GuiButtonSpecial(3, 55, 20, 20, 20, "");
            button.setRenderStacks(new ItemStack(Items.field_151153_ao));
            button.setTooltipText(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.tab.aerialInterface.feedMode.utilizeFullHealthElsePossible", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
            optionStat.addWidget(button);
            this.modeButtons[2] = button;
            this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingFood", new ItemStack(Items.field_151025_P), -6250336, false).setText("gui.tab.info.aerialInterface.removeDispenser");
        } else {
            this.addAnimatedStat("gui.tab.info.aerialInterface.interfacingItems", new ItemStack((Block)Blocks.field_150486_ae), -6250336, false).setText("gui.tab.info.aerialInterface.insertDispenser");
            for (int i = 0; i < this.modeButtons.length; ++i) {
                this.modeButtons[i] = null;
            }
        }
    }

    @Override
    protected boolean shouldAddSideConfigTabs() {
        return !((TileEntityAerialInterface)this.te).dispenserUpgradeInserted;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (((TileEntityAerialInterface)this.te).dispenserUpgradeInserted) {
            if (this.modeButtons[0] != null) {
                for (int i = 0; i < this.modeButtons.length; ++i) {
                    this.modeButtons[i].field_146124_l = ((TileEntityAerialInterface)this.te).feedMode != i;
                }
            } else {
                this.refreshScreen();
            }
        } else if (this.modeButtons[0] != null) {
            this.refreshScreen();
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget.getID() == 4) {
            ++((TileEntityAerialInterface)this.te).curXPFluidIndex;
            if (((TileEntityAerialInterface)this.te).curXPFluidIndex >= PneumaticCraftAPIHandler.getInstance().availableLiquidXPs.size()) {
                ((TileEntityAerialInterface)this.te).curXPFluidIndex = -1;
            }
            this.setupXPButton();
        }
        super.actionPerformed(widget);
    }

    private void setupXPButton() {
        Fluid fluid;
        Fluid fluid2 = fluid = ((TileEntityAerialInterface)this.te).curXPFluidIndex >= 0 && ((TileEntityAerialInterface)this.te).curXPFluidIndex < PneumaticCraftAPIHandler.getInstance().availableLiquidXPs.size() ? PneumaticCraftAPIHandler.getInstance().availableLiquidXPs.get(((TileEntityAerialInterface)this.te).curXPFluidIndex) : null;
        if (fluid != null) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            this.xpButton.setRenderStacks(FluidUtil.getFilledBucket((FluidStack)fluidStack));
            String modname = ModNameCache.getModName(FluidRegistry.getModId((FluidStack)fluidStack));
            this.xpButton.setTooltipText((List<String>)ImmutableList.of((Object)fluid.getLocalizedName(fluidStack), (Object)(TextFormatting.BLUE.toString() + TextFormatting.ITALIC + modname)));
        } else {
            this.xpButton.setRenderStacks(new ItemStack(Items.field_151133_ar));
            this.xpButton.setTooltipText(I18n.func_135052_a((String)"gui.tooltip.aerial_interface.xpDisabled", (Object[])new Object[0]));
        }
    }

    private List<String> getLiquidXPText() {
        ArrayList<String> liquidXpText = new ArrayList<String>();
        liquidXpText.add("");
        liquidXpText.add("");
        liquidXpText.add("");
        liquidXpText.add("gui.tab.info.aerialInterface.liquidXp.info");
        liquidXpText.add("");
        if (PneumaticCraftAPIHandler.getInstance().availableLiquidXPs.isEmpty()) {
            liquidXpText.add(TextFormatting.ITALIC + "None");
        } else {
            for (Fluid f : PneumaticCraftAPIHandler.getInstance().availableLiquidXPs) {
                FluidStack stack = new FluidStack(f, 1000);
                String modId = FluidRegistry.getModId((FluidStack)stack);
                liquidXpText.add(TextFormatting.BLACK + "\u2022  " + f.getLocalizedName(stack) + " (" + ModNameCache.getModName(modId) + ")");
            }
        }
        return liquidXpText;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 53, 19, 0x404040);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityAerialInterface)this.te).getPressure() > 10.0f && ((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            pressureStatText.add(TextFormatting.GRAY + "Usage:");
            pressureStatText.add(TextFormatting.BLACK + PneumaticCraftUtils.roundNumberTo(1.0f, 1) + " mL/tick.");
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityAerialInterface)this.te).playerName.equals("")) {
            textList.add("\u00a7No player set!");
            textList.add(TextFormatting.BLACK + "Break and replace the machine.");
        } else if (!((TileEntityAerialInterface)this.te).isConnectedToPlayer) {
            textList.add(TextFormatting.GRAY + ((TileEntityAerialInterface)this.te).playerName + " is not online!");
            textList.add(TextFormatting.BLACK + "The Aerial Interface is non-functional");
            textList.add(TextFormatting.BLACK + "until they return.");
        }
    }

    @Override
    protected void addInformation(List<String> curInfo) {
        if (((TileEntityAerialInterface)this.te).playerName != null && !((TileEntityAerialInterface)this.te).playerName.isEmpty()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.aerialInterface.linked", (Object[])new Object[]{((TileEntityAerialInterface)this.te).playerName}));
        }
    }
}

