/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.bloodmagic;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileAltar;
import ipsis.Woot;
import ipsis.woot.plugins.bloodmagic.BloodMagicHelper;
import ipsis.woot.plugins.bloodmagic.IBloodMagicHandler;
import ipsis.woot.tileentity.TileEntityMobFactoryHeart;
import ipsis.woot.util.DebugSetup;
import java.util.function.Consumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

@RitualRegister(value="ritualLifeEssenceAltar")
public class RitualLifeEssenceAltar
extends Ritual {
    private static final String RITUAL_NAME = "ritualLifeEssenceAltar";
    private static final int CRYSTAL_LEVEL = 0;
    private static final int ACTIVATION_COST = 40000;
    private static final int REFRESH_COST = 2;
    private static final int REFRESH_TIME = 40;
    private static final String ALTAR_RANGE = "altar";
    private static final String HEART_RANGE = "heart";
    private BlockPos altarOffsetPos = new BlockPos(0, 0, 0);
    private BlockPos heartOffsetPos = new BlockPos(0, 0, 0);

    private TileAltar findAltar(World world, BlockPos pos) {
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = this.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        return tile instanceof TileAltar ? (TileAltar)tile : null;
    }

    private boolean isValidFactory(TileEntity te) {
        if (!(te instanceof TileEntityMobFactoryHeart)) {
            return false;
        }
        TileEntityMobFactoryHeart heart = (TileEntityMobFactoryHeart)te;
        return heart.getRunning() == 1;
    }

    private IBloodMagicHandler findHandler(World world, BlockPos pos) {
        BlockPos heartPos = pos.func_177971_a((Vec3i)this.heartOffsetPos);
        TileEntity te = world.func_175625_s(heartPos);
        AreaDescriptor heartRange = this.getBlockRange(HEART_RANGE);
        if (!heartRange.isWithinArea(this.heartOffsetPos) || !this.isValidFactory(te)) {
            for (BlockPos newPos : heartRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof IBloodMagicHandler)) continue;
                te = nextTile;
                this.heartOffsetPos = newPos.func_177973_b((Vec3i)pos);
                heartRange.resetCache();
                break;
            }
        }
        return this.isValidFactory(te) && te instanceof IBloodMagicHandler ? (IBloodMagicHandler)te : null;
    }

    public RitualLifeEssenceAltar() {
        super(RITUAL_NAME, 0, 40000, "ritual.woot.ritualLifeEssenceAltar");
        this.addBlockRange(ALTAR_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(HEART_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(HEART_RANGE, 0, 15, 15);
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceAltar", "");
        if (!BloodMagicHelper.canPerformRitual(masterRitualStone, this.getRefreshCost())) {
            return;
        }
        World world = masterRitualStone.getWorldObj();
        int maxEffects = masterRitualStone.getOwnerNetwork().getCurrentEssence() / this.getRefreshCost();
        int totalEffects = 0;
        TileAltar tileAltar = this.findAltar(world, masterRitualStone.getBlockPos());
        IBloodMagicHandler bloodMagicHandler = this.findHandler(world, masterRitualStone.getBlockPos());
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceAltar", tileAltar + "/" + bloodMagicHandler);
        if (tileAltar != null && bloodMagicHandler != null && bloodMagicHandler.getAltarSacrificeNumMobs() > 0 && bloodMagicHandler.getWootMobName() != null) {
            int lifeEssenceRatio = BloodMagicHelper.getLifeEssenceRatio(bloodMagicHandler.getWootMobName());
            if (lifeEssenceRatio > 0) {
                int p = bloodMagicHandler.getAltarSacrificePercentage();
                int scaledLifeEssenceRatio = (int)((float)lifeEssenceRatio / 100.0f * (float)p);
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceAltar", bloodMagicHandler.getWootMobName() + "*" + bloodMagicHandler.getAltarSacrificeNumMobs());
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceAltar", "lifeEssenceRatio:" + lifeEssenceRatio + " scaledLifeEssenceRation:" + scaledLifeEssenceRatio + "/" + p);
                for (int c = 0; c < bloodMagicHandler.getAltarSacrificeNumMobs(); ++c) {
                    Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceAltar", "sacrificialDaggerCall:" + scaledLifeEssenceRatio);
                    tileAltar.sacrificialDaggerCall(scaledLifeEssenceRatio, true);
                    if (++totalEffects >= maxEffects) break;
                }
            }
            bloodMagicHandler.clearAltarSacrificeNumMobs();
        }
        masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost() * totalEffects);
    }

    public int getRefreshCost() {
        return 2;
    }

    public int getRefreshTime() {
        return 40;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 4, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 1, EnumRuneType.AIR);
        this.addCornerRunes(components, 1, 2, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
    }

    public Ritual getNewCopy() {
        return new RitualLifeEssenceAltar();
    }
}

