/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.customdrops;

import ipsis.woot.loot.repository.ILootRepositoryLookup;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.WootMobName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CustomDropsRepository
implements ILootRepositoryLookup {
    private List<CustomDrop> drops = new ArrayList<CustomDrop>();

    @Override
    public List<ILootRepositoryLookup.LootItemStack> getDrops(WootMobName wootMobName, EnumEnchantKey key) {
        ArrayList<ILootRepositoryLookup.LootItemStack> lootDrops = new ArrayList<ILootRepositoryLookup.LootItemStack>();
        for (CustomDrop customDrop : this.drops) {
            if (!customDrop.wootMobName.equals(wootMobName)) continue;
            ILootRepositoryLookup.LootItemStack lootItemStack = new ILootRepositoryLookup.LootItemStack(customDrop.itemStack.func_77946_l());
            lootItemStack.sizes.put(customDrop.sizeMap.get((Object)key), customDrop.chanceMap.get((Object)key));
            lootItemStack.dropChance = customDrop.chanceMap.get((Object)key);
            lootDrops.add(lootItemStack);
        }
        return lootDrops;
    }

    @Override
    public List<String> getAllMobs() {
        ArrayList<String> mobs = new ArrayList<String>();
        for (CustomDrop customDrop : this.drops) {
            mobs.add(customDrop.wootMobName.getName());
        }
        return mobs;
    }

    public void addDrop(WootMobName wootMobName, ItemStack itemStack, List<Integer> chances, List<Integer> sizes) {
        if (chances.size() != 4 || sizes.size() != 4) {
            LogHelper.error("Chances and size arrays must have four entries each - " + wootMobName + "/" + itemStack);
            return;
        }
        CustomDrop customDrop = new CustomDrop(wootMobName, itemStack, chances, sizes);
        this.drops.add(customDrop);
        LogHelper.info("Added custom drop " + itemStack.func_82833_r() + " for " + wootMobName);
    }

    private class CustomDrop {
        WootMobName wootMobName;
        ItemStack itemStack;
        HashMap<EnumEnchantKey, Integer> chanceMap = new HashMap();
        HashMap<EnumEnchantKey, Integer> sizeMap = new HashMap();

        public CustomDrop(WootMobName wootMobName, ItemStack itemStack, List<Integer> chances, List<Integer> sizes) {
            this.wootMobName = wootMobName;
            this.itemStack = itemStack.func_77946_l();
            this.chanceMap.put(EnumEnchantKey.NO_ENCHANT, chances.get(0));
            this.chanceMap.put(EnumEnchantKey.LOOTING_I, chances.get(1));
            this.chanceMap.put(EnumEnchantKey.LOOTING_II, chances.get(2));
            this.chanceMap.put(EnumEnchantKey.LOOTING_III, chances.get(3));
            this.sizeMap.put(EnumEnchantKey.NO_ENCHANT, sizes.get(0));
            this.sizeMap.put(EnumEnchantKey.LOOTING_I, sizes.get(1));
            this.sizeMap.put(EnumEnchantKey.LOOTING_II, sizes.get(2));
            this.sizeMap.put(EnumEnchantKey.LOOTING_III, sizes.get(3));
        }
    }
}

