/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.handler.SpellHandler;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemStaff;
import epicsquid.roots.network.fx.MessageImbueCompleteFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.FakeSpellRunicDust;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.modules.ModuleRegistry;
import epicsquid.roots.spell.modules.SpellModule;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityImbuer
extends TileBase
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityImbuer.this.func_70296_d();
            if (!((TileEntityImbuer)TileEntityImbuer.this).field_145850_b.field_72995_K) {
                TileEntityImbuer.this.updatePacketViaState();
            }
        }
    };
    int progress = 0;
    public float angle = 0.0f;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        this.progress = tag.func_74762_e("progress");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            ItemStack attemptedInsert;
            ItemStack toInsert;
            if (heldItem.func_77973_b() == ModItems.spell_dust || heldItem.func_77973_b() == ModItems.runic_dust) {
                if (this.inventory.getStackInSlot(0).func_190926_b()) {
                    toInsert = heldItem.func_77946_l();
                    toInsert.func_190920_e(1);
                    attemptedInsert = this.inventory.insertItem(0, toInsert, false);
                    if (attemptedInsert.func_190926_b()) {
                        player.func_184586_b(hand).func_190918_g(1);
                        this.func_70296_d();
                        this.updatePacketViaState();
                        return true;
                    }
                }
            } else if (heldItem.func_77973_b() == ModItems.staff || ModuleRegistry.isModule(heldItem)) {
                if (heldItem.func_77973_b() == ModItems.staff) {
                    SpellHandler cap = SpellHandler.fromStack(heldItem);
                    if (!cap.hasFreeSlot() && this.inventory.getStackInSlot(0).func_77973_b() != ModItems.runic_dust) {
                        if (world.field_72995_K) {
                            player.func_145747_a(new TextComponentTranslation("roots.info.staff.no_slots", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
                        }
                        return true;
                    }
                    if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.runic_dust && cap.getSelectedSpell() == null) {
                        if (world.field_72995_K) {
                            player.func_145747_a(new TextComponentTranslation("roots.info.staff.empty_slot", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
                        }
                        return true;
                    }
                }
                if (this.inventory.getStackInSlot(1).func_190926_b()) {
                    toInsert = heldItem.func_77946_l();
                    toInsert.func_190920_e(1);
                    attemptedInsert = this.inventory.insertItem(1, toInsert, true);
                    if (attemptedInsert.func_190926_b()) {
                        this.inventory.insertItem(1, toInsert, false);
                        player.func_184586_b(hand).func_190918_g(1);
                        if (player.func_184586_b(hand).func_190916_E() == 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        this.func_70296_d();
                        this.updatePacketViaState();
                        return true;
                    }
                }
            }
        }
        if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!this.dropItemInInventory(this.inventory, i)) continue;
                return true;
            }
        }
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public void func_73660_a() {
        this.angle += 1.0f;
        if (!this.inventory.getStackInSlot(0).func_190926_b() && !this.inventory.getStackInSlot(1).func_190926_b()) {
            ++this.progress;
            this.angle += 2.0f;
            ItemStack spellDust = this.inventory.getStackInSlot(0);
            boolean clearSlot = spellDust.func_77973_b() == ModItems.runic_dust;
            SpellHandler capability = SpellHandler.fromStack(spellDust);
            if (capability.getSelectedSpell() != null || clearSlot) {
                SpellBase spell = clearSlot ? new FakeSpellRunicDust() : capability.getSelectedSpell();
                if (this.field_145850_b.field_72995_K) {
                    if (Util.rand.nextInt(2) == 0) {
                        ParticleUtil.spawnParticleLineGlow(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.125f, (float)this.func_174877_v().func_177952_p() + 0.5f, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.0f, (float)this.func_174877_v().func_177952_p() + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), spell.getRed1(), spell.getGreen1(), spell.getBlue1(), 0.25f, 4.0f, 40);
                    } else {
                        ParticleUtil.spawnParticleLineGlow(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.125f, (float)this.func_174877_v().func_177952_p() + 0.5f, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.0f, (float)this.func_174877_v().func_177952_p() + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), spell.getRed2(), spell.getGreen2(), spell.getBlue2(), 0.25f, 4.0f, 40);
                    }
                }
            }
            if (this.progress > 200) {
                this.progress = 0;
                if (!this.field_145850_b.field_72995_K) {
                    if (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.staff) {
                        SpellBase spell;
                        ItemStack staff = this.inventory.getStackInSlot(1);
                        if (!clearSlot && capability.getSelectedSpell() != null) {
                            ItemStaff.createData(staff, capability);
                            spell = capability.getSelectedSpell();
                        } else {
                            ItemStaff.clearData(staff);
                            spell = new FakeSpellRunicDust();
                        }
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, staff));
                        this.inventory.extractItem(0, 1, false);
                        this.inventory.extractItem(1, 1, false);
                        this.func_70296_d();
                        this.updatePacketViaState();
                        PacketHandler.sendToAllTracking((IMessage)new MessageImbueCompleteFX(spell.getName(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5), (TileEntity)this);
                    } else {
                        ItemStack stack = this.inventory.getStackInSlot(1);
                        SpellModule module = ModuleRegistry.getModule(stack);
                        capability.addModule(module);
                        this.inventory.extractItem(1, 1, false);
                        this.func_70296_d();
                        this.updatePacketViaState();
                        PacketHandler.sendToAllTracking((IMessage)new MessageImbueCompleteFX(capability.getSelectedSpell().getName(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5), (TileEntity)this);
                    }
                }
            }
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.updatePacketViaState();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.updatePacketViaState();
            }
        }
    }
}

