/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.util.ListUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.api.Herb;
import epicsquid.roots.handler.SpellHandler;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.spell.modules.SpellModule;
import epicsquid.roots.util.PowderInventoryUtil;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SpellBase {
    private float red1;
    private float green1;
    private float blue1;
    private float red2;
    private float green2;
    private float blue2;
    private String name;
    protected int cooldown = 20;
    private TextFormatting textColor;
    protected EnumCastType castType = EnumCastType.INSTANTANEOUS;
    private Object2DoubleOpenHashMap<Herb> costs = new Object2DoubleOpenHashMap();
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private List<SpellModule> acceptedModules = new ArrayList<SpellModule>();
    private List<ItemStack> moduleItems = null;

    public SpellBase(String name, TextFormatting textColor, float r1, float g1, float b1, float r2, float g2, float b2) {
        this.name = name;
        this.red1 = r1;
        this.green1 = g1;
        this.blue1 = b1;
        this.red2 = r2;
        this.green2 = g2;
        this.blue2 = b2;
        this.textColor = textColor;
    }

    public boolean hasModules() {
        return !this.acceptedModules.isEmpty();
    }

    public SpellBase acceptModules(SpellModule ... modules) {
        assert (modules.length < 5);
        this.acceptedModules.addAll(Arrays.asList(modules));
        return this;
    }

    public List<SpellModule> getModules() {
        return this.acceptedModules;
    }

    public SpellBase addIngredients(Object ... stacks) {
        for (Object stack : stacks) {
            if (stack instanceof ItemStack) {
                this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)stack}));
                continue;
            }
            if (!(stack instanceof Ingredient)) continue;
            this.ingredients.add((Ingredient)stack);
        }
        return this;
    }

    public boolean costsMet(EntityPlayer player) {
        boolean matches = true;
        for (Map.Entry entry : this.costs.entrySet()) {
            double r;
            Herb herb = (Herb)((Object)entry.getKey());
            double d = (Double)entry.getValue();
            if (!matches || (matches = (r = PowderInventoryUtil.getPowderTotal(player, herb)) >= d) || player.func_184812_l_()) continue;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("roots.info.pouch.no_herbs", new Object[]{new TextComponentTranslation(String.format("item.%s.name", herb.getName()), new Object[0])}), true);
        }
        return matches && this.costs.size() > 0 || player.field_71075_bZ.field_75098_d;
    }

    public void enactCosts(EntityPlayer player) {
        for (Map.Entry entry : this.costs.entrySet()) {
            Herb herb = (Herb)((Object)entry.getKey());
            double d = (Double)entry.getValue();
            PowderInventoryUtil.removePowder(player, herb, d);
        }
    }

    public void enactTickCosts(EntityPlayer player) {
        for (Map.Entry entry : this.costs.entrySet()) {
            Herb herb = (Herb)((Object)entry.getKey());
            double d = (Double)entry.getValue();
            PowderInventoryUtil.removePowder(player, herb, d / 20.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolTip(List<String> tooltip) {
        String prefix = "roots.spell." + this.name;
        tooltip.add("" + this.textColor + TextFormatting.BOLD + I18n.func_135052_a((String)(prefix + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
        for (Map.Entry entry : this.costs.entrySet()) {
            Herb herb = (Herb)((Object)entry.getKey());
            String d = String.format("%.4f", entry.getValue());
            tooltip.add(I18n.func_135052_a((String)(herb.getItem().func_77658_a() + ".name"), (Object[])new Object[0]) + I18n.func_135052_a((String)"roots.tooltip.pouch_divider", (Object[])new Object[0]) + d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getModuleStacks() {
        if (this.moduleItems == null) {
            this.moduleItems = new ArrayList<ItemStack>();
            String prefix = "roots.spell." + this.name + ".";
            String mod = I18n.func_135052_a((String)"roots.spell.module.description", (Object[])new Object[0]);
            for (SpellModule module : this.getModules()) {
                ItemStack stack = module.getIngredient().func_77946_l();
                String description = I18n.func_135052_a((String)(prefix + module.getName() + ".description"), (Object[])new Object[0]);
                Util.appendLoreTag((ItemStack)stack, (String[])new String[]{mod, description});
                this.moduleItems.add(stack);
            }
        }
        return this.moduleItems;
    }

    public SpellBase addCost(Herb herb, double amount) {
        if (herb == null) {
            System.out.println("Spell - " + this.getClass().getName() + " - added a null herb ingredient. This is a bug.");
            return this;
        }
        this.costs.put((Object)herb, amount);
        return this;
    }

    public boolean matchesIngredients(List<ItemStack> ingredients) {
        return ListUtil.matchesIngredients(ingredients, this.ingredients);
    }

    public abstract boolean cast(EntityPlayer var1, List<SpellModule> var2);

    public float getRed1() {
        return this.red1;
    }

    public float getGreen1() {
        return this.green1;
    }

    public float getBlue1() {
        return this.blue1;
    }

    public float getRed2() {
        return this.red2;
    }

    public float getGreen2() {
        return this.green2;
    }

    public float getBlue2() {
        return this.blue2;
    }

    public String getName() {
        return this.name;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public TextFormatting getTextColor() {
        return this.textColor;
    }

    public EnumCastType getCastType() {
        return this.castType;
    }

    public Object2DoubleOpenHashMap<Herb> getCosts() {
        return this.costs;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public ItemStack getResult() {
        ItemStack stack = new ItemStack(ModItems.spell_dust);
        SpellHandler.fromStack(stack).setSpellToSlot(this);
        return stack;
    }

    public List<ItemStack> getCostItems() {
        return this.costs.keySet().stream().map(herb -> new ItemStack(herb.getItem())).collect(Collectors.toList());
    }

    public static enum EnumCastType {
        INSTANTANEOUS,
        CONTINUOUS;

    }
}

