/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network;

import epicsquid.roots.handler.SpellHandler;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.spell.SpellBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageServerUpdateStaff
implements IMessage {
    private int opcode = -1;

    public MessageServerUpdateStaff() {
    }

    public MessageServerUpdateStaff(int opcode) {
        this.opcode = opcode;
    }

    public void fromBytes(ByteBuf buf) {
        this.opcode = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.opcode);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public static class MessageHolder
    implements IMessageHandler<MessageServerUpdateStaff, IMessage> {
        public IMessage onMessage(MessageServerUpdateStaff message, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.handleMessage(message, ctx));
            return null;
        }

        private void handleMessage(MessageServerUpdateStaff message, MessageContext ctx) {
            int opcode = message.getOpcode();
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack staff = null;
            for (ItemStack s : player.func_184214_aD()) {
                if (s.func_77973_b() != ModItems.staff) continue;
                staff = s;
                break;
            }
            if (staff == null) {
                return;
            }
            SpellHandler handler = SpellHandler.fromStack(staff);
            if (opcode < 50) {
                int slot = opcode - 1;
                if (handler.getSpellInSlot(slot) != null) {
                    handler.setSelectedSlot(slot);
                }
            } else if (opcode == 50) {
                handler.nextSlot();
            } else if (opcode == 60) {
                handler.previousSlot();
            } else {
                return;
            }
            SpellBase spell = handler.getSelectedSpell();
            player.func_145747_a(new TextComponentTranslation("roots.info.staff.slot_and_spell", new Object[]{handler.getSelectedSlot() + 1, spell == null ? "none" : new TextComponentTranslation("roots.spell." + spell.getName() + ".name", new Object[0]).func_150255_a(new Style().func_150238_a(spell.getTextColor()).func_150227_a(Boolean.valueOf(true)))}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }
    }
}

