/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.EventManager;
import epicsquid.roots.event.SpellEvent;
import epicsquid.roots.handler.SpellHandler;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.modules.SpellModule;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemStaff
extends ItemBase {
    public ItemStaff(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        SpellHandler oldCapability = SpellHandler.fromStack(oldStack);
        SpellHandler newCapability = SpellHandler.fromStack(newStack);
        if (oldCapability != null && newCapability != null) {
            return slotChanged || oldCapability.getSelectedSlot() != newCapability.getSelectedSlot();
        }
        return slotChanged;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        SpellBase spell;
        ItemStack stack = player.func_184586_b(hand);
        SpellHandler capability = SpellHandler.fromStack(stack);
        if (player.func_70093_af()) {
            capability.nextSlot();
            if (world.field_72995_K) {
                SpellBase spell2 = capability.getSelectedSpell();
                player.func_146105_b(new TextComponentTranslation("roots.info.staff.slot_and_spell", new Object[]{capability.getSelectedSlot() + 1, spell2 == null ? "none" : new TextComponentTranslation("roots.spell." + spell2.getName() + ".name", new Object[0]).func_150255_a(new Style().func_150238_a(spell2.getTextColor()).func_150227_a(Boolean.valueOf(true)))}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)), true);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (capability.getCooldown() <= 0 && (spell = capability.getSelectedSpell()) != null) {
            SpellEvent event = new SpellEvent(player, spell);
            MinecraftForge.EVENT_BUS.post((Event)event);
            spell = event.getSpell();
            if (spell.getCastType() == SpellBase.EnumCastType.INSTANTANEOUS) {
                if (spell.costsMet(player)) {
                    boolean result = spell.cast(player, capability.getSelectedModules());
                    if (result && !player.field_71075_bZ.field_75098_d) {
                        spell.enactCosts(player);
                        capability.setCooldown(event.getCooldown());
                        capability.setLastCooldown(event.getCooldown());
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
            } else if (spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        boolean result;
        SpellBase spell;
        SpellHandler capability = SpellHandler.fromStack(stack);
        if (player instanceof EntityPlayer && capability.getCooldown() <= 0 && (spell = capability.getSelectedSpell()) != null && spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS && spell.costsMet((EntityPlayer)player) && (result = spell.cast((EntityPlayer)player, capability.getSelectedModules()))) {
            spell.enactTickCosts((EntityPlayer)player);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        SpellBase spell = capability.getSelectedSpell();
        if (spell != null) {
            SpellEvent event = new SpellEvent((EntityPlayer)entity, spell);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                capability.setCooldown(event.getCooldown());
                capability.setLastCooldown(event.getCooldown());
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        if (capability.getCooldown() > 0) {
            capability.setCooldown(capability.getCooldown() - 1);
            if (capability.getCooldown() <= 0) {
                capability.setCooldown(0);
                capability.setLastCooldown(0);
            }
        }
    }

    public static void createData(ItemStack stack, SpellHandler dustCapability) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        capability.setSpellToSlot(dustCapability.getSelectedSpell());
        for (SpellModule module : dustCapability.getSelectedModules()) {
            capability.addModule(module);
        }
    }

    public static void clearData(ItemStack stack) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        capability.clearSelectedSlot();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        tooltip.add(I18n.func_135052_a((String)"roots.tooltip.staff.selected", (Object[])new Object[0]) + (capability.getSelectedSlot() + 1));
        SpellBase spell = capability.getSelectedSpell();
        if (spell != null) {
            tooltip.add("");
            spell.addToolTip(tooltip);
            List<SpellModule> spellModules = capability.getSelectedModules();
            if (!spellModules.isEmpty()) {
                tooltip.add(I18n.func_135052_a((String)"roots.spell.module.description", (Object[])new Object[0]));
                String prefix = "roots.spell." + spell.getName();
                for (SpellModule module : spellModules) {
                    tooltip.add(module.getFormat() + I18n.func_135052_a((String)("roots.spell.module." + module.getName() + ".name"), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(prefix + "." + module.getName() + ".description"), (Object[])new Object[0]));
                }
            }
        } else {
            tooltip.add("");
            tooltip.add("No spell.");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add("");
            for (int i = 0; i < 5; ++i) {
                SpellBase other = capability.getSpellInSlot(i);
                if (other == null) {
                    tooltip.add("" + (i + 1) + ": No spell.");
                    continue;
                }
                tooltip.add("" + (i + 1) + ": " + other.getTextColor() + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + other.getName() + ".name"), (Object[])new Object[0]));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        SpellBase spell = capability.getSelectedSpell();
        return capability.getCooldown() > 0 && spell != null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        SpellBase spell = capability.getSelectedSpell();
        if (spell != null) {
            double factor = 0.5 * (Math.sin(6.0 * Math.toRadians((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak())) + 1.0);
            return Util.intColor((int)((int)(255.0 * ((double)spell.getRed1() * factor + (double)spell.getRed2() * (1.0 - factor)))), (int)((int)(255.0 * ((double)spell.getGreen1() * factor + (double)spell.getGreen2() * (1.0 - factor)))), (int)((int)(255.0 * ((double)spell.getBlue1() * factor + (double)spell.getBlue2() * (1.0 - factor)))));
        }
        return Util.intColor((int)255, (int)255, (int)255);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        return (double)capability.getCooldown() / (double)capability.getLastCooldown();
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        SpellBase spell = capability.getSelectedSpell();
        if (spell != null) {
            if (spell.getCastType() == SpellBase.EnumCastType.CONTINUOUS) {
                return EnumAction.BOW;
            }
            return EnumAction.NONE;
        }
        return EnumAction.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName().toString()), new ModelResourceLocation(this.getRegistryName().toString() + "_1")});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            SpellHandler capability;
            ResourceLocation baseName = this.getRegistryName();
            if (stack.func_82833_r().compareToIgnoreCase("Shiny Rod") == 0) {
                baseName = new ResourceLocation("roots:shiny_rod");
            }
            if (stack.func_82833_r().compareToIgnoreCase("Cutie Moon Rod") == 0) {
                baseName = new ResourceLocation("roots:moon_rod");
            }
            if ((capability = SpellHandler.fromStack(stack)).hasSpellInSlot()) {
                String s = capability.getSelectedSpell().getName();
                if (SpellRegistry.spellRegistry.containsKey(s)) {
                    return new ModelResourceLocation(baseName.toString() + "_1");
                }
                return new ModelResourceLocation(baseName.toString());
            }
            return new ModelResourceLocation(baseName.toString());
        });
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        SpellHandler capability = SpellHandler.fromStack(stack);
        String additional = capability.formatSelectedSpell();
        if (additional != null) {
            return displayName + " " + additional;
        }
        return displayName;
    }

    public static class StaffColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            SpellHandler capability = SpellHandler.fromStack(stack);
            if (capability.hasSpellInSlot() && stack.func_77973_b() instanceof ItemStaff) {
                if (stack.func_82833_r().compareToIgnoreCase("Shiny Rod") == 0 || stack.func_82833_r().compareToIgnoreCase("Cutie Moon Rod") == 0) {
                    SpellBase spell = capability.getSelectedSpell();
                    if (spell != null) {
                        if (tintIndex == 0) {
                            int r = (int)(255.0f * spell.getRed1());
                            int g = (int)(255.0f * spell.getGreen1());
                            int b = (int)(255.0f * spell.getBlue1());
                            return (r << 16) + (g << 8) + b;
                        }
                        if (tintIndex == 1) {
                            int r = (int)(255.0f * spell.getRed2());
                            int g = (int)(255.0f * spell.getGreen2());
                            int b = (int)(255.0f * spell.getBlue2());
                            return (r << 16) + (g << 8) + b;
                        }
                    }
                    return Util.intColor((int)255, (int)255, (int)255);
                }
                SpellBase spell = capability.getSelectedSpell();
                if (tintIndex == 1) {
                    int r = (int)(255.0f * spell.getRed1());
                    int g = (int)(255.0f * spell.getGreen1());
                    int b = (int)(255.0f * spell.getBlue1());
                    return (r << 16) + (g << 8) + b;
                }
                if (tintIndex == 2) {
                    int r = (int)(255.0f * spell.getRed2());
                    int g = (int)(255.0f * spell.getGreen2());
                    int b = (int)(255.0f * spell.getBlue2());
                    return (r << 16) + (g << 8) + b;
                }
                return Util.intColor((int)255, (int)255, (int)255);
            }
            return Util.intColor((int)255, (int)255, (int)255);
        }
    }
}

