/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.RunicShears")
@ZenDocAppend(value={"docs/include/runic_shears.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.RunicShears")
public class RunicShearsTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe being created"), @ZenDocArg(arg="outputDrop", info="the item output obtained by performing the shearing"), @ZenDocArg(arg="replacementBlock", info="the block (as an itemstack) that replaces the block being interacted with upon shearing"), @ZenDocArg(arg="inputBlock", info="the block that is to be sheared"), @ZenDocArg(arg="jeiDisplayItem", info="the item that should be displayed in JEI for this recipe")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack outputDrop, IItemStack replacementBlock, IItemStack inputBlock, IItemStack jeiDisplayItem) {
        if (!InputHelper.isABlock((IItemStack)inputBlock) || replacementBlock != null && !InputHelper.isABlock((IItemStack)replacementBlock)) {
            CraftTweakerAPI.logError((String)("Runic Shears require input and replacement to be blocks. Recipe: " + name));
            return;
        }
        CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)outputDrop), CraftTweakerMC.getBlock((IBlock)Objects.requireNonNull(replacementBlock).asBlock()), CraftTweakerMC.getBlock((IBlock)inputBlock.asBlock()), CraftTweakerMC.getItemStack((IItemStack)jeiDisplayItem)));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="the name of the recipe for the shearing"), @ZenDocArg(arg="outputDrop", info="the item that is dropped upon shearing the specified entity"), @ZenDocArg(arg="entity", info="the entity that is to be sheared to obtain the drop"), @ZenDocArg(arg="cooldown", info="the number of ticks (seconds multiplied by 20) it takes until the entity can be sheared again")})
    @ZenMethod
    public static void addEntityRecipe(String name, IItemStack outputDrop, IEntityDefinition entity, int cooldown) {
        CraftTweaker.LATE_ACTIONS.add(new AddEntity(name, CraftTweakerMC.getItemStack((IItemStack)outputDrop), ((EntityEntry)entity.getInternal()).getEntityClass(), cooldown));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="output", info="the itemstack output that you wish to remove")})
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    private static class AddEntity
    extends BaseAction {
        private String name;
        private Class<? extends Entity> entity;
        private ItemStack outputItem;
        private int cooldown;

        private AddEntity(String name, ItemStack outputItem, Class<? extends Entity> entity, int cooldown) {
            super("Runic Shears entity recipe add");
            this.name = name;
            this.outputItem = outputItem;
            this.entity = entity;
            this.cooldown = cooldown;
        }

        public String describe() {
            return "Adding a recipe to create " + LogHelper.getStackDescription((Object)this.outputItem) + " from entity " + this.name;
        }

        public void apply() {
            RunicShearRecipe recipe = new RunicShearRecipe(this.outputItem, this.entity, this.cooldown, this.name);
            ModRecipes.addRunicShearRecipe(recipe);
        }
    }

    private static class Add
    extends BaseAction {
        private String name;
        private ItemStack displayItem;
        private ItemStack outputItem;
        private Block inputBlock;
        private Block outputBlock;

        private Add(String name, ItemStack outputItem, Block replacementBlock, Block inputBlock, ItemStack displayItem) {
            super("Runic Shears recipe add");
            this.name = name;
            this.outputItem = outputItem;
            this.outputBlock = replacementBlock;
            this.inputBlock = inputBlock;
            this.displayItem = displayItem;
        }

        public String describe() {
            return "Adding a recipe to create " + LogHelper.getStackDescription((Object)this.outputItem);
        }

        public void apply() {
            RunicShearRecipe recipe = new RunicShearRecipe(this.inputBlock, this.outputBlock, this.outputItem, this.name, this.displayItem);
            ModRecipes.addRunicShearRecipe(recipe);
        }
    }

    private static class Remove
    extends BaseAction {
        private ItemStack output;

        private Remove(ItemStack output) {
            super("Runic Shears recipe removal");
            this.output = output;
        }

        public String describe() {
            return "Removing all Runic Shears recipes involving " + LogHelper.getStackDescription((Object)this.output) + " as its output";
        }

        public void apply() {
            RunicShearRecipe recipe = ModRecipes.getRunicShearRecipe(this.output);
            boolean removed = false;
            if (recipe != null) {
                ModRecipes.getRunicShearRecipes().remove(recipe.getName());
                removed = true;
            }
            if ((recipe = ModRecipes.getRunicShearEntityRecipe(this.output)) != null) {
                ModRecipes.getRunicShearEntityRecipes().remove(recipe.getClazz());
                removed = true;
            }
            if (!removed) {
                CraftTweakerAPI.logError((String)("No runic shear recipe found for " + LogHelper.getStackDescription((Object)this.output)));
            }
        }
    }
}

