/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker;

import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Pacifist")
@ZenDocAppend(value={"docs/include/pacifist.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Pacifist")
public class PacifistTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="entity", info="the entity to add to the pacifist list")})
    @ZenMethod
    public static void addEntity(IEntityDefinition entity) {
        CraftTweaker.LATE_ACTIONS.add(new Add((EntityEntry)entity.getInternal()));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="entity", info="the entity to remove from the pacifist list")})
    @ZenMethod
    public static void removeEntity(IEntityDefinition entity) {
        CraftTweaker.LATE_ACTIONS.add(new Remove((EntityEntry)entity.getInternal()));
    }

    private static class Add
    extends BaseAction {
        private final EntityEntry entry;

        public Add(EntityEntry entry) {
            super("add_pacifist");
            this.entry = entry;
        }

        public void apply() {
            ModRecipes.addPacifistEntry(this.entry.getName(), this.entry.getEntityClass());
        }

        protected String getRecipeInfo() {
            return String.format("Recipe to add %s to Pacifism", this.entry.getName());
        }
    }

    private static class Remove
    extends BaseAction {
        private final EntityEntry entry;

        public Remove(EntityEntry entry) {
            super("remove_pacifist");
            this.entry = entry;
        }

        public void apply() {
            ModRecipes.removePacifistEntry(this.entry.getName());
        }

        protected String getRecipeInfo() {
            return String.format("Recipe to remove %s from Pacifist", this.entry.getName());
        }
    }
}

