/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.handler;

import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.item.ItemPouch;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;

public class PouchHandler
implements INBTSerializable<NBTTagCompound> {
    public static final int COMPONENT_POUCH_HERB_SLOTS = 6;
    public static final int COMPONENT_POUCH_INVENTORY_SLOTS = 12;
    public static final int APOTHECARY_POUCH_HERB_SLOTS = 9;
    public static final int APOTHECARY_POUCH_INVENTORY_SLOTS = 18;
    private PouchItemHandler inventorySlots;
    private PouchItemHandler herbSlots;
    private ItemStack pouch;
    private boolean isApoth = false;

    public PouchHandler(ItemStack pouch, int inventorySlots, int herbSlots) {
        this.pouch = pouch;
        if (inventorySlots == 18) {
            this.isApoth = true;
        }
        this.inventorySlots = new PouchItemHandler(inventorySlots);
        this.herbSlots = new PouchItemHandler(herbSlots){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return HerbRegistry.containsHerbItem(stack.func_77973_b());
            }
        };
    }

    public PouchItemHandler getInventory() {
        return this.inventorySlots;
    }

    public PouchItemHandler getHerbs() {
        return this.herbSlots;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("inventory_slots", (NBTBase)this.inventorySlots.serializeNBT());
        tag.func_74782_a("herb_slots", (NBTBase)this.herbSlots.serializeNBT());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound inv = nbt.func_74775_l("inventory_slots");
        NBTTagCompound herb = nbt.func_74775_l("herb_slots");
        if (this.isApoth) {
            if (inv.func_74762_e("Size") != 18) {
                inv.func_74768_a("Size", 18);
            }
            if (herb.func_74762_e("Size") != 9) {
                herb.func_74768_a("Size", 9);
            }
        }
        this.inventorySlots.deserializeNBT(inv);
        this.herbSlots.deserializeNBT(herb);
    }

    public static PouchHandler getHandler(ItemStack stack) {
        NBTTagCompound tag;
        boolean isApoth = ((ItemPouch)stack.func_77973_b()).isApothecary();
        PouchHandler handler = isApoth ? new PouchHandler(stack, 18, 9) : new PouchHandler(stack, 12, 6);
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("handler")) {
            handler.deserializeNBT(tag.func_74775_l("handler"));
        }
        return handler;
    }

    public void saveToStack() {
        NBTTagCompound tag = this.pouch.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.pouch.func_77982_d(tag);
        }
        tag.func_74782_a("handler", (NBTBase)this.serializeNBT());
    }

    public class PouchItemHandler
    extends ItemStackHandler {
        public PouchItemHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PouchHandler.this.saveToStack();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            PouchHandler.this.saveToStack();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack result = super.insertItem(slot, stack, simulate);
            if (!simulate) {
                PouchHandler.this.saveToStack();
            }
            return result;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (!simulate) {
                PouchHandler.this.saveToStack();
            }
            return result;
        }
    }
}

