/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.ritual.RitualRegistry;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityRitualAnimalHarvest
extends EntityRitualBase {
    protected static Random random = new Random();
    protected static final DataParameter<Integer> lifetime = EntityDataManager.func_187226_a(EntityRitualAnimalHarvest.class, (DataSerializer)DataSerializers.field_187192_b);
    private ObjectOpenHashSet<Class<? extends Entity>> harvestClasses;
    private static Method getLootTable = null;

    public EntityRitualAnimalHarvest(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_animal_harvest.getDuration() + 20));
        this.harvestClasses = ModRecipes.getAnimalHarvestClasses();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int curLifetime = (Integer)this.func_184212_Q().func_187225_a(lifetime);
        this.func_184212_Q().func_187227_b(lifetime, (Object)(curLifetime - 1));
        this.func_184212_Q().func_187217_b(lifetime);
        if ((Integer)this.func_184212_Q().func_187225_a(lifetime) < 0) {
            this.func_70106_y();
        }
        if (this.field_70173_aa % 110 == 0) {
            for (int i = 0; i < 5 && !this.doHarvest(); ++i) {
            }
        }
    }

    public boolean doHarvest() {
        List entityList = Util.getEntitiesWithinRadius((World)this.field_70170_p, entity -> this.harvestClasses.contains(entity.getClass()), (BlockPos)this.func_180425_c(), (float)15.0f, (float)10.0f, (float)15.0f);
        if (entityList.isEmpty()) {
            return false;
        }
        EntityLiving entity2 = (EntityLiving)entityList.get(random.nextInt(entityList.size()));
        boolean didDrops = false;
        if (!this.field_70170_p.field_72995_K) {
            entity2.captureDrops = true;
            entity2.capturedDrops.clear();
            EntityRitualAnimalHarvest.dropLoot(entity2, true);
            entity2.captureDrops = false;
            if (!ForgeHooks.onLivingDrops((EntityLivingBase)entity2, (DamageSource)DamageSource.field_76377_j, (ArrayList)entity2.capturedDrops, (int)0, (boolean)false)) {
                for (EntityItem item : entity2.capturedDrops) {
                    item.field_70181_x = 0.0;
                    item.field_70159_w = 0.0;
                    item.field_70179_y = 0.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                    didDrops = true;
                }
            }
        }
        if (didDrops) {
            entity2.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 30, 0));
        }
        return didDrops;
    }

    @Override
    public DataParameter<Integer> getLifetime() {
        return lifetime;
    }

    public static ResourceLocation getLootTable(EntityLiving entity) {
        if (getLootTable == null) {
            getLootTable = ReflectionHelper.findMethod(EntityLiving.class, (String)"getLootTable", (String)"func_184647_J", (Class[])new Class[0]);
        }
        try {
            return (ResourceLocation)getLootTable.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    public static void dropLoot(EntityLiving entity, boolean player) {
        ResourceLocation resourcelocation = entity.field_184659_bA;
        if (resourcelocation == null) {
            resourcelocation = EntityRitualAnimalHarvest.getLootTable(entity);
        }
        if (resourcelocation != null) {
            LootTable loottable = entity.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
            entity.field_184659_bA = null;
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)entity.field_70170_p));
            LootContext context = new LootContext(random.nextInt(6) == 0 ? 1.0f : 0.0f, (WorldServer)entity.field_70170_p, entity.field_70170_p.func_184146_ak(), (Entity)entity, (EntityPlayer)fakePlayer, DamageSource.field_76377_j);
            for (ItemStack itemstack : loottable.func_186462_a(entity.field_184653_bB == 0L ? entity.field_70146_Z : new Random(entity.field_184653_bB), context)) {
                entity.func_70099_a(itemstack, 0.0f);
            }
        }
    }
}

