/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.block.BlockElementalSoil;
import epicsquid.roots.capability.grove.IPlayerGroveCapability;
import epicsquid.roots.capability.grove.PlayerGroveCapability;
import epicsquid.roots.capability.grove.PlayerGroveCapabilityProvider;
import epicsquid.roots.capability.playerdata.IPlayerDataCapability;
import epicsquid.roots.capability.playerdata.PlayerDataCapability;
import epicsquid.roots.capability.playerdata.PlayerDataCapabilityProvider;
import epicsquid.roots.capability.runic_shears.RunicShearsCapabilityProvider;
import epicsquid.roots.effect.EffectManager;
import epicsquid.roots.entity.spell.EntityPetalShell;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.baubles.pouch.BaubleBeltCapabilityHandler;
import epicsquid.roots.item.ItemDruidKnife;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.network.MessagePlayerDataUpdate;
import epicsquid.roots.network.MessagePlayerGroveUpdate;
import epicsquid.roots.network.fx.MessageGeasFX;
import epicsquid.roots.network.fx.MessageGeasRingFX;
import epicsquid.roots.network.fx.MessageLightDrifterFX;
import epicsquid.roots.network.fx.MessageLightDrifterSync;
import epicsquid.roots.network.fx.MessagePetalShellBurstFX;
import epicsquid.roots.recipe.BarkRecipe;
import epicsquid.roots.util.Constants;
import epicsquid.roots.util.ItemSpawnUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class EventManager {
    public static long ticks = 0L;

    @SubscribeEvent
    public static void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null) {
            ItemStack tool = event.getHarvester().func_184586_b(EnumHand.MAIN_HAND);
            if (tool.func_77973_b() instanceof ItemDruidKnife) {
                event.getDrops().clear();
                IBlockState blockstate = event.getState();
                Block block = blockstate.func_177230_c();
                BlockPlanks.EnumType type = block == Blocks.field_150364_r ? (BlockPlanks.EnumType)blockstate.func_177229_b((IProperty)BlockOldLog.field_176301_b) : (block == Blocks.field_150363_s ? (BlockPlanks.EnumType)blockstate.func_177229_b((IProperty)BlockNewLog.field_176300_b) : null);
                BarkRecipe bark = type == null ? ModRecipes.getModdedBarkRecipe(block) : ModRecipes.getVanillaBarkRecipe(type);
                if (bark != null) {
                    ItemStack barkStack = bark.getBarkStack(Util.rand.nextInt(EventManager.getBarkAmount(tool)) + 1);
                    if (!event.getWorld().field_72995_K) {
                        ItemSpawnUtil.spawnItem(event.getWorld(), event.getPos(), barkStack);
                    }
                }
            }
            if (event.getState().func_177230_c() instanceof IPlantable) {
                IBlockState soil = event.getWorld().func_180495_p(event.getPos().func_177972_a(EnumFacing.DOWN));
                if (event.getState().func_177230_c() instanceof IPlantable && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)event.getWorld(), event.getPos().func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)event.getState().func_177230_c())) {
                    int speed;
                    int fertility;
                    Random random;
                    ArrayList<ItemStack> newDrops;
                    int cookingMultiplier;
                    if (soil.func_177227_a().contains(BlockElementalSoil.fireCookingMultiplier) && (cookingMultiplier = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.fireCookingMultiplier)).intValue()) > 0) {
                        newDrops = new ArrayList<ItemStack>();
                        random = new Random();
                        boolean seed = false;
                        for (ItemStack stack : event.getDrops()) {
                            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                            if (!seed && stack.func_77973_b() instanceof IPlantable) {
                                seed = true;
                                newDrops.add(stack);
                                continue;
                            }
                            if (!result.func_190926_b()) {
                                newDrops.add(new ItemStack(result.func_77973_b(), cookingMultiplier - 1 > 0 ? random.nextInt(cookingMultiplier - 1) + 1 : 1));
                                continue;
                            }
                            newDrops.add(stack);
                        }
                        event.getDrops().clear();
                        event.getDrops().addAll(newDrops);
                    }
                    if (soil.func_177227_a().contains(BlockElementalSoil.earthFertility) && (fertility = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.earthFertility)).intValue()) > 0) {
                        newDrops = new ArrayList();
                        random = new Random();
                        for (ItemStack stack : event.getDrops()) {
                            newDrops.add(stack);
                            if (random.nextInt(3) >= fertility) continue;
                            newDrops.add(new ItemStack(stack.func_77973_b(), fertility > 2 ? 2 : 1));
                        }
                        event.getDrops().clear();
                        event.getDrops().addAll(newDrops);
                    }
                    if (soil.func_177227_a().contains(BlockElementalSoil.waterSpeed) && (speed = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.waterSpeed)).intValue()) > 0) {
                        ArrayList drops = new ArrayList(event.getDrops());
                        event.getDrops().clear();
                        BlockPos dropPos = event.getPos().func_177977_b().func_177977_b();
                        boolean seed = false;
                        if (!event.getWorld().field_72995_K) {
                            for (ItemStack stack : drops) {
                                if (!seed && stack.func_77973_b() instanceof IPlantable) {
                                    seed = true;
                                    event.getDrops().add(stack);
                                    continue;
                                }
                                event.getWorld().func_72838_d((Entity)new EntityItem(event.getWorld(), (double)((float)dropPos.func_177958_n() + 0.5f), (double)((float)dropPos.func_177956_o() + 0.5f), (double)((float)dropPos.func_177952_p() + 0.5f), stack));
                            }
                        }
                    }
                }
            }
        }
    }

    private static int getBarkAmount(ItemStack stack) {
        int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        return ++enchLevel;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT) {
            ClientProxy.particleRenderer.updateParticles();
            ++ticks;
        }
    }

    @SubscribeEvent
    public static void copyCapabilities(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            if (event.getOriginal().hasCapability(PlayerGroveCapabilityProvider.PLAYER_GROVE_CAPABILITY, null)) {
                ((PlayerGroveCapability)event.getEntityPlayer().getCapability(PlayerGroveCapabilityProvider.PLAYER_GROVE_CAPABILITY, null)).setData(((PlayerGroveCapability)event.getOriginal().getCapability(PlayerGroveCapabilityProvider.PLAYER_GROVE_CAPABILITY, null)).getData());
            }
            if (event.getOriginal().hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)) {
                ((PlayerDataCapability)event.getEntityPlayer().getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).setData(((PlayerDataCapability)event.getOriginal().getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData());
            }
        }
    }

    @SubscribeEvent
    public static void addCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (ModRecipes.getRunicShearEntities().contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(RunicShearsCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new RunicShearsCapabilityProvider());
        }
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("roots", "player_grove_capability"), (ICapabilityProvider)new PlayerGroveCapabilityProvider());
            event.addCapability(new ResourceLocation("roots", "player_data_capability"), (ICapabilityProvider)new PlayerDataCapabilityProvider());
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="baubles")
    public static void addBaublesCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemPouch) {
            event.addCapability(new ResourceLocation("roots", "baubles_pouch"), (ICapabilityProvider)BaubleBeltCapabilityHandler.instance);
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            Object cap;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.hasCapability(PlayerGroveCapabilityProvider.PLAYER_GROVE_CAPABILITY, null) && (cap = (IPlayerGroveCapability)player.getCapability(PlayerGroveCapabilityProvider.PLAYER_GROVE_CAPABILITY, null)) != null && !player.field_70170_p.field_72995_K && cap.isDirty()) {
                PacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayerGroveUpdate(player.func_110124_au(), cap.getData()), (EntityPlayerMP)player);
                cap.clean();
            }
            if (player.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null) && (cap = (IPlayerDataCapability)player.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)) != null && !player.field_70170_p.field_72995_K && cap.isDirty()) {
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessagePlayerDataUpdate(player.func_110124_au(), cap.getData()), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0));
                cap.clean();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDamage(LivingHurtEvent event) {
        EntityPlayer player;
        List shells;
        NBTTagCompound tag;
        if (EffectManager.hasEffect(event.getEntityLiving(), EffectManager.effect_time_stop.getName())) {
            event.setAmount(event.getAmount() * 0.1f);
        }
        if (EffectManager.hasEffect(event.getEntityLiving(), EffectManager.effect_invulnerability.getName())) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving().getEntityData().func_74764_b(Constants.EFFECT_TAG) && (tag = event.getEntityLiving().getEntityData().func_74775_l(Constants.EFFECT_TAG)).func_74764_b(EffectManager.effect_invulnerability.getName())) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().func_130014_f_().field_72995_K && (shells = (player = (EntityPlayer)event.getEntityLiving()).func_130014_f_().func_72872_a(EntityPetalShell.class, new AxisAlignedBB(player.field_70165_t - 0.5, player.field_70163_u, player.field_70161_v - 0.5, player.field_70165_t + 0.5, player.field_70163_u + 2.0, player.field_70161_v + 0.5))).size() > 0) {
            for (EntityPetalShell shell : shells) {
                if (shell.getPlayerId().compareTo(player.func_110124_au()) != 0 || (Integer)shell.func_184212_Q().func_187225_a(shell.getCharge()) <= 0) continue;
                event.setAmount(0.0f);
                event.setCanceled(true);
                shell.func_184212_Q().func_187227_b(shell.getCharge(), (Object)((Integer)shell.func_184212_Q().func_187225_a(shell.getCharge()) - 1));
                shell.func_184212_Q().func_187217_b(shell.getCharge());
                PacketHandler.sendToAllTracking((IMessage)new MessagePetalShellBurstFX(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), (Entity)player);
                if ((Integer)shell.func_184212_Q().func_187225_a(shell.getCharge()) > 0) continue;
                player.field_70170_p.func_72900_e((Entity)shell);
            }
        }
        if (event.getEntity().getEntityData().func_74764_b(Constants.GEAS_TAG) && event.getSource().func_76346_g() instanceof EntityLivingBase && event.getSource().func_76346_g().func_110124_au().compareTo(event.getEntity().func_110124_au()) != 0) {
            event.getEntity().getEntityData().func_82580_o(Constants.GEAS_TAG);
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && event.getSource().func_76346_g().getEntityData().func_74764_b(Constants.GEAS_TAG)) {
            EntityLivingBase entity = (EntityLivingBase)event.getSource().func_76346_g();
            entity.func_70097_a(DamageSource.field_82727_n, event.getAmount() * 2.0f);
            event.setAmount(0.0f);
            PacketHandler.sendToAllTracking((IMessage)new MessageGeasRingFX(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v), (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EffectManager.tickEffects(event.getEntityLiving());
        if (EffectManager.hasEffect(event.getEntityLiving(), EffectManager.effect_time_stop.getName())) {
            event.setCanceled(true);
        }
        if (event.getEntity().getEntityData().func_74764_b(Constants.GEAS_TAG) && !event.getEntity().func_130014_f_().field_72995_K) {
            event.getEntity().getEntityData().func_74768_a(Constants.GEAS_TAG, event.getEntity().getEntityData().func_74762_e(Constants.GEAS_TAG) - 1);
            if (event.getEntity().getEntityData().func_74762_e(Constants.GEAS_TAG) <= 0) {
                event.getEntity().getEntityData().func_82580_o(Constants.GEAS_TAG);
            }
            PacketHandler.sendToAllTracking((IMessage)new MessageGeasFX(event.getEntity().field_70165_t, event.getEntity().field_70163_u + (double)event.getEntity().func_70047_e() + 0.75, event.getEntity().field_70161_v), (Entity)event.getEntity());
        }
        if (event.getEntity().getEntityData().func_74764_b(Constants.LIGHT_DRIFTER_TAG) && !event.getEntity().func_130014_f_().field_72995_K) {
            event.getEntity().getEntityData().func_74768_a(Constants.LIGHT_DRIFTER_TAG, event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_TAG) - 1);
            if (event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_TAG) <= 0) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                player.field_70165_t = event.getEntity().getEntityData().func_74769_h(Constants.LIGHT_DRIFTER_X);
                player.field_70163_u = event.getEntity().getEntityData().func_74769_h(Constants.LIGHT_DRIFTER_Y);
                player.field_70161_v = event.getEntity().getEntityData().func_74769_h(Constants.LIGHT_DRIFTER_Z);
                PacketHandler.sendToAllTracking((IMessage)new MessageLightDrifterSync(event.getEntity().func_110124_au(), player.field_70165_t, player.field_70163_u, player.field_70161_v, false, event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_MODE)), (Entity)player);
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75102_a = false;
                player.field_70145_X = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_70066_B();
                player.func_71033_a(GameType.func_77146_a((int)event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_MODE)));
                player.func_70634_a(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                PacketHandler.sendToAllTracking((IMessage)new MessageLightDrifterFX(event.getEntity().field_70165_t, event.getEntity().field_70163_u + 1.0, event.getEntity().field_70161_v), (Entity)event.getEntity());
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_TAG);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_X);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_Y);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_Z);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_MODE);
            }
        }
    }

    @SubscribeEvent
    public static void onCropsGrowPre(BlockEvent.CropGrowEvent.Pre cropGrowEvent) {
        int speed;
        IBlockState soil = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN));
        IBlockState plant = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos());
        if (plant.func_177230_c() instanceof IPlantable && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)cropGrowEvent.getWorld(), cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)plant.func_177230_c()) && soil.func_177227_a().contains(BlockElementalSoil.airSpeed) && (speed = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.airSpeed)).intValue()) > 0) {
            Random rand = new Random();
            cropGrowEvent.setResult(rand.nextInt(3) + 1 <= speed ? Event.Result.ALLOW : Event.Result.DEFAULT);
        }
    }

    @SubscribeEvent
    public static void onCropsGrowPost(BlockEvent.CropGrowEvent.Post cropGrowEvent) {
        int speed;
        IBlockState soil = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN));
        IBlockState plant = cropGrowEvent.getWorld().func_180495_p(cropGrowEvent.getPos());
        if (plant.func_177230_c() instanceof IPlantable && plant.func_177230_c() instanceof BlockCrops && ((BlockCrops)plant.func_177230_c()).func_185525_y(plant) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)cropGrowEvent.getWorld(), cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN), EnumFacing.UP, (IPlantable)plant.func_177230_c()) && soil.func_177227_a().contains(BlockElementalSoil.waterSpeed) && (speed = ((Integer)soil.func_177229_b((IProperty)BlockElementalSoil.waterSpeed)).intValue()) > 0 && cropGrowEvent.getWorld().func_175623_d(cropGrowEvent.getPos().func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.DOWN))) {
            plant.func_177230_c().func_176226_b(cropGrowEvent.getWorld(), cropGrowEvent.getPos(), plant, 0);
            cropGrowEvent.getWorld().func_175656_a(cropGrowEvent.getPos(), plant.func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(0)));
        }
    }
}

