/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementFactory;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.PiMarkdownReader;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.MarkdownVisitor;
import com.brandon3055.projectintelligence.api.PiAPI;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiStyleEditor;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.RootPage;
import com.brandon3055.projectintelligence.registry.GuiDocRegistry;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;

public class PIGuiOverlay
implements IModularGui<GuiScreen> {
    private static final StyleHandler.PropertyGroup windowProps = new StyleHandler.PropertyGroup("gui_docs");
    private static final StyleHandler.PropertyGroup settingsProps = new StyleHandler.PropertyGroup("gui_docs.settings_button");
    private static final StyleHandler.PropertyGroup closeProps = new StyleHandler.PropertyGroup("gui_docs.close_button");
    private static final StyleHandler.PropertyGroup scrollProps = new StyleHandler.PropertyGroup("gui_docs.scroll_bar");
    private static final StyleHandler.PropertyGroup scrollSliderProps = new StyleHandler.PropertyGroup("gui_docs.scroll_bar.scroll_slider");
    private static final StyleHandler.PropertyGroup headerProps = new StyleHandler.PropertyGroup("gui_docs.header");
    private Minecraft mc;
    private int zLevel = 0;
    private int screenWidth;
    private int screenHeight;
    private GuiElementManager manager = new GuiElementManager((IModularGui)this);
    private GuiScreen gui;
    private GuiDocRegistry.GuiDocHelper guiDocHelper;
    private DocElement docElement;

    public PIGuiOverlay(GuiScreen gui, GuiDocRegistry.GuiDocHelper guiDocHelper) {
        this.gui = gui;
        this.guiDocHelper = guiDocHelper;
        this.onGuiInit();
    }

    public void onGuiInit() {
        this.mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        this.screenWidth = scaledresolution.func_78326_a();
        this.screenHeight = scaledresolution.func_78328_b();
        this.manager.onGuiInit(this.mc, this.screenWidth, this.screenHeight);
    }

    public void addElements(GuiElementManager manager) {
        if (this.docElement != null) {
            manager.remove((MGuiElementBase)this.docElement);
        }
        this.docElement = new DocElement(this, this.guiDocHelper);
        manager.add((MGuiElementBase)this.docElement, 200);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        return this.manager.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        return this.manager.mouseReleased(mouseX, mouseY, state);
    }

    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        return this.manager.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.manager.keyTyped(typedChar, keyCode);
    }

    public boolean handleMouseInput() throws IOException {
        return this.manager.handleMouseInput();
    }

    public void renderElements(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderElements(this.mc, mouseX, mouseY, partialTicks);
    }

    public boolean renderOverlayLayer(int mouseX, int mouseY, float partialTicks) {
        return this.manager.renderOverlayLayer(this.mc, mouseX, mouseY, partialTicks);
    }

    public void updateScreen() {
        this.manager.onUpdate();
    }

    public GuiScreen getScreen() {
        return this.gui;
    }

    public int xSize() {
        return 0;
    }

    public int ySize() {
        return 0;
    }

    public int guiLeft() {
        return 0;
    }

    public int guiTop() {
        return 0;
    }

    public GuiElementManager getManager() {
        return this.manager;
    }

    public void setZLevel(int zLevel) {
        this.zLevel = zLevel;
    }

    public int getZLevel() {
        return this.zLevel;
    }

    public boolean isMouseOver(int mouseX, int mosueY) {
        return this.docElement != null && this.docElement.isMouseOver(mouseX, mosueY);
    }

    public Rectangle getDocBounds() {
        return this.docElement == null ? null : this.docElement.getRect();
    }

    static /* synthetic */ StyleHandler.PropertyGroup access$100() {
        return scrollProps;
    }

    static /* synthetic */ StyleHandler.PropertyGroup access$200() {
        return scrollSliderProps;
    }

    private static class DocElement
    extends MGuiElementBase<DocElement> {
        private static final ModelBook MODEL_BOOK = new ModelBook();
        private PIPartRenderer windowRenderer = new PIPartRenderer(PIGuiOverlay.access$000()).setSquareTex(false);
        private PIPartRenderer scrollRenderer = new PIPartRenderer(PIGuiOverlay.access$100());
        private PIPartRenderer scrollSlideRenderer = new PIPartRenderer(PIGuiOverlay.access$200());
        private GuiButton heading;
        private GuiButton prevPage;
        private GuiButton nextPage;
        private GuiButton openInPI;
        private GuiSlideControl scrollBar;
        private GuiScrollElement scrollElement;
        private MDElementContainer markdownContainer;
        private GuiButton settings;
        private GuiButton close;
        private PIGuiOverlay overlay;
        private GuiDocRegistry.GuiDocHelper guiDocHelper;
        private String pageName = "";
        private double animState = 0.0;
        private boolean visible = false;
        private float hoverAnim = 0.0f;
        private float pageAnim = 0.0f;

        public DocElement(PIGuiOverlay overlay, GuiDocRegistry.GuiDocHelper guiDocHelper) {
            this.overlay = overlay;
            this.guiDocHelper = guiDocHelper;
            this.visible = guiDocHelper.isDocVisible();
            this.animState = this.visible ? 1.0 : 0.0;
        }

        public void addChildElements() {
            super.addChildElements();
            this.heading = new GuiButton();
            this.heading.setTextColGetter((hovering, disabled) -> headerProps.textColour(hovering));
            this.heading.setAlignment(GuiAlign.CENTER);
            this.heading.setTrim(true);
            this.heading.setShadow(false);
            this.heading.setListener(this::showPageList);
            this.addChild((MGuiElementBase)this.heading);
            this.prevPage = (GuiButton)((GuiButton)new GuiButton().setSize(10, 10)).setHoverText(I18n.func_135052_a((String)"pi.button.prev_page", (Object[])new Object[0]));
            GuiTexture tex = (GuiTexture)new GuiTexture(1, 24, 6, 8, PITextures.PI_PARTS).setPos(2, 1);
            tex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> headerProps.glTextColour(mouseOver));
            tex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
            this.prevPage.addChild((MGuiElementBase)tex);
            this.addChild((MGuiElementBase)this.prevPage);
            this.prevPage.setListener(() -> this.changePage(true));
            this.nextPage = (GuiButton)((GuiButton)new GuiButton().setSize(10, 10)).setHoverText(I18n.func_135052_a((String)"pi.button.next_page", (Object[])new Object[0]));
            tex = (GuiTexture)new GuiTexture(9, 24, 6, 8, PITextures.PI_PARTS).setPos(2, 1);
            tex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> headerProps.glTextColour(mouseOver));
            tex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
            this.nextPage.addChild((MGuiElementBase)tex);
            this.addChild((MGuiElementBase)this.nextPage);
            this.nextPage.setListener(() -> this.changePage(false));
            this.openInPI = (GuiButton)((GuiButton)new GuiButton().setSize(10, 10)).setHoverText(I18n.func_135052_a((String)"pi.button.open_in_pi_main", (Object[])new Object[0]));
            tex = (GuiTexture)new GuiTexture(32, 25, 7, 7, PITextures.PI_PARTS).setPos(2, 1);
            tex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> headerProps.glTextColour(mouseOver));
            tex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
            this.openInPI.addChild((MGuiElementBase)tex);
            this.addChild((MGuiElementBase)this.openInPI);
            this.openInPI.setListener(() -> PiAPI.openGui(this.overlay.gui, this.guiDocHelper.getPages()));
            this.settings = (GuiButton)((GuiButton)new GuiButton().setSize(8, 8)).setHoverText(I18n.func_135052_a((String)"pi.config.open_style_settings", (Object[])new Object[0]));
            GuiTexture settingsTex = new GuiTexture(16, 0, 8, 8, PITextures.PI_PARTS);
            settingsTex.setTexSizeOverride(16, 16);
            settingsTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> settingsProps.glColour(mouseOver));
            settingsTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
            this.settings.addChild((MGuiElementBase)settingsTex);
            this.settings.setListener(this::showSettings);
            this.addChild((MGuiElementBase)this.settings);
            this.close = (GuiButton)((GuiButton)new GuiButton().setSize(8, 8)).setHoverText(I18n.func_135052_a((String)"pi.button.close", (Object[])new Object[0]));
            GuiTexture closeTex = new GuiTexture(0, 0, 8, 8, PITextures.PI_PARTS);
            closeTex.setTexSizeOverride(16, 16);
            closeTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> closeProps.glColour(mouseOver));
            closeTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
            this.close.addChild((MGuiElementBase)closeTex);
            this.close.setListener(() -> this.guiDocHelper.setDocVisible(!this.guiDocHelper.isDocVisible()));
            this.addChild((MGuiElementBase)this.close);
            this.scrollBar = new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL);
            this.scrollBar.setBackgroundElement((MGuiElementBase)this.scrollRenderer.asElement().setHoverStateSupplier(() -> this.scrollBar.isDragging()));
            this.scrollBar.setSliderElement((MGuiElementBase)this.scrollSlideRenderer.asElement().setHoverStateSupplier(() -> this.scrollBar.isDragging()));
            this.scrollElement = new GuiScrollElement();
            this.scrollElement.setVerticalScrollBar(this.scrollBar);
            this.scrollElement.setAllowedScrollAxes(true, false);
            this.scrollElement.setStandardScrollBehavior();
            this.scrollElement.setInsets(2, windowProps.thickBorders() ? 5 : 4, 6, 2);
            this.addChild((MGuiElementBase)this.scrollElement);
            this.markdownContainer = new MDElementContainer((MGuiElementBase)this);
            this.markdownContainer.setInsets(4, 0, 4, 0);
            this.markdownContainer.setLinkClickCallback(this::openLink);
            this.markdownContainer.linkDisplayTarget = this.scrollElement;
            this.scrollElement.addElement((MGuiElementBase)this.markdownContainer);
            this.updateBounds();
        }

        private void openLink(String link, int button) {
            GuiButton.playGenericClick((Minecraft)this.mc);
            if (link.startsWith("https://") || link.startsWith("http://") || !link.contains(":")) {
                PIGuiHelper.displayLinkConfirmDialog(this, link);
                return;
            }
            DocumentationPage page = DocumentationManager.getPage(link);
            if (!(page instanceof RootPage)) {
                if (page == null) {
                    PIGuiHelper.displayError("The specified page \"" + link + "\" could not be found!\nThis is ether a broken link or the mod to which the specified page belongs is not installed.");
                    PiAPI.openGui(this.overlay.gui);
                } else {
                    PiAPI.openGui(this.overlay.gui, page.getPageURI());
                }
            }
        }

        public void reloadElement() {
            super.reloadElement();
            int scrollBarX = this.maxXPos() - 10;
            int scrollBarY = this.yPos() + 13;
            int scrollBarW = 6;
            int scrollBarH = this.ySize() - 17;
            int topGap = 11;
            this.settings.setPos(scrollBarX - 1, scrollBarY - 9);
            this.close.setPos(this.xPos() + 5, scrollBarY - 9);
            ((GuiButton)this.heading.setPos(this.xPos() + 27, this.yPos() + 4)).setSize(this.xSize() - 54 - 10, 8);
            this.prevPage.setPos(this.xPos() + 15, this.yPos() + 3);
            this.nextPage.setPos(this.maxXPos() - 35, this.yPos() + 3);
            this.openInPI.setPos(this.maxXPos() - 25, this.yPos() + 3);
            this.scrollElement.setPos(this.xPos(), this.yPos() + topGap);
            this.scrollElement.setSize(this.xSize() - 10, this.ySize() - topGap);
            this.scrollBar.setPos(scrollBarX, scrollBarY);
            this.scrollBar.setSize(scrollBarW, scrollBarH);
            this.scrollBar.getBackgroundElement().setPos(scrollBarX, scrollBarY).setSize(scrollBarW, scrollBarH);
            this.scrollBar.getSliderElement().setXPos(scrollBarX + 1).setXSize(scrollBarW - 2);
            this.markdownContainer.setPosAndSize(this.scrollElement.getInsetRect());
            this.reloadDoc();
        }

        private void changePage(boolean prev) {
            int selected = this.guiDocHelper.getSelectedIndex();
            if (prev) {
                this.guiDocHelper.setSelected(Math.max(0, selected - 1));
            } else {
                this.guiDocHelper.setSelected(Math.min(this.guiDocHelper.getPages().size() - 1, selected + 1));
            }
            this.reloadDoc();
        }

        private void reloadDoc() {
            List<String> lines;
            String pageURI = this.guiDocHelper.getSelected();
            DocumentationPage page = DocumentationManager.getPage(pageURI);
            if (page != null) {
                lines = page.getMarkdownLines();
                this.pageName = page.getDisplayName();
            } else {
                lines = Arrays.asList("Could not find specified documentation page!", "Either the documentation failed to download or this documentation version is not compatible with the installed mod version.", "Or it's just plain broken.", "Broken Page: " + pageURI);
                this.pageName = pageURI;
            }
            this.heading.setText(this.pageName);
            this.markdownContainer.clearContainer();
            PiMarkdownReader reader = new PiMarkdownReader(lines);
            MDElementFactory factory = new MDElementFactory(this.markdownContainer);
            factory.setColourSupplier(windowProps::textColour);
            reader.accept((MarkdownVisitor)factory);
            this.markdownContainer.reloadElement();
            this.markdownContainer.layoutMarkdownElements();
            this.scrollElement.getVerticalScrollBar().setEnabled(true);
            this.updatePageButtons();
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            Rectangle animRect = this.getRect();
            double d = this.animState * 4.0;
            if (d < 1.0 && this.guiDocHelper.enableButton()) {
                this.renderBook();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)this.xPos() + (double)animRect.width / 2.0 * (1.0 - d)), (double)((double)this.yPos() + (double)animRect.height / 2.0 * (1.0 - d)), (double)0.0);
                GlStateManager.func_179139_a((double)d, (double)d, (double)1.0);
                GlStateManager.func_179109_b((float)(-this.xPos()), (float)(-this.yPos()), (float)0.0f);
            }
            this.windowRenderer.render(this, this.xPos(), this.yPos(), this.xSize(), this.ySize(), false);
            this.drawColouredRect(this.xPos() + 4, this.yPos() + 3, this.xSize() - 16, 10.0, headerProps.background());
            this.drawColouredRect(this.xPos() + 4, this.maxYPos() - 6, this.xSize() - 16, 2.0, headerProps.background());
            if (d < 1.0) {
                GlStateManager.func_179121_F();
            }
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        private void renderBook() {
            double scale = (double)this.ySize() * (1.0 - Math.min((double)this.hoverAnim, 0.25));
            double xPos = (double)this.xPos() + (double)this.ySize() * Math.max(0.2, (double)(this.hoverAnim / 2.0f));
            double yPos = (double)this.yPos() + (double)this.ySize() / 2.0;
            this.bindTexture(PITextures.BOOK);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)xPos, (double)yPos, (double)100.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            GlStateManager.func_179114_b((float)(-(90.0f * this.hoverAnim)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-30.0f * this.hoverAnim), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            MODEL_BOOK.func_78088_a(null, 0.0f, this.pageAnim % 1.0f, 0.0f, this.hoverAnim, 0.0f, 0.1f);
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }

        public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (this.animState == 0.0 && this.isMouseOver(mouseX, mouseY)) {
                this.drawHoveringText(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"pi.gui_in_gui.display_doc.info", (Object[])new Object[0])}), mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
            return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            if (this.isMouseOver(mouseX, mouseY)) {
                if (!this.guiDocHelper.isDocVisible() && this.guiDocHelper.enableButton()) {
                    GuiButton.playGenericClick((Minecraft)this.mc);
                    this.guiDocHelper.setDocVisible(true);
                } else {
                    super.mouseClicked(mouseX, mouseY, mouseButton);
                }
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void showSettings() {
            GuiStyleEditor editor = new GuiStyleEditor(this);
            editor.show(this.displayZLevel + 250);
            editor.setXPos(this.xPos() + this.xSize() / 2 - editor.xSize() / 2);
            editor.setYPos(this.yPos() + this.ySize() / 2 - editor.ySize() / 2);
        }

        private void showPageList() {
            if (this.guiDocHelper.getPages().size() <= 1) {
                return;
            }
            GuiPopUpDialogBase dialog = new GuiPopUpDialogBase((MGuiElementBase)this);
            dialog.setSize(this.heading.xSize(), (this.guiDocHelper.getPages().size() - 1) * 10 + 2);
            dialog.addChild((MGuiElementBase)new GuiBorderedRect().setFillColour(headerProps.background())).setPosAndSize((MGuiElementBase)dialog);
            dialog.setPos(this.heading.xPos(), this.heading.maxYPos() + 1);
            dialog.setCloseOnOutsideClick(true);
            dialog.setCloseOnCapturedClick(true);
            int y = dialog.yPos() + 1;
            for (String pageURI : this.guiDocHelper.getPages()) {
                if (this.guiDocHelper.getSelected().equals(pageURI)) continue;
                DocumentationPage page = DocumentationManager.getPage(pageURI);
                GuiButton button = new GuiButton(page == null ? pageURI : page.getDisplayName());
                button.setTextColGetter((hovering, disabled) -> headerProps.textColour(hovering));
                button.setAlignment(GuiAlign.CENTER);
                button.setShadow(false);
                button.setTrim(true);
                ((GuiButton)button.setPos(dialog.xPos() + 3, y)).setSize(dialog.xSize() - 6, 10);
                button.setToggleMode(true).setToggleStateSupplier(() -> this.guiDocHelper.getSelected().equals(pageURI));
                button.setListener(() -> {
                    this.guiDocHelper.setSelected(pageURI);
                    this.reloadDoc();
                });
                dialog.addChild((MGuiElementBase)button);
                y += 10;
            }
            dialog.show(this.displayZLevel + 50);
        }

        public boolean onUpdate() {
            this.visible = this.guiDocHelper.isDocVisible();
            if (this.visible && this.animState < 1.0) {
                this.animState = Math.min(1.0, this.animState + 0.1);
                if (!this.guiDocHelper.enableAnimation()) {
                    this.animState = 1.0;
                }
                this.updateBounds();
            } else if (!this.visible && this.animState > 0.0) {
                this.animState = Math.max(0.0, this.animState - 0.1);
                if (!this.guiDocHelper.enableAnimation()) {
                    this.animState = 0.0;
                }
                this.updateBounds();
            }
            boolean mouseover = this.hoverTime > 0 || this.animState > 0.0;
            this.hoverAnim = (float)MathHelper.approachLinear((double)this.hoverAnim, (double)(mouseover ? 1.0 : 0.0), (double)0.1);
            this.pageAnim = (float)MathHelper.approachExp((double)this.pageAnim, (double)(mouseover ? 0.1 : 5.9), (double)(mouseover ? 0.05 : 0.05));
            return super.onUpdate();
        }

        private void updateBounds() {
            if (this.animState == 1.0) {
                this.setPosAndSize(this.guiDocHelper.getExpandedArea());
                this.scrollElement.setEnabled(true);
            } else if (this.animState == 0.0) {
                this.setPosAndSize(this.guiDocHelper.getCollapsedArea());
                this.scrollElement.setEnabled(false);
            } else {
                Rectangle minRect = this.guiDocHelper.getCollapsedArea();
                Rectangle maxRect = this.guiDocHelper.getExpandedArea();
                double stage1 = MathHelper.clip((double)((this.animState - 0.25) * 4.0), (double)0.0, (double)1.0);
                double stage2 = Math.max(0.0, (this.animState - 0.5) * 2.0);
                double x = MathHelper.map((double)stage2, (double)0.0, (double)1.0, (double)minRect.x, (double)maxRect.x);
                double y = MathHelper.map((double)stage1, (double)0.0, (double)1.0, (double)minRect.y, (double)maxRect.y);
                double w = MathHelper.map((double)stage2, (double)0.0, (double)1.0, (double)minRect.width, (double)maxRect.width);
                double h = MathHelper.map((double)stage1, (double)0.0, (double)1.0, (double)minRect.height, (double)maxRect.height);
                this.setPosAndSize((int)x, (int)y, (int)w, (int)h);
                this.scrollElement.setEnabled(stage1 == 1.0);
            }
            this.scrollBar.setEnabled(this.animState == 1.0);
            this.settings.setEnabled(this.animState == 1.0);
            this.close.setEnabled(this.animState == 1.0);
            this.openInPI.setEnabled(this.animState == 1.0);
            this.updatePageButtons();
            this.reloadElement();
        }

        private void updatePageButtons() {
            this.prevPage.setEnabled(this.animState == 1.0 && this.guiDocHelper.getSelectedIndex() > 0);
            this.nextPage.setEnabled(this.animState == 1.0 && this.guiDocHelper.getSelectedIndex() + 1 < this.guiDocHelper.getPages().size());
        }
    }
}

