/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.tinkers_construct.material;

import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.BasicMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tinkers_construct.material.IRangedMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ProjectileMaterialStats;

public class RangedMaterial
extends BasicMaterial
implements IRangedMaterial {
    private BowMaterialStats bowMaterialStats;
    private BowStringMaterialStats bowStringMaterialStats;
    private ArrowShaftMaterialStats arrowShaftMaterialStats;
    private FletchingMaterialStats fletchingMaterialStats;
    private ProjectileMaterialStats projectileMaterialStats;

    @Override
    public BowMaterialStats getBowMaterialStats() {
        return this.bowMaterialStats;
    }

    @Override
    public BowStringMaterialStats getBowStringMaterialStats() {
        return this.bowStringMaterialStats;
    }

    @Override
    public ArrowShaftMaterialStats getArrowShaftMaterialStats() {
        return this.arrowShaftMaterialStats;
    }

    @Override
    public FletchingMaterialStats getFletchingMaterialStats() {
        return this.fletchingMaterialStats;
    }

    @Override
    public ProjectileMaterialStats getProjectileMaterialStats() {
        return this.projectileMaterialStats;
    }

    @Override
    public IRangedMaterial addPrimaryRangedTrait(String trait) {
        return (IRangedMaterial)((Object)this.addTrait(trait, "bow"));
    }

    @Override
    public IRangedMaterial addSecondaryRangedTrait(String trait) {
        return (IRangedMaterial)((Object)this.addTrait(trait, "bowstring"));
    }

    @Override
    public IRangedMaterial addGlobalRangedTrait(String trait) {
        return this.addPrimaryRangedTrait(trait).addSecondaryRangedTrait(trait);
    }

    @Override
    public IRangedMaterial addRangedTrait(String trait1, String trait2) {
        return this.addPrimaryRangedTrait(trait1).addSecondaryRangedTrait(trait2);
    }

    @Override
    public boolean isToolMaterial() {
        return false;
    }

    @Override
    public boolean isArmorMaterial() {
        return false;
    }

    @Override
    public boolean isRangedMaterial() {
        return this.getArrowShaftMaterialStats() != null || this.getBowMaterialStats() != null || this.getBowStringMaterialStats() != null || this.getFletchingMaterialStats() != null || this.getProjectileMaterialStats() != null;
    }

    @Override
    public boolean registerTinkersMaterialStats(MaterialConfigOptions properties) {
        if (properties.isMaterialEnabled()) {
            Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
            if ("unknown".equals(material.getIdentifier())) {
                return false;
            }
            this.registerRangedStats(material, properties);
            return true;
        }
        return false;
    }

    private void registerRangedStats(Material material, MaterialConfigOptions properties) {
        if (this.isRangedMaterial()) {
            this.registerBowStats(material, properties);
            this.registerBowStringStats(material, properties);
            this.registerFletchingStats(material, properties);
            this.registerProjectileStats(material, properties);
        }
    }

    private void registerBowStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("bow") == null && this.getBowMaterialStats() != null && properties.isBowEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getBowMaterialStats());
        }
    }

    private void registerBowStringStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("bowstring") == null && this.getBowStringMaterialStats() != null && properties.isBowStringEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getBowStringMaterialStats());
        }
    }

    private void registerFletchingStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("fletching") == null && this.getFletchingMaterialStats() != null && properties.isFletchingEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getFletchingMaterialStats());
        }
    }

    private void registerProjectileStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("projectile") == null && this.getProjectileMaterialStats() != null && properties.isProjectileEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getProjectileMaterialStats());
        }
    }

    public void setBowMaterialStats(BowMaterialStats bowMaterialStats) {
        this.bowMaterialStats = bowMaterialStats;
    }

    public void setBowStringMaterialStats(BowStringMaterialStats bowStringMaterialStats) {
        this.bowStringMaterialStats = bowStringMaterialStats;
    }

    public void setArrowShaftMaterialStats(ArrowShaftMaterialStats arrowShaftMaterialStats) {
        this.arrowShaftMaterialStats = arrowShaftMaterialStats;
    }

    public void setFletchingMaterialStats(FletchingMaterialStats fletchingMaterialStats) {
        this.fletchingMaterialStats = fletchingMaterialStats;
    }

    public void setProjectileMaterialStats(ProjectileMaterialStats projectileMaterialStats) {
        this.projectileMaterialStats = projectileMaterialStats;
    }
}

