/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.general.material;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.softc.armoryexpansion.client.integration.aelib.plugins.tinkers_construct.material.MaterialRenderHelper;
import org.softc.armoryexpansion.client.integration.aelib.plugins.tinkers_construct.material.MaterialRenderType;
import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.IBasicMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.traits.TraitHolder;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.block.BlockMolten;

public abstract class BasicMaterial
implements IBasicMaterial {
    protected String identifier;
    private String itemName;
    private int meta;
    protected int color;
    protected MaterialRenderType type = MaterialRenderType.DEFAULT;
    private ResourceLocation texture;
    private boolean isCastable = false;
    private boolean isCraftable = false;
    protected List<TraitHolder> traits = new LinkedList<TraitHolder>();

    public void setCastable(boolean castable) {
        this.isCastable = castable;
    }

    public void setCraftable(boolean craftable) {
        this.isCraftable = craftable;
    }

    @Override
    public boolean isCastable() {
        return this.isCastable;
    }

    @Override
    public boolean isCraftable() {
        return this.isCraftable;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setMeta(int meta) {
        this.meta = meta;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setType(MaterialRenderType type) {
        this.type = type;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setTraits(List<TraitHolder> traits) {
        this.traits = traits;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Item getItem() {
        return this.itemName != null ? Item.func_111206_d((String)this.itemName) : null;
    }

    @Override
    public ItemStack getItemStack() {
        return this.getItem() != null ? new ItemStack(this.getItem(), 1, this.meta) : null;
    }

    @Override
    public MaterialRenderType getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public IBasicMaterial registerOreDict() {
        ItemStack stack = this.getItemStack();
        if (stack != null) {
            OreDictionary.registerOre((String)this.getIdentifier(), (ItemStack)this.getItemStack());
        }
        return this;
    }

    @Override
    public boolean registerTinkersMaterial(boolean canRegister) {
        if (!canRegister || !TinkerRegistry.getMaterial((String)this.getIdentifier()).getIdentifier().equals("unknown")) {
            return false;
        }
        Material material = new Material(this.getIdentifier(), this.getColor());
        material.setCastable(this.isCastable()).setCraftable(this.isCraftable()).addItemIngot(this.getIdentifier());
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            MaterialRenderHelper.setMaterialRenderInfo(material, this);
        }
        this.registerTinkersFluid(true);
        TinkerRegistry.addMaterial((Material)material);
        TinkerRegistry.integrate((Material)material);
        return true;
    }

    @Override
    public boolean registerTinkersFluid(boolean canRegister) {
        if (!canRegister || !this.isCastable()) {
            return false;
        }
        FluidMolten materialFluid = new FluidMolten(this.getFluidName(), this.getColor());
        FluidRegistry.registerFluid((Fluid)materialFluid);
        FluidRegistry.addBucketForFluid((Fluid)materialFluid);
        return true;
    }

    @Override
    public boolean registerTinkersFluidIMC(boolean canRegister) {
        if (!canRegister || !this.isCastable()) {
            return false;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", this.getFluidName());
        tag.func_74778_a("ore", this.getIdentifier());
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
        return true;
    }

    @Override
    public String getFluidName() {
        return "molten_" + this.getIdentifier();
    }

    @Override
    public FluidMolten getFluid() {
        return new FluidMolten(this.getFluidName(), this.getColor());
    }

    @Override
    public Block getFluidBlock() {
        return new BlockMolten((Fluid)this.getFluid());
    }

    @Override
    public abstract boolean registerTinkersMaterialStats(MaterialConfigOptions var1);

    @Override
    public boolean updateTinkersMaterial(boolean canRegister) {
        Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
        if ("unknown".equals(material.identifier) || !canRegister) {
            return false;
        }
        material.addItem(this.getItem());
        material.setRepresentativeItem(this.getItemStack());
        return true;
    }

    @Override
    public boolean registerTinkersMaterialTraits(boolean canRegister) {
        Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
        if ("unknown".equals(material.identifier) || !canRegister) {
            return false;
        }
        this.traits.forEach(t -> {
            ITrait trait = TinkerRegistry.getTrait((String)t.getTraitName());
            if (trait != null) {
                material.addTrait(trait, t.getTraitPart());
            }
        });
        TinkerRegistry.integrate((Material)material);
        return this.traits.size() > 0;
    }

    @Override
    public IBasicMaterial addTrait(String trait, String location) {
        this.traits.add(new TraitHolder(trait, location));
        return this;
    }

    public boolean equals(Object material) {
        return material instanceof BasicMaterial && this.getIdentifier().equals(((BasicMaterial)material).getIdentifier());
    }
}

