/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.constructs_armory.material;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import org.softc.armoryexpansion.client.integration.aelib.plugins.tinkers_construct.material.MaterialRenderType;
import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.constructs_armory.material.IArmorMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.material.BasicMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class ArmorMaterial
extends BasicMaterial
implements IArmorMaterial {
    private CoreMaterialStats coreMaterialStats;
    private PlatesMaterialStats platesMaterialStats;
    private TrimMaterialStats trimMaterialStats;

    ArmorMaterial(String identifier, int color) {
        this(identifier, color, MaterialRenderType.DEFAULT);
    }

    private ArmorMaterial(String identifier, int color, MaterialRenderType type) {
        this.identifier = identifier;
        this.color = color;
        this.type = type;
    }

    public ArmorMaterial(String identifier, int color, MaterialRenderType type, CoreMaterialStats coreMaterialStats, PlatesMaterialStats platesMaterialStats, TrimMaterialStats trimMaterialStats) {
        this.identifier = identifier;
        this.color = color;
        this.type = type;
        this.coreMaterialStats = coreMaterialStats;
        this.platesMaterialStats = platesMaterialStats;
        this.trimMaterialStats = trimMaterialStats;
    }

    @Override
    public CoreMaterialStats getCoreMaterialStats() {
        return this.coreMaterialStats;
    }

    @Override
    public PlatesMaterialStats getPlatesMaterialStats() {
        return this.platesMaterialStats;
    }

    @Override
    public TrimMaterialStats getTrimMaterialStats() {
        return this.trimMaterialStats;
    }

    @Override
    public IArmorMaterial addPrimaryArmorTrait(String trait) {
        return (IArmorMaterial)((Object)this.addTrait(trait, ArmorMaterialType.CORE));
    }

    @Override
    public IArmorMaterial addSecondaryArmorTrait(String trait) {
        return (IArmorMaterial)((Object)this.addTrait(trait, ArmorMaterialType.TRIM).addTrait(trait, ArmorMaterialType.PLATES));
    }

    @Override
    public IArmorMaterial addGlobalArmorTrait(String trait) {
        return this.addPrimaryArmorTrait(trait).addSecondaryArmorTrait(trait);
    }

    @Override
    public IArmorMaterial addArmorTrait(String trait1, String trait2) {
        return this.addPrimaryArmorTrait(trait1).addSecondaryArmorTrait(trait2);
    }

    @Override
    public boolean isToolMaterial() {
        return false;
    }

    @Override
    public boolean isArmorMaterial() {
        return this.getCoreMaterialStats() != null || this.getPlatesMaterialStats() != null || this.getTrimMaterialStats() != null;
    }

    @Override
    public boolean isRangedMaterial() {
        return false;
    }

    @Override
    public boolean registerTinkersMaterialStats(MaterialConfigOptions properties) {
        if (properties.isMaterialEnabled() && properties.isArmorEnabled()) {
            Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
            if ("unknown".equals(material.getIdentifier())) {
                return false;
            }
            this.registerArmorStats(material, properties);
            return true;
        }
        return false;
    }

    void registerArmorStats(Material material, MaterialConfigOptions properties) {
        if (this.isArmorMaterial()) {
            this.registerCoreStats(material, properties);
            this.registerPlatesStats(material, properties);
            this.registerTrimStats(material, properties);
        }
    }

    private void registerCoreStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats(ArmorMaterialType.CORE) == null && this.getCoreMaterialStats() != null && properties.isCoreEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getCoreMaterialStats());
        }
    }

    private void registerPlatesStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats(ArmorMaterialType.PLATES) == null && this.getPlatesMaterialStats() != null && properties.isPlatesEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getPlatesMaterialStats());
        }
    }

    private void registerTrimStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats(ArmorMaterialType.TRIM) == null && this.getTrimMaterialStats() != null && properties.isTrimEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getTrimMaterialStats());
        }
    }

    public void setCoreMaterialStats(CoreMaterialStats coreMaterialStats) {
        this.coreMaterialStats = coreMaterialStats;
    }

    public void setPlatesMaterialStats(PlatesMaterialStats platesMaterialStats) {
        this.platesMaterialStats = platesMaterialStats;
    }

    public void setTrimMaterialStats(TrimMaterialStats trimMaterialStats) {
        this.trimMaterialStats = trimMaterialStats;
    }
}

