/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityExcavator;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.ModelLubricantPipes;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.metal.TileEntityPumpjack;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAutoLubricator
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
ITickable,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ITileDrop {
    public boolean active;
    public int dummy = 0;
    public EnumFacing facing = EnumFacing.NORTH;
    public FluidTank tank = new FluidTank(8000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && LubricantHandler.isValidLube(fluid.getFluid());
        }
    };
    public boolean predictablyDraining = false;
    int count = 0;
    int lastTank = 0;
    int lastTankUpdate = 0;
    int countClient = 0;

    public int doSpeedup() {
        int consumed = Config.IEConfig.Machines.preheater_consumption;
        return 0;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass <= 2;
    }

    public boolean isDummy() {
        return this.dummy > 0;
    }

    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.field_145850_b.func_175656_a(pos.func_177982_a(0, 1, 0), state);
        ((TileEntityAutoLubricator)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)1, (int)0))).dummy = 1;
        ((TileEntityAutoLubricator)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)1, (int)0))).facing = this.facing;
    }

    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0)) instanceof TileEntityAutoLubricator)) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0));
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.func_74762_e("dummy");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (this.facing == EnumFacing.DOWN || this.facing == EnumFacing.UP) {
            this.facing = EnumFacing.NORTH;
        }
        this.active = nbt.func_74767_n("active");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.count = nbt.func_74762_e("count");
        this.predictablyDraining = nbt.func_74767_n("predictablyDraining");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("count", this.count);
        nbt.func_74757_a("predictablyDraining", this.predictablyDraining);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            facing = EnumFacing.NORTH;
        }
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        for (int i = 0; i <= 1; ++i) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy + i, 0));
            if (!(te instanceof TileEntityAutoLubricator)) continue;
            ((TileEntityAutoLubricator)te).setFacing(newDir);
            te.func_70296_d();
            ((TileEntityAutoLubricator)te).markContainingBlockForUpdate(null);
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        TileEntity te;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dummy == 1 && (facing == null || facing == EnumFacing.UP) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof TileEntityAutoLubricator) {
            return (T)((TileEntityAutoLubricator)te).tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        TileEntity te;
        if (this.dummy == 1 && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof TileEntityAutoLubricator) {
            return facing == null || facing == EnumFacing.UP;
        }
        return super.hasCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.dummy == 0) {
            TileEntity master;
            BlockPos target;
            TileEntity te;
            LubricatedHandler.ILubricationHandler handler;
            if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null && this.tank.getFluidAmount() >= LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid()) && LubricantHandler.isValidLube(this.tank.getFluid().getFluid()) && (handler = LubricatedHandler.getHandlerForTile(te = this.field_145850_b.func_175625_s(target = this.field_174879_c.func_177972_a(this.facing)))) != null && (master = handler.isPlacedCorrectly(this.field_145850_b, this, this.facing)) != null && handler.isMachineEnabled(this.field_145850_b, master)) {
                ++this.count;
                handler.lubricate(this.field_145850_b, this.count, master);
                if (!this.field_145850_b.field_72995_K && this.count % 4 == 0) {
                    this.tank.drainInternal(LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid()), true);
                }
                if (this.field_145850_b.field_72995_K) {
                    ++this.countClient;
                    if (this.countClient % 50 == 0) {
                        this.countClient = this.field_145850_b.field_73012_v.nextInt(40);
                        handler.spawnLubricantParticles(this.field_145850_b, this, this.facing, master);
                    }
                }
            }
            if (!this.field_145850_b.field_72995_K && this.lastTank != this.tank.getFluidAmount()) {
                if (this.predictablyDraining && this.tank.getFluid() != null && this.lastTank - this.tank.getFluidAmount() == LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid())) {
                    this.lastTank = this.tank.getFluidAmount();
                    return;
                }
                if (Math.abs(this.lastTankUpdate - this.tank.getFluidAmount()) > 25) {
                    this.markContainingBlockForUpdate(null);
                    this.predictablyDraining = this.tank.getFluid() != null && this.lastTank - this.tank.getFluidAmount() == LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid());
                    this.lastTankUpdate = this.tank.getFluidAmount();
                }
                this.lastTank = this.tank.getFluidAmount();
            }
        }
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
        if (master != null && master instanceof TileEntityAutoLubricator) {
            FluidStack f = FluidUtil.getFluidContained((ItemStack)heldItem);
            if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((TileEntityAutoLubricator)master).tank)) {
                ((TileEntityAutoLubricator)master).markContainingBlockForUpdate(null);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos nullPos = this.func_174877_v();
        return new AxisAlignedBB(nullPos.func_177967_a(this.facing, -5).func_177967_a(this.facing.func_176746_e(), -5).func_177979_c(1), nullPos.func_177967_a(this.facing, 5).func_177967_a(this.facing.func_176746_e(), 5).func_177981_b(3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        TileEntity master;
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND)) && (master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) != null && master instanceof TileEntityAutoLubricator) {
            TileEntityAutoLubricator lube = (TileEntityAutoLubricator)master;
            String s = null;
            s = lube.tank.getFluid() != null ? lube.tank.getFluid().getLocalizedName() + ": " + lube.tank.getFluidAmount() + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public float[] getBlockBounds() {
        if (this.dummy == 1) {
            return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
        }
        return new float[]{0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f};
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_77978_p());
        }
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTank(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public static class CrusherLubricationHandler
    implements LubricatedHandler.ILubricationHandler<TileEntityCrusher> {
        private static Object excavator;

        @Override
        public TileEntity isPlacedCorrectly(World world, TileEntityAutoLubricator tile, EnumFacing facing) {
            BlockPos target = tile.func_174877_v().func_177967_a(facing, 2).func_177984_a();
            TileEntity te = world.func_175625_s(target);
            if (te instanceof TileEntityCrusher) {
                TileEntityCrusher excavator = (TileEntityCrusher)te;
                TileEntityCrusher master = (TileEntityCrusher)excavator.master();
                EnumFacing f = facing;
                if (excavator == master && excavator.getFacing().func_176734_d() == f) {
                    return master;
                }
            }
            return null;
        }

        @Override
        public boolean isMachineEnabled(World world, TileEntityCrusher master) {
            return master.shouldRenderAsActive();
        }

        @Override
        public void lubricate(World world, int ticks, TileEntityCrusher master) {
            Iterator processIterator = master.processQueue.iterator();
            TileEntityMultiblockMetal.MultiblockProcess process = (TileEntityMultiblockMetal.MultiblockProcess)processIterator.next();
            if (!world.field_72995_K) {
                int consume;
                if (ticks % 4 == 0 && (consume = master.energyStorage.extractEnergy(process.energyPerTick, true)) >= process.energyPerTick) {
                    master.energyStorage.extractEnergy(process.energyPerTick, false);
                    if (process.processTick < process.maxTicks) {
                        ++process.processTick;
                    }
                    if (process.processTick >= process.maxTicks && master.processQueue.size() > 1) {
                        process = (TileEntityMultiblockMetal.MultiblockProcess)processIterator.next();
                        if (process.processTick < process.maxTicks) {
                            ++process.processTick;
                        }
                    }
                }
            } else {
                master.animation_barrelRotation += 4.5f;
                master.animation_barrelRotation %= 360.0f;
            }
        }

        @Override
        public void spawnLubricantParticles(World world, TileEntityAutoLubricator tile, EnumFacing facing, TileEntityCrusher master) {
            EnumFacing f = master.mirrored ? facing : facing.func_176734_d();
            float location = world.field_73012_v.nextFloat();
            boolean flip = f.func_176740_k() == EnumFacing.Axis.Z ^ facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ^ !master.mirrored;
            float xO = 2.5f;
            float zO = -0.1f;
            float yO = 1.3f;
            if (location > 0.5f) {
                xO = 1.0f;
                yO = 3.0f;
                zO = 1.65f;
            }
            if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                xO = -xO + 1.0f;
            }
            if (!flip) {
                zO = -zO + 1.0f;
            }
            float x = (float)tile.field_174879_c.func_177958_n() + (f.func_176740_k() == EnumFacing.Axis.X ? xO : zO);
            float y = (float)tile.field_174879_c.func_177956_o() + yO;
            float z = (float)tile.field_174879_c.func_177952_p() + (f.func_176740_k() == EnumFacing.Axis.X ? zO : xO);
            for (int i = 0; i < 3; ++i) {
                float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r3 = world.field_73012_v.nextFloat();
                int n = Block.func_176210_f((IBlockState)IPContent.blockFluidLubricant.func_176223_P());
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f), new int[]{n});
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderPipes(World world, TileEntityAutoLubricator tile, EnumFacing facing, TileEntityCrusher master) {
            if (excavator == null) {
                excavator = new ModelLubricantPipes.Crusher(false);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            BlockPos offset = master.func_174877_v().func_177973_b((Vec3i)tile.func_174877_v());
            GlStateManager.func_179109_b((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p());
            EnumFacing rotation = master.facing;
            if (rotation == EnumFacing.NORTH) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
            } else if (rotation == EnumFacing.WEST) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
            } else if (rotation == EnumFacing.SOUTH) {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            ClientUtils.bindTexture((String)"immersivepetroleum:textures/blocks/lube_pipe12.png");
            ((ModelLubricantPipes.Crusher)((Object)excavator)).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        }

        @Override
        public Tuple<BlockPos, EnumFacing> getGhostBlockPosition(World world, TileEntityCrusher tile) {
            if (!tile.isDummy()) {
                BlockPos pos = tile.func_174877_v().func_177967_a(tile.facing, 2);
                EnumFacing f = tile.getFacing().func_176734_d();
                return new Tuple((Object)pos, (Object)f);
            }
            return null;
        }

        @Override
        public int[] getStructureDimensions() {
            return new int[]{3, 3, 5};
        }
    }

    public static class ExcavatorLubricationHandler
    implements LubricatedHandler.ILubricationHandler<TileEntityExcavator> {
        private static Object excavator;
        private static Object excavatorM;

        @Override
        public TileEntity isPlacedCorrectly(World world, TileEntityAutoLubricator tile, EnumFacing facing) {
            TileEntityExcavator master;
            TileEntityExcavator excavator;
            BlockPos initialTarget = tile.func_174877_v().func_177972_a(facing);
            TileEntityExcavator adjacent = (TileEntityExcavator)world.func_175625_s(initialTarget);
            EnumFacing f = adjacent.mirrored ? facing : facing.func_176734_d();
            BlockPos target = tile.func_174877_v().func_177967_a(facing, 2).func_177967_a(f.func_176746_e(), 4).func_177984_a();
            TileEntity te = world.func_175625_s(target);
            if (te instanceof TileEntityExcavator && (excavator = (TileEntityExcavator)te) == (master = (TileEntityExcavator)excavator.master()) && excavator.getFacing().func_176746_e() == f) {
                return master;
            }
            return null;
        }

        @Override
        public boolean isMachineEnabled(World world, TileEntityExcavator master) {
            BlockPos wheelPos = master.getBlockPosForPos(31);
            TileEntity center = world.func_175625_s(wheelPos);
            if (center instanceof TileEntityBucketWheel) {
                TileEntityBucketWheel wheel = (TileEntityBucketWheel)center;
                return wheel.active;
            }
            return false;
        }

        @Override
        public void lubricate(World world, int ticks, TileEntityExcavator master) {
            BlockPos wheelPos = master.getBlockPosForPos(31);
            TileEntity center = world.func_175625_s(wheelPos);
            if (center instanceof TileEntityBucketWheel) {
                TileEntityBucketWheel wheel = (TileEntityBucketWheel)center;
                if (!world.field_72995_K && ticks % 4 == 0) {
                    int consumed = Config.IEConfig.Machines.excavator_consumption;
                    int extracted = master.energyStorage.extractEnergy(consumed, true);
                    if (extracted >= consumed) {
                        master.energyStorage.extractEnergy(extracted, false);
                        wheel.rotation = (float)((double)wheel.rotation + Config.IEConfig.Machines.excavator_speed / 4.0);
                    }
                } else {
                    wheel.rotation = (float)((double)wheel.rotation + Config.IEConfig.Machines.excavator_speed / 4.0);
                }
            }
        }

        @Override
        public void spawnLubricantParticles(World world, TileEntityAutoLubricator tile, EnumFacing facing, TileEntityExcavator master) {
            EnumFacing f = master.mirrored ? facing : facing.func_176734_d();
            float location = world.field_73012_v.nextFloat();
            boolean flip = f.func_176740_k() == EnumFacing.Axis.Z ^ facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ^ !master.mirrored;
            float xO = 1.2f;
            float zO = -0.5f;
            float yO = 0.5f;
            if (location > 0.5f) {
                xO = 0.9f;
                yO = 0.8f;
                zO = 1.75f;
            }
            if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                xO = -xO + 1.0f;
            }
            if (!flip) {
                zO = -zO + 1.0f;
            }
            float x = (float)tile.field_174879_c.func_177958_n() + (f.func_176740_k() == EnumFacing.Axis.X ? xO : zO);
            float y = (float)tile.field_174879_c.func_177956_o() + yO;
            float z = (float)tile.field_174879_c.func_177952_p() + (f.func_176740_k() == EnumFacing.Axis.X ? zO : xO);
            for (int i = 0; i < 3; ++i) {
                float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r3 = world.field_73012_v.nextFloat();
                int n = Block.func_176210_f((IBlockState)IPContent.blockFluidLubricant.func_176223_P());
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f), new int[]{n});
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderPipes(World world, TileEntityAutoLubricator tile, EnumFacing facing, TileEntityExcavator master) {
            if (excavator == null) {
                excavatorM = new ModelLubricantPipes.Excavator(true);
                excavator = new ModelLubricantPipes.Excavator(false);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            BlockPos offset = master.func_174877_v().func_177973_b((Vec3i)tile.func_174877_v());
            GlStateManager.func_179109_b((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p());
            EnumFacing rotation = master.facing;
            if (rotation == EnumFacing.NORTH) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (rotation == EnumFacing.WEST) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            } else if (rotation == EnumFacing.SOUTH) {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)-1.0f);
            } else if (rotation == EnumFacing.EAST) {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
            ClientUtils.bindTexture((String)"immersivepetroleum:textures/blocks/lube_pipe12.png");
            if (master.mirrored) {
                ((ModelLubricantPipes.Excavator)((Object)excavatorM)).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            } else {
                ((ModelLubricantPipes.Excavator)((Object)excavator)).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        }

        @Override
        public Tuple<BlockPos, EnumFacing> getGhostBlockPosition(World world, TileEntityExcavator tile) {
            if (!tile.isDummy()) {
                BlockPos pos = tile.func_174877_v().func_177967_a(tile.facing, 4).func_177967_a(tile.mirrored ? tile.facing.func_176735_f() : tile.facing.func_176746_e(), 2);
                EnumFacing f = tile.mirrored ? tile.facing.func_176746_e() : tile.facing.func_176735_f();
                return new Tuple((Object)pos, (Object)f);
            }
            return null;
        }

        @Override
        public int[] getStructureDimensions() {
            return new int[]{3, 6, 3};
        }
    }

    public static class PumpjackLubricationHandler
    implements LubricatedHandler.ILubricationHandler<TileEntityPumpjack> {
        private static Object pumpjackM;
        private static Object pumpjack;

        @Override
        public TileEntity isPlacedCorrectly(World world, TileEntityAutoLubricator tile, EnumFacing facing) {
            BlockPos target = tile.func_174877_v().func_177967_a(facing, 2).func_177984_a();
            TileEntity te = world.func_175625_s(target);
            if (te instanceof TileEntityPumpjack) {
                EnumFacing f;
                TileEntityPumpjack jack = (TileEntityPumpjack)te;
                TileEntityPumpjack master = jack.master();
                EnumFacing enumFacing = f = master.mirrored ? facing : facing.func_176734_d();
                if (jack == master && jack.getFacing().func_176746_e() == f) {
                    return master;
                }
            }
            return null;
        }

        @Override
        public boolean isMachineEnabled(World world, TileEntityPumpjack master) {
            return master.wasActive;
        }

        @Override
        public void lubricate(World world, int ticks, TileEntityPumpjack master) {
            if (!world.field_72995_K) {
                if (ticks % 4 == 0) {
                    master.update(true);
                }
            } else {
                master.activeTicks += 0.25f;
            }
        }

        @Override
        public void spawnLubricantParticles(World world, TileEntityAutoLubricator tile, EnumFacing facing, TileEntityPumpjack master) {
            EnumFacing f = master.mirrored ? facing : facing.func_176734_d();
            float location = world.field_73012_v.nextFloat();
            boolean flip = f.func_176740_k() == EnumFacing.Axis.Z ^ facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ^ !master.mirrored;
            float xO = 2.5f;
            float zO = -0.15f;
            float yO = 2.25f;
            if (location > 0.5f) {
                xO = 1.7f;
                yO = 2.9f;
                zO = -1.5f;
            }
            if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                xO = -xO + 1.0f;
            }
            if (!flip) {
                zO = -zO + 1.0f;
            }
            float x = (float)tile.field_174879_c.func_177958_n() + (f.func_176740_k() == EnumFacing.Axis.X ? xO : zO);
            float y = (float)tile.field_174879_c.func_177956_o() + yO;
            float z = (float)tile.field_174879_c.func_177952_p() + (f.func_176740_k() == EnumFacing.Axis.X ? zO : xO);
            for (int i = 0; i < 3; ++i) {
                float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r3 = world.field_73012_v.nextFloat();
                int n = Block.func_176210_f((IBlockState)IPContent.blockFluidLubricant.func_176223_P());
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f), new int[]{n});
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderPipes(World world, TileEntityAutoLubricator tile, EnumFacing facing, TileEntityPumpjack master) {
            if (pumpjackM == null) {
                pumpjackM = new ModelLubricantPipes.Pumpjack(true);
                pumpjack = new ModelLubricantPipes.Pumpjack(false);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            BlockPos offset = master.func_174877_v().func_177973_b((Vec3i)tile.func_174877_v());
            GlStateManager.func_179109_b((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p());
            EnumFacing rotation = master.facing;
            if (rotation == EnumFacing.NORTH) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
            } else if (rotation == EnumFacing.WEST) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
            } else if (rotation == EnumFacing.SOUTH) {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
            ClientUtils.bindTexture((String)"immersivepetroleum:textures/blocks/lube_pipe12.png");
            if (master.mirrored) {
                ((ModelLubricantPipes.Pumpjack)((Object)pumpjackM)).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            } else {
                ((ModelLubricantPipes.Pumpjack)((Object)pumpjack)).func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        }

        @Override
        public Tuple<BlockPos, EnumFacing> getGhostBlockPosition(World world, TileEntityPumpjack tile) {
            if (!tile.isDummy()) {
                BlockPos pos = tile.func_174877_v().func_177967_a(tile.mirrored ? tile.facing.func_176735_f() : tile.facing.func_176746_e(), 2);
                EnumFacing f = tile.mirrored ? tile.facing.func_176746_e() : tile.facing.func_176735_f();
                return new Tuple((Object)pos, (Object)f);
            }
            return null;
        }

        @Override
        public int[] getStructureDimensions() {
            return new int[]{4, 6, 3};
        }
    }
}

