/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.anvil;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import net.minecraft.item.ItemStack;
import net.shadowfacts.shadowmc.anvil.AnvilRecipe;
import net.shadowfacts.shadowmc.util.ItemStackUtils;

public class BasicAnvilRecipe
implements AnvilRecipe {
    @NonNull
    private final ItemStack left;
    @NonNull
    private final ItemStack right;
    @NonNull
    private final ItemStack result;
    private int xp = 1;

    @Override
    public boolean matches(ItemStack left, ItemStack right) {
        return ItemStackUtils.areItemStacksEqual(this.getLeft(), left) && ItemStackUtils.areItemStacksEqual(this.getRight(), right);
    }

    @Override
    public ItemStack getLeft() {
        return this.left;
    }

    @Override
    public ItemStack getRight() {
        return this.right;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public int getXPCost() {
        return this.xp;
    }

    @ConstructorProperties(value={"left", "right", "result"})
    public BasicAnvilRecipe(@NonNull ItemStack left, @NonNull ItemStack right, @NonNull ItemStack result) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        if (result == null) {
            throw new NullPointerException("result");
        }
        this.left = left;
        this.right = right;
        this.result = result;
    }

    @ConstructorProperties(value={"left", "right", "result", "xp"})
    public BasicAnvilRecipe(@NonNull ItemStack left, @NonNull ItemStack right, @NonNull ItemStack result, int xp) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        if (result == null) {
            throw new NullPointerException("result");
        }
        this.left = left;
        this.right = right;
        this.result = result;
        this.xp = xp;
    }
}

