/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.core.api.genetics.IGene;
import binnie.core.genetics.Gene;
import binnie.genetics.genetics.GeneItem;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SequencerItem
extends GeneItem {
    private int sequenced = 0;
    private boolean analysed = false;

    public SequencerItem(IGene gene) {
        super(gene);
    }

    @Nullable
    public static SequencerItem create(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("gene", 10) && nbt.func_150297_b("seq", 1) && nbt.func_74764_b("ana")) {
            NBTTagCompound geneNbt = nbt.func_74775_l("gene");
            Gene gene = Gene.create(geneNbt);
            SequencerItem sequencerItem = new SequencerItem(gene);
            sequencerItem.sequenced = nbt.func_74771_c("seq");
            sequencerItem.analysed = nbt.func_74767_n("ana");
            return sequencerItem;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt2) {
        NBTTagCompound nbt = super.writeToNBT(nbt2);
        nbt.func_74774_a("seq", (byte)this.sequenced);
        nbt.func_74757_a("ana", this.analysed);
        return nbt;
    }

    public int getSequenced() {
        return this.sequenced;
    }

    public void setSequenced(int sequenced) {
        this.sequenced = sequenced;
    }

    public boolean isAnalysed() {
        return this.analysed;
    }

    public void setAnalysed(boolean analysed) {
        this.analysed = analysed;
    }
}

