/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.core.api.genetics.IGene;
import binnie.genetics.api.IItemChargeable;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSerum;
import binnie.genetics.item.ItemSerumArray;
import binnie.genetics.modules.ModuleCore;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Engineering {
    public static boolean isGeneAcceptor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IItemSerum) {
            return ((IItemSerum)item).getCharges(stack) == 0;
        }
        int metadata = stack.func_77960_j();
        return item == ModuleCore.itemGenetics && (metadata == GeneticsItems.EMPTY_SERUM.ordinal() || metadata == GeneticsItems.EMPTY_GENOME.ordinal());
    }

    public static boolean canAcceptGene(ItemStack stack, IGene gene) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemSerum) {
            return true;
        }
        if (item instanceof IItemSerum) {
            return ((IItemSerum)item).getSpeciesRoot(stack) == gene.getSpeciesRoot();
        }
        return Engineering.isGeneAcceptor(stack);
    }

    @Nullable
    public static IGene getGene(ItemStack stack, int chromosome) {
        Item item = stack.func_77973_b();
        if (item instanceof IItemSerum) {
            return ((IItemSerum)item).getGene(stack, chromosome);
        }
        return null;
    }

    public static ItemStack addGene(ItemStack stack, IGene gene) {
        Item item = stack.func_77973_b();
        int metadata = stack.func_77960_j();
        if (item instanceof IItemSerum) {
            ((IItemSerum)item).addGene(stack, gene);
        }
        if (item == ModuleCore.itemGenetics) {
            if (metadata == GeneticsItems.EMPTY_SERUM.ordinal()) {
                return ItemSerum.create(gene);
            }
            if (metadata == GeneticsItems.EMPTY_GENOME.ordinal()) {
                return ItemSerumArray.create(gene);
            }
        }
        return stack;
    }

    public static IGene[] getGenes(ItemStack serum) {
        if (!serum.func_190926_b()) {
            SequencerItem sequencerItem;
            Item item = serum.func_77973_b();
            if (item instanceof IItemSerum) {
                return ((IItemSerum)item).getGenes(serum);
            }
            if (item == ModuleCore.itemSequencer && (sequencerItem = SequencerItem.create(serum)) != null) {
                return new IGene[]{sequencerItem.getGene()};
            }
        }
        return new IGene[0];
    }

    public static int getCharges(ItemStack serum) {
        return ((IItemChargeable)serum.func_77973_b()).getCharges(serum);
    }
}

