/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.decorator;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.terrain.BlockWisp;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.DecoratorPositionProvider;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.WorldGenBigBulbCappedMushroom;
import thebetweenlands.common.world.gen.feature.WorldGenBladderwortCluster;
import thebetweenlands.common.world.gen.feature.WorldGenCaveGrass;
import thebetweenlands.common.world.gen.feature.WorldGenCaveHangers;
import thebetweenlands.common.world.gen.feature.WorldGenCaveMoss;
import thebetweenlands.common.world.gen.feature.WorldGenCavePots;
import thebetweenlands.common.world.gen.feature.WorldGenCaveThorns;
import thebetweenlands.common.world.gen.feature.WorldGenFluidPool;
import thebetweenlands.common.world.gen.feature.WorldGenMossCluster;
import thebetweenlands.common.world.gen.feature.WorldGenPlantCluster;
import thebetweenlands.common.world.gen.feature.WorldGenRootsCluster;
import thebetweenlands.common.world.gen.feature.WorldGenRottenLogs;
import thebetweenlands.common.world.gen.feature.WorldGenRottenWeedwoodTree;
import thebetweenlands.common.world.gen.feature.WorldGenSmallHollowLog;
import thebetweenlands.common.world.gen.feature.WorldGenSpeleothem;
import thebetweenlands.common.world.gen.feature.WorldGenSwampKelpCluster;
import thebetweenlands.common.world.gen.feature.WorldGenSwampReedCluster;
import thebetweenlands.common.world.gen.feature.WorldGenWaterRootsCluster;
import thebetweenlands.common.world.gen.feature.WorldGenWeedwoodBush;
import thebetweenlands.common.world.gen.feature.structure.WorldGenCragrockTower;
import thebetweenlands.common.world.gen.feature.structure.WorldGenIdolHeads;
import thebetweenlands.common.world.gen.feature.structure.WorldGenMudStructures;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSmallRuins;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSpawner;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSpawnerStructure;
import thebetweenlands.common.world.gen.feature.structure.WorldGenTarPoolDungeon;
import thebetweenlands.common.world.gen.feature.structure.WorldGenUndergroundRuins;
import thebetweenlands.common.world.gen.feature.structure.WorldGenWightFortress;
import thebetweenlands.common.world.gen.feature.tree.WorldGenGiantTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenGiantTreeDead;
import thebetweenlands.common.world.gen.feature.tree.WorldGenHearthgroveTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenNibbletwigTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenRubberTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenSapTree;
import thebetweenlands.common.world.gen.feature.tree.WorldGenSpiritTreeStructure;
import thebetweenlands.common.world.gen.feature.tree.WorldGenWeedwoodTree;
import thebetweenlands.util.CubicBezier;

public class DecorationHelper {
    public static final WorldGenerator GEN_SPELEOTHEM = new WorldGenSpeleothem();
    public static final WorldGenerator GEN_CAVE_POTS = new WorldGenCavePots();
    public static final WorldGenerator GEN_CAVE_THORNS = new WorldGenCaveThorns();
    public static final WorldGenerator GEN_CAVE_MOSS = new WorldGenCaveMoss();
    public static final WorldGenerator GEN_CAVE_HANGERS = new WorldGenCaveHangers();
    public static final WorldGenerator GEN_CAVE_GRASS = new WorldGenCaveGrass();
    public static final WorldGenerator GEN_WEEDWOOD_TREE = new WorldGenWeedwoodTree();
    public static final WorldGenerator GEN_ROTTEN_WEEDWOOD_TREE = new WorldGenRottenWeedwoodTree();
    public static final WorldGenerator GEN_SMALL_HOLLOW_LOG = new WorldGenSmallHollowLog();
    public static final WorldGenerator GEN_SWAMP_TALLGRASS = new WorldGenPlantCluster(BlockRegistry.SWAMP_TALLGRASS.func_176223_P());
    public static final WorldGenerator GEN_NETTLES = new WorldGenPlantCluster(BlockRegistry.NETTLE.func_176223_P(), 3, 128);
    public static final WorldGenerator GEN_ARROW_ARUM = new WorldGenPlantCluster(BlockRegistry.ARROW_ARUM.func_176223_P());
    public static final WorldGenerator GEN_PICKEREL_WEED = new WorldGenPlantCluster(BlockRegistry.PICKEREL_WEED.func_176223_P());
    public static final WorldGenerator GEN_MARSH_HIBISCUS = new WorldGenPlantCluster(BlockRegistry.MARSH_HIBISCUS.func_176223_P());
    public static final WorldGenerator GEN_MARSH_MALLOW = new WorldGenPlantCluster(BlockRegistry.MARSH_MALLOW.func_176223_P());
    public static final WorldGenerator GEN_BUTTON_BUSH = new WorldGenPlantCluster(BlockRegistry.BUTTON_BUSH.func_176223_P());
    public static final WorldGenerator GEN_SOFT_RUSH = new WorldGenPlantCluster(BlockRegistry.SOFT_RUSH.func_176223_P());
    public static final WorldGenerator GEN_BOTTLE_BRUSH_GRASS = new WorldGenPlantCluster(BlockRegistry.BOTTLE_BRUSH_GRASS.func_176223_P());
    public static final WorldGenerator GEN_STAGNANT_WATER_POOL = new WorldGenFluidPool(BlockRegistry.STAGNANT_WATER);
    public static final WorldGenerator GEN_TAR_POOL_SURFACE = new WorldGenFluidPool(BlockRegistry.TAR).setMinY(115);
    public static final WorldGenerator GEN_SWAMP_REED = new WorldGenSwampReedCluster();
    public static final WorldGenerator GEN_SWAMP_PLANT = new WorldGenPlantCluster(BlockRegistry.SWAMP_PLANT.func_176223_P(), 8, 256);
    public static final WorldGenerator GEN_FLAT_HEAD_MUSHROOM = new WorldGenPlantCluster(BlockRegistry.FLAT_HEAD_MUSHROOM.func_176223_P(), 5, 40);
    public static final WorldGenerator GEN_BLACK_HAT_MUSHROOM = new WorldGenPlantCluster(BlockRegistry.BLACK_HAT_MUSHROOM.func_176223_P(), 5, 40);
    public static final WorldGenerator GEN_CATTAIL = new WorldGenPlantCluster(BlockRegistry.CATTAIL.func_176223_P());
    public static final WorldGenerator GEN_VENUS_FLY_TRAP = new WorldGenPlantCluster(BlockRegistry.VENUS_FLY_TRAP.func_176223_P(), 5, 64);
    public static final WorldGenerator GEN_MIRE_CORAL = new WorldGenPlantCluster(BlockRegistry.MIRE_CORAL.func_176223_P(), 4, 10).setUnderwater(true);
    public static final WorldGenerator GEN_DEEP_WATER_CORAL = new WorldGenPlantCluster(BlockRegistry.DEEP_WATER_CORAL.func_176223_P(), 4, 10).setUnderwater(true);
    public static final WorldGenerator GEN_BLADDERWORT = new WorldGenBladderwortCluster();
    public static final WorldGenerator GEN_WATER_ROOTS = new WorldGenWaterRootsCluster();
    public static final WorldGenerator GEN_COPPER_IRIS = new WorldGenPlantCluster(BlockRegistry.COPPER_IRIS.func_176223_P());
    public static final WorldGenerator GEN_BLUE_IRIS = new WorldGenPlantCluster(BlockRegistry.BLUE_IRIS.func_176223_P());
    public static final WorldGenerator GEN_SWAMP_KELP = new WorldGenSwampKelpCluster();
    public static final WorldGenerator GEN_MILKWEED = new WorldGenPlantCluster(BlockRegistry.MILKWEED.func_176223_P());
    public static final WorldGenerator GEN_SHOOTS = new WorldGenPlantCluster(BlockRegistry.SHOOTS.func_176223_P());
    public static final WorldGenerator GEN_BLUE_EYED_GRASS = new WorldGenPlantCluster(BlockRegistry.BLUE_EYED_GRASS.func_176223_P());
    public static final WorldGenerator GEN_BONESET = new WorldGenPlantCluster(BlockRegistry.BONESET.func_176223_P());
    public static final WorldGenerator GEN_SLUDGECREEP = new WorldGenPlantCluster(BlockRegistry.SLUDGECREEP.func_176223_P());
    public static final WorldGenerator GEN_DEAD_WEEDWOOD_BUSH = new WorldGenPlantCluster(BlockRegistry.DEAD_WEEDWOOD_BUSH.func_176223_P());
    public static final WorldGenerator GEN_ROOTS = new WorldGenRootsCluster();
    public static final WorldGenerator GEN_WATER_WEEDS = new WorldGenPlantCluster(BlockRegistry.WATER_WEEDS.func_176223_P()).setUnderwater(true);
    public static final WorldGenerator GEN_UNDERGROUND_RUINS = new WorldGenUndergroundRuins();
    public static final WorldGenerator GEN_CRAGROCK_TOWER = new WorldGenCragrockTower();
    public static final WorldGenerator GEN_WEEDWOOD_BUSH = new WorldGenWeedwoodBush();
    public static final WorldGenerator GEN_SAP_TREE = new WorldGenSapTree();
    public static final WorldGenerator GEN_RUBBER_TREE = new WorldGenRubberTree();
    public static final WorldGenerator GEN_BIG_BULB_CAPPED_MUSHROOM = new WorldGenBigBulbCappedMushroom();
    public static final WorldGenerator GEN_MOSS = new WorldGenMossCluster(BlockRegistry.MOSS.func_176223_P());
    public static final WorldGenerator GEN_LICHEN = new WorldGenMossCluster(BlockRegistry.LICHEN.func_176223_P());
    public static final WorldGenerator GEN_MOSS_UNDERGROUND = new WorldGenMossCluster(BlockRegistry.MOSS.func_176223_P(), 4, 80);
    public static final WorldGenerator GEN_LICHEN_UNDERGROUND = new WorldGenMossCluster(BlockRegistry.LICHEN.func_176223_P(), 3, 40);
    public static final WorldGenerator GEN_SPAWNER_STRUCTURE = new WorldGenSpawnerStructure();
    public static final WorldGenerator GEN_IDOL_HEAD = new WorldGenIdolHeads();
    public static final WorldGenerator GEN_SMALL_RUINS = new WorldGenSmallRuins();
    public static final WorldGenGiantTree GEN_GIANT_TREE = new WorldGenGiantTree();
    public static final WorldGenerator GEN_NIBBLETWIG_TREE = new WorldGenNibbletwigTree();
    public static final WorldGenerator GEN_HEARTHGROVE_TREE = new WorldGenHearthgroveTree();
    public static final WorldGenerator GEN_BULB_CAPPED_MUSHROOMS = new WorldGenPlantCluster(BlockRegistry.BULB_CAPPED_MUSHROOM.func_176223_P(), 5, 40);
    public static final WorldGenerator GEN_SPAWNER = new WorldGenSpawner();
    public static final WorldGenWightFortress GEN_WIGHT_FORTRESS = new WorldGenWightFortress();
    public static final WorldGenerator GEN_DEAD_TRUNK = new WorldGenGiantTreeDead();
    public static final WorldGenerator GEN_MUD_STRUCTURES = new WorldGenMudStructures();
    public static final WorldGenerator GEN_TAR_POOL_DUNGEON = new WorldGenTarPoolDungeon();
    public static final WorldGenerator GEN_SPIRIT_TREE_STRUCTURE = new WorldGenSpiritTreeStructure();
    private static final CubicBezier SPELEOTHEM_Y_CDF = new CubicBezier(0.0f, 0.5f, 1.0f, 0.2f);
    private static final CubicBezier CAVE_POTS_Y_CDF = new CubicBezier(0.0f, 1.0f, 0.0f, 1.0f);
    private static final CubicBezier THORNS_Y_CDF = new CubicBezier(1.0f, 0.5f, 1.0f, -0.25f);
    private static final CubicBezier CAVE_MOSS_Y_CDF = new CubicBezier(0.5f, 1.0f, 0.8f, 1.0f);
    private static final CubicBezier CAVE_HANGERS_Y_CDF = new CubicBezier(0.8f, 1.0f, 0.5f, 0.0f);
    private static final CubicBezier CAVE_GRASS_Y_CDF = new CubicBezier(0.25f, 1.0f, 0.9f, 1.0f);

    private static boolean canShortThingsGenerateHere(DecoratorPositionProvider decorator) {
        return ((ChunkGeneratorBetweenlands)decorator.getChunkGenerator()).evalTreeNoise((double)decorator.getX() * 0.01, (double)decorator.getZ() * 0.01) > -0.25;
    }

    private static int getSpeleothemAttemptAdditive(DecoratorPositionProvider decorator) {
        return (int)((((ChunkGeneratorBetweenlands)decorator.getChunkGenerator()).evalSpeleothemDensityNoise((double)decorator.getX() * 0.03, (double)decorator.getZ() * 0.03) * 0.5 + 0.5) * 25.0);
    }

    public static boolean generatePhragmites(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.PHRAGMITES.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean populateCaves(BiomeDecoratorBetweenlands decorator) {
        decorator.generate(2 + DecorationHelper.getSpeleothemAttemptAdditive(decorator), DecorationHelper::generateSpeleothemCluster);
        decorator.generate(decorator.getRand().nextInt(3) == 0 ? 2.0f : 1.0f, DecorationHelper::generateCavePotsCluster);
        decorator.generate(140.0f, DecorationHelper::generateCaveThornsCluster);
        decorator.generate(120.0f, DecorationHelper::generateCaveMossCluster);
        decorator.generate(120.0f, DecorationHelper::generateCaveHangersCluster);
        decorator.generate(25.0f, DecorationHelper::generateUndergroundMossCluster);
        decorator.generate(5.0f, DecorationHelper::generateUndergroundLichenCluster);
        decorator.generate(120.0f, DecorationHelper::generateCaveGrassCluster);
        return true;
    }

    public static boolean generateSpeleothemCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = SPELEOTHEM_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 105.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        boolean generated = false;
        for (int i = 0; i < 35; ++i) {
            int gx = x + decorator.getRand().nextInt(7) - 3;
            int gy = y + decorator.getRand().nextInt(7) - 3;
            int gz = z + decorator.getRand().nextInt(7) - 3;
            generated |= GEN_SPELEOTHEM.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(gx, gy, gz));
        }
        return generated;
    }

    public static boolean generateSpeleothem(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = SPELEOTHEM_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 105.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_SPELEOTHEM.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateCavePotsCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = CAVE_POTS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 90.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_CAVE_POTS.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateCaveThornsCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = THORNS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 105.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_CAVE_THORNS.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateCaveMossCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = CAVE_MOSS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 105.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_CAVE_MOSS.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateCaveHangersCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX(9);
        float v = CAVE_HANGERS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 105.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ(9);
        return GEN_CAVE_HANGERS.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateUndergroundMossCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = CAVE_MOSS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 95.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_MOSS_UNDERGROUND.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateUndergroundLichenCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = CAVE_MOSS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 95.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_LICHEN_UNDERGROUND.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateCaveGrassCluster(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        float v = CAVE_GRASS_Y_CDF.eval(decorator.getRand().nextFloat());
        int y = (int)(v * 30.0f + 15.0f + 0.5f);
        int z = decorator.getRandomPosZ();
        return GEN_CAVE_GRASS.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateSpawner(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX(13);
        int y = decorator.getRand().nextInt(90);
        int z = decorator.getRandomPosZ(13);
        return GEN_SPAWNER.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateTarPoolDungeon(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX(10);
        int y = decorator.getRand().nextInt(90);
        int z = decorator.getRandomPosZ(10);
        return GEN_TAR_POOL_DUNGEON.func_180709_b(decorator.getWorld(), decorator.getRand(), new BlockPos(x, y, z));
    }

    public static boolean generateWeedwoodTree(DecoratorPositionProvider decorator) {
        if (DecorationHelper.canShortThingsGenerateHere(decorator)) {
            BlockPos pos = decorator.getRandomPos(14);
            World world = decorator.getWorld();
            if (world.func_175623_d(pos) && SurfaceType.GRASS.matches(world, pos.func_177977_b()) || SurfaceType.WATER.matches(world, pos) && SurfaceType.DIRT.matches(world, pos.func_177977_b())) {
                return GEN_WEEDWOOD_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos.func_177977_b());
            }
        }
        return false;
    }

    public static boolean generateNibbletwigTree(DecoratorPositionProvider decorator) {
        if (DecorationHelper.canShortThingsGenerateHere(decorator)) {
            BlockPos pos = decorator.getRandomPos(10);
            World world = decorator.getWorld();
            if (world.func_175623_d(pos) && SurfaceType.GRASS.matches(world, pos.func_177977_b())) {
                return GEN_NIBBLETWIG_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos.func_177977_b());
            }
        }
        return false;
    }

    public static boolean generateHearthgroveTree(DecoratorPositionProvider decorator) {
        if (DecorationHelper.canShortThingsGenerateHere(decorator)) {
            BlockPos pos = decorator.getRandomPos(12);
            World world = decorator.getWorld();
            if (world.func_175623_d(pos) && SurfaceType.GRASS.matches(world, pos.func_177977_b()) || SurfaceType.WATER.matches(world, pos) && SurfaceType.DIRT.matches(world, pos.func_177977_b())) {
                return GEN_HEARTHGROVE_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos.func_177977_b());
            }
        }
        return false;
    }

    public static boolean generateRottenWeedwoodTree(DecoratorPositionProvider decorator) {
        if (DecorationHelper.canShortThingsGenerateHere(decorator)) {
            BlockPos pos = decorator.getRandomPos(14);
            World world = decorator.getWorld();
            if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistry.MUD) {
                return GEN_ROTTEN_WEEDWOOD_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos.func_177977_b());
            }
        }
        return false;
    }

    public static boolean generateSmallHollowLog(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SMALL_HOLLOW_LOG.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSwampTallgrassCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SWAMP_TALLGRASS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSundew(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.SUNDEW.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateNettlesCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_NETTLES.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateWeepingBlue(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.WEEPING_BLUE.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateArrowArumCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_ARROW_ARUM.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generatePickerelWeedCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_PICKEREL_WEED.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateMarshHibiscusCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_MARSH_HIBISCUS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateMarshMallowCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_MARSH_MALLOW.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateButtonBushCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BUTTON_BUSH.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSoftRushCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SOFT_RUSH.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateBroomsedge(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.BROOMSEDGE.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateBottleBrushGrassCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BOTTLE_BRUSH_GRASS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateStagnantWaterPool(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        int y = 6 + decorator.getRand().nextInt(55);
        int z = decorator.getRandomPosZ();
        BlockPos pos = new BlockPos(x, y, z);
        if (SurfaceType.UNDERGROUND.matches(decorator.getWorld(), pos)) {
            return GEN_STAGNANT_WATER_POOL.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateTarPoolSurface(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX();
        int y = 6 + decorator.getRand().nextInt(140);
        int z = decorator.getRandomPosZ();
        BlockPos pos = new BlockPos(x, y, z);
        if (SurfaceType.UNDERGROUND.matches(decorator.getWorld(), pos) || SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos)) {
            return GEN_TAR_POOL_SURFACE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSwampReedCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround(10);
        World world = decorator.getWorld();
        if (SurfaceType.WATER.matches(world, pos.func_177984_a()) && world.func_180495_p(pos).func_177230_c() == BlockRegistry.MUD && world.func_175623_d(pos.func_177981_b(2))) {
            return GEN_SWAMP_REED.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        if (SurfaceType.MIXED_GROUND.matches(world, pos) && BlockRegistry.SWAMP_REED.func_176196_c(world, pos.func_177984_a())) {
            return GEN_SWAMP_REED.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSwampPlantCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SWAMP_PLANT.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateVenusFlyTrapCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_VENUS_FLY_TRAP.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generatePitcherPlant(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.PITCHER_PLANT.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateFlatHeadMushroomCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && !decorator.getWorld().func_175623_d(pos.func_177977_b())) {
            return GEN_FLAT_HEAD_MUSHROOM.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateBlackHatMushroomCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && !decorator.getWorld().func_175623_d(pos.func_177977_b())) {
            return GEN_BLACK_HAT_MUSHROOM.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateVolarpad(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.VOLARPAD.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateTallCattail(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.TALL_CATTAIL.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateSwampDoubleTallgrass(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.SWAMP_DOUBLE_TALLGRASS.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateCattailCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_CATTAIL.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateMireCoralCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (SurfaceType.WATER.matches(decorator.getWorld(), pos) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_MIRE_CORAL.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateDeepWaterCoralCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (SurfaceType.WATER.matches(decorator.getWorld(), pos) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_DEEP_WATER_CORAL.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateBladderwortCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround(10);
        if (SurfaceType.WATER.matches(decorator.getWorld(), pos) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BLADDERWORT.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateWaterRootsCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround(10);
        if (SurfaceType.WATER.matches(decorator.getWorld(), pos) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_WATER_ROOTS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateCopperIrisCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_COPPER_IRIS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateBlueIrisCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BLUE_IRIS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSwampKelpCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround(10);
        if (SurfaceType.WATER.matches(decorator.getWorld(), pos) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SWAMP_KELP.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateMilkweedCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_MILKWEED.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateShootsCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SHOOTS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateCardinalFlower(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            BlockRegistry.CARDINAL_FLOWER.placeAt(decorator.getWorld(), pos, 2);
            return true;
        }
        return false;
    }

    public static boolean generateBlueEyedGrassCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BLUE_EYED_GRASS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateBonesetCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BONESET.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateMarshMarigold(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.WATER.matches(decorator.getWorld(), pos.func_177977_b()) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177979_c(2))) {
            decorator.getWorld().func_175656_a(pos.func_177977_b(), BlockRegistry.MARSH_MARIGOLD_STALK.func_176223_P());
            decorator.getWorld().func_175656_a(pos, BlockRegistry.MARSH_MARIGOLD_FLOWER.func_176223_P());
            return true;
        }
        return false;
    }

    public static boolean generateBogBean(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.WATER.matches(decorator.getWorld(), pos.func_177977_b()) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177979_c(2))) {
            decorator.getWorld().func_175656_a(pos.func_177977_b(), BlockRegistry.BOG_BEAN_STALK.func_176223_P());
            decorator.getWorld().func_175656_a(pos, BlockRegistry.BOG_BEAN_FLOWER.func_176223_P());
            return true;
        }
        return false;
    }

    public static boolean generateGoldenClub(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.WATER.matches(decorator.getWorld(), pos.func_177977_b()) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177979_c(2))) {
            decorator.getWorld().func_175656_a(pos.func_177977_b(), BlockRegistry.GOLDEN_CLUB_STALK.func_176223_P());
            decorator.getWorld().func_175656_a(pos, BlockRegistry.GOLDEN_CLUB_FLOWER.func_176223_P());
            return true;
        }
        return false;
    }

    public static boolean generateSludgecreepCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SLUDGECREEP.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateDeadWeedwoodBushCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_DEAD_WEEDWOOD_BUSH.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateRootsCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos(10);
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_ROOTS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateWaterWeedsCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (SurfaceType.WATER.matches(decorator.getWorld(), pos) && SurfaceType.DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_WATER_WEEDS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateUndergroundRuins(DecoratorPositionProvider decorator) {
        int x = decorator.getRandomPosX(10);
        int y = 15 + decorator.getRand().nextInt(20);
        int z = decorator.getRandomPosZ(10);
        BlockPos pos = new BlockPos(x, y, z);
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.UNDERGROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_UNDERGROUND_RUINS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateCragrockTower(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround(10);
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_CRAGROCK_TOWER.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateWeedwoodBush(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.PLANT_DECORATION_SOIL.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_WEEDWOOD_BUSH.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSapTree(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.GRASS_AND_DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SAP_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateRubberTree(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.GRASS_AND_DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_RUBBER_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateBigBulbCappedMushroom(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.GRASS_AND_DIRT.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_BIG_BULB_CAPPED_MUSHROOM.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateMossCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && decorator.getWorld().func_180495_p(pos.func_177977_b()).func_185915_l()) {
            return GEN_MOSS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateLichenCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && decorator.getWorld().func_180495_p(pos.func_177977_b()).func_185915_l()) {
            return GEN_LICHEN.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSpawnerStructure(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SPAWNER_STRUCTURE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSunkenIdolHead(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b()) && SurfaceType.WATER.matches(decorator.getWorld(), pos.func_177984_a())) {
            return GEN_IDOL_HEAD.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSmallRuinsCluster(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            return GEN_SMALL_RUINS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateFallenLeaves(DecoratorPositionProvider decorator) {
        World world = decorator.getWorld();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        boolean generated = false;
        for (int xo = 0; xo < 32; ++xo) {
            for (int zo = 0; zo < 32; ++zo) {
                int pz;
                int py;
                int px = decorator.getX() + xo;
                Block surfaceBlock = world.func_180495_p((BlockPos)checkPos.func_181079_c(px, py = world.func_189649_b(px, pz = decorator.getZ() + zo) - 1, pz)).func_177230_c();
                if (!(surfaceBlock instanceof BlockLeaves)) continue;
                int yo = 0;
                boolean hasLeaves = true;
                for (int i = 0; i < 128 && py - ++yo > 110; ++i) {
                    IBlockState cBlockState = world.func_180495_p((BlockPos)checkPos.func_181079_c(px, py - yo, pz));
                    boolean isBlockLeaves = cBlockState.func_177230_c() instanceof BlockLeaves;
                    if (isBlockLeaves) {
                        hasLeaves = true;
                    }
                    if (hasLeaves && (SurfaceType.GRASS_AND_DIRT.matches(cBlockState) || cBlockState.func_177230_c() == BlockRegistry.LOG_WEEDWOOD) && world.func_175623_d((BlockPos)checkPos.func_181079_c(px, py - yo + 1, pz)) && decorator.getRand().nextInt(3) == 0) {
                        world.func_180501_a(new BlockPos(px, py - yo + 1, pz), BlockRegistry.FALLEN_LEAVES.func_176223_P(), 18);
                        generated = true;
                    }
                    if (isBlockLeaves || !cBlockState.func_185914_p()) continue;
                    hasLeaves = false;
                }
            }
        }
        return generated;
    }

    public static boolean generateWisp(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.WATER.matches(decorator.getWorld(), pos.func_177977_b())) {
            Collection allowedValues = BlockWisp.COLOR.func_177700_c();
            int color = 0;
            int rand = decorator.getRand().nextInt(allowedValues.size());
            for (Integer c : allowedValues) {
                if (rand-- >= 0) continue;
                color = c;
            }
            return decorator.getWorld().func_175656_a(pos, BlockRegistry.WISP.func_176223_P().func_177226_a((IProperty)BlockWisp.COLOR, (Comparable)Integer.valueOf(color)));
        }
        return false;
    }

    public static boolean generateGiantTree(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPosSeaGround();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld().func_180495_p(pos.func_177977_b()))) {
            pos = pos.func_177982_a(0, -8, 0);
            return GEN_GIANT_TREE.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateWightFortress(DecoratorPositionProvider decorator) {
        Biome biome;
        BlockPos pos = decorator.getRandomPos(1);
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b()) && GEN_WIGHT_FORTRESS.isBiomeValid(biome = decorator.getWorld().func_180494_b(pos))) {
            return GEN_WIGHT_FORTRESS.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateRottenLogs(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            WorldGenRottenLogs gen = new WorldGenRottenLogs(decorator.getRand().nextInt(5) + 4, decorator.getRand().nextInt(3) + 2, (byte)decorator.getRand().nextInt(2));
            gen.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateDeadTrunk(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos();
        if (decorator.getWorld().func_175623_d(pos) && SurfaceType.MIXED_GROUND.matches(decorator.getWorld(), pos.func_177977_b())) {
            GEN_DEAD_TRUNK.func_180709_b(decorator.getWorld(), decorator.getRand(), pos.func_177979_c(8 + decorator.getRand().nextInt(5)));
        }
        return false;
    }

    public static boolean generateMudStructures(DecoratorPositionProvider decorator) {
        BlockPos pos = decorator.getRandomPos(10);
        if (decorator.getWorld().func_175623_d(pos) && decorator.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistry.MUD) {
            return GEN_MUD_STRUCTURES.func_180709_b(decorator.getWorld(), decorator.getRand(), pos);
        }
        return false;
    }

    public static boolean generateSwamplandsClearingSpiritTree(DecoratorPositionProvider decorator) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int checkRadius = 36;
        for (int xo = 0; xo < 32; xo += 4) {
            for (int zo = 0; zo < 32; zo += 4) {
                Biome biomeN = decorator.getWorld().func_180494_b((BlockPos)pos.func_181079_c(decorator.getX() + xo, decorator.getY(), decorator.getZ() + zo - checkRadius));
                Biome biomeE = decorator.getWorld().func_180494_b((BlockPos)pos.func_181079_c(decorator.getX() + xo + checkRadius, decorator.getY(), decorator.getZ() + zo));
                Biome biomeS = decorator.getWorld().func_180494_b((BlockPos)pos.func_181079_c(decorator.getX() + xo, decorator.getY(), decorator.getZ() + zo + checkRadius));
                Biome biomeW = decorator.getWorld().func_180494_b((BlockPos)pos.func_181079_c(decorator.getX() + xo - checkRadius, decorator.getY(), decorator.getZ() + zo));
                if (biomeN != BiomeRegistry.SWAMPLANDS_CLEARING || biomeE != BiomeRegistry.SWAMPLANDS_CLEARING || biomeS != BiomeRegistry.SWAMPLANDS_CLEARING || biomeW != BiomeRegistry.SWAMPLANDS_CLEARING) continue;
                pos.func_181079_c(decorator.getX() + xo, decorator.getY(), decorator.getZ() + zo);
                pos.func_185336_p(decorator.getWorld().func_175726_f((BlockPos)pos).func_76611_b(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF));
                BlockPos genPos = null;
                for (int i = 0; i > -8; --i) {
                    if (SurfaceType.MIXED_GROUND.matches(decorator.getWorld().func_180495_p((BlockPos)pos))) {
                        genPos = pos.func_185334_h().func_177984_a();
                        break;
                    }
                    pos.func_185336_p(pos.func_177956_o() - 1);
                }
                if (genPos == null) continue;
                return GEN_SPIRIT_TREE_STRUCTURE.func_180709_b(decorator.getWorld(), decorator.getRand(), genPos);
            }
        }
        return false;
    }
}

