/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.serverbound;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.network.MessageEntity;
import thebetweenlands.common.registries.CapabilityRegistry;

public class MessageEquipItem
extends MessageEntity {
    private int sourceSlot;
    private int mode;
    private EnumEquipmentInventory inventory;

    public MessageEquipItem() {
    }

    public MessageEquipItem(int sourceSlot, Entity target) {
        this.addEntity(target);
        this.sourceSlot = sourceSlot;
        this.mode = 0;
    }

    public MessageEquipItem(Entity target, EnumEquipmentInventory inventory, int slot) {
        this.addEntity(target);
        this.sourceSlot = slot;
        this.inventory = inventory;
        this.mode = 1;
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.writeInt(this.mode);
        switch (this.mode) {
            default: {
                buf.writeInt(this.sourceSlot);
                break;
            }
            case 1: {
                buf.writeInt(this.sourceSlot);
                buf.writeInt(this.inventory.id);
            }
        }
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.mode = buf.readInt();
        switch (this.mode) {
            default: {
                this.sourceSlot = buf.readInt();
                break;
            }
            case 1: {
                this.sourceSlot = buf.readInt();
                this.inventory = EnumEquipmentInventory.fromID(buf.readInt());
            }
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.getServerHandler() != null) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            Entity target = this.getEntity(0);
            if (target != null && target.hasCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) {
                switch (this.mode) {
                    default: {
                        if (this.sourceSlot < -1 || this.sourceSlot >= sender.field_71071_by.func_70302_i_()) break;
                        ItemStack stack = this.sourceSlot == -1 ? sender.func_184586_b(EnumHand.OFF_HAND) : sender.field_71071_by.func_70301_a(this.sourceSlot);
                        ItemStack result = EquipmentHelper.equipItem((EntityPlayer)sender, target, stack, false);
                        if (!sender.field_71075_bZ.field_75098_d) {
                            if (this.sourceSlot == -1) {
                                sender.func_184611_a(EnumHand.OFF_HAND, result);
                            } else {
                                sender.field_71071_by.func_70299_a(this.sourceSlot, result);
                            }
                        }
                        if (!result.func_190926_b() && result.func_190916_E() == stack.func_190916_E()) break;
                        sender.func_146105_b((ITextComponent)new TextComponentTranslation("chat.equipment.equipped", new Object[]{new TextComponentTranslation(stack.func_77977_a() + ".name", new Object[0])}), true);
                        break;
                    }
                    case 1: {
                        ItemStack stack;
                        if (this.sourceSlot < 0 || (stack = EquipmentHelper.unequipItem((EntityPlayer)sender, target, this.inventory, this.sourceSlot, false)).func_190926_b()) break;
                        sender.func_146105_b((ITextComponent)new TextComponentTranslation("chat.equipment.unequipped", new Object[]{new TextComponentTranslation(stack.func_77977_a() + ".name", new Object[0])}), true);
                        if (sender.field_71071_by.func_70441_a(stack)) break;
                        target.func_70099_a(stack, target.func_70047_e());
                    }
                }
            }
        }
        return null;
    }
}

