/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.world.storage.WorldStorageImpl;

public class MessageRemoveLocalStorage
extends MessageBase {
    private StorageID id;

    public MessageRemoveLocalStorage() {
    }

    public MessageRemoveLocalStorage(StorageID id) {
        this.id = id;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        try {
            this.id = StorageID.readFromNBT(buf.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_150786_a(this.id.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        IWorldStorage worldStorage;
        ILocalStorageHandler localStorageHandler;
        ILocalStorage loadedStorage;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (loadedStorage = (localStorageHandler = (worldStorage = WorldStorageImpl.getCapability((World)world)).getLocalStorageHandler()).getLocalStorage(this.id)) != null) {
            localStorageHandler.removeLocalStorage(loadedStorage);
        }
    }
}

