/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.shields.ItemLivingWeedwoodShield;
import thebetweenlands.common.network.MessageEntity;
import thebetweenlands.common.registries.ItemRegistry;

public class MessageLivingWeedwoodShieldSpit
extends MessageEntity {
    private boolean mainhand;
    private int ticks;

    public MessageLivingWeedwoodShieldSpit() {
    }

    public MessageLivingWeedwoodShieldSpit(EntityLivingBase owner, boolean mainhand, int ticks) {
        this.addEntity((Entity)owner);
        this.mainhand = mainhand;
        this.ticks = ticks;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.mainhand = buf.readBoolean();
        this.ticks = buf.readInt();
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.writeBoolean(this.mainhand);
        buf.writeInt(this.ticks);
    }

    @Override
    public IMessage process(MessageContext ctx) {
        super.process(ctx);
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        EntityLivingBase living;
        ItemStack held;
        Entity owner = this.getEntity(0);
        if (owner instanceof EntityLivingBase && !(held = (living = (EntityLivingBase)owner).func_184586_b(this.mainhand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND)).func_190926_b() && held.func_77973_b() instanceof ItemLivingWeedwoodShield) {
            ((ItemLivingWeedwoodShield)held.func_77973_b()).setSpitTicks(held, this.ticks);
            float yaw = -(180.0f - living.field_70761_aq);
            Vec3d lookVec = living.func_70040_Z();
            Vec3d bodyForward = new Vec3d((double)MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)), 0.0, (double)MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)));
            Vec3d up = new Vec3d(0.0, 1.0, 0.0);
            Vec3d right = bodyForward.func_72431_c(up);
            Vec3d offset = new Vec3d(bodyForward.field_72450_a * 0.5, (double)owner.func_70047_e(), bodyForward.field_72449_c * 0.5).func_178787_e(right.func_186678_a(this.mainhand ? 0.35 : -0.35).func_72441_c(0.0, lookVec.field_72448_b * 0.5 - 0.4, 0.0).func_178787_e(bodyForward.func_186678_a(-0.1)));
            int itemId = Item.func_150891_b((Item)ItemRegistry.SAP_SPIT);
            for (int i = 0; i < 20; ++i) {
                double dx = living.field_70170_p.field_73012_v.nextDouble() * 0.2 - 0.1 + bodyForward.field_72450_a * 0.1;
                double dy = living.field_70170_p.field_73012_v.nextDouble() * 0.2 - 0.1 + bodyForward.field_72448_b * 0.1 + 0.08;
                double dz = living.field_70170_p.field_73012_v.nextDouble() * 0.2 - 0.1 + bodyForward.field_72449_c * 0.1;
                living.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, living.field_70165_t + offset.field_72450_a + dx, living.field_70163_u + offset.field_72448_b + dy, living.field_70161_v + offset.field_72449_c + dz, dx * 1.25, dy, dz * 1.25, new int[]{itemId});
            }
        }
    }
}

