/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import thebetweenlands.api.entity.IEntityWithLootModifier;

public class LootConditionKilledLootModifier
implements LootCondition {
    private final float min;
    private final float max;
    private final String key;
    private final boolean invert;

    public LootConditionKilledLootModifier(String key, float min, float max, boolean invert) {
        this.key = key;
        this.min = min;
        this.max = max;
        this.invert = invert;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Map<String, Float> map;
        Entity entity = context.func_186493_a();
        if (entity instanceof IEntityWithLootModifier && (map = ((IEntityWithLootModifier)entity).getLootModifiers(context, false)) != null && map.containsKey(this.key)) {
            float value = map.get(this.key).floatValue();
            return (value >= this.min && value <= this.max) == !this.invert;
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<LootConditionKilledLootModifier> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "killed_loot_modifier"), LootConditionKilledLootModifier.class);
        }

        public void serialize(JsonObject json, LootConditionKilledLootModifier value, JsonSerializationContext context) {
            json.add("min", (JsonElement)new JsonPrimitive((Number)Float.valueOf(value.min)));
            json.add("max", (JsonElement)new JsonPrimitive((Number)Float.valueOf(value.max)));
            json.add("key", (JsonElement)new JsonPrimitive(value.key));
            json.add("invert", (JsonElement)new JsonPrimitive(Boolean.valueOf(value.invert)));
        }

        public LootConditionKilledLootModifier deserialize(JsonObject json, JsonDeserializationContext context) {
            float min = JsonUtils.func_151217_k((JsonObject)json, (String)"min");
            float max = JsonUtils.func_151217_k((JsonObject)json, (String)"max");
            String key = JsonUtils.func_151200_h((JsonObject)json, (String)"key");
            boolean invert = JsonUtils.func_151212_i((JsonObject)json, (String)"invert");
            return new LootConditionKilledLootModifier(key, min, max, invert);
        }
    }
}

