/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemMagicItemMagnet
extends Item
implements IEquippable,
IAnimatorRepairable {
    public ItemMagicItemMagnet() {
        this.func_77637_a(BLCreativeTabs.SPECIALS);
        this.func_77625_d(1);
        this.func_77656_e(2048);
        IEquippable.addEquippedPropertyOverrides(this);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("magnetActive") : false;
    }

    @Override
    public EnumEquipmentInventory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentInventory.MISC;
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity target) {
        return true;
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity target) {
        return player == target && EquipmentHelper.getEquipment(EnumEquipmentInventory.MISC, target, this).func_190926_b();
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity target, IInventory inventory) {
        return true;
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, IInventory inventory) {
        return true;
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("magnetActive", true);
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("magnetActive", false);
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        if (stack.func_77952_i() < stack.func_77958_k()) {
            double range = 7.0;
            AxisAlignedBB area = new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v).func_186662_g(range);
            List entities = entity.field_70170_p.func_175647_a(EntityItem.class, area, e -> e.func_70092_e(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v) <= range * range);
            for (EntityItem item : entities) {
                if (!item.func_189652_ae()) {
                    NBTTagCompound nbt = item.getEntityData();
                    boolean isGravityCompensated = false;
                    if (nbt.func_150297_b("thebetweenlands.item_magnet_last_gravity_update", 3) && nbt.func_74762_e("thebetweenlands.item_magnet_last_gravity_update") == item.field_70173_aa) {
                        isGravityCompensated = true;
                    }
                    nbt.func_74768_a("thebetweenlands.item_magnet_last_gravity_update", item.field_70173_aa);
                    if (!isGravityCompensated) {
                        item.field_70181_x += (double)0.04f;
                    }
                }
                double dx = entity.field_70165_t - item.field_70165_t;
                double dy = entity.field_70163_u + (double)(entity.field_70131_O / 2.0f) - (item.field_70163_u + (double)(item.field_70131_O / 2.0f));
                double dz = entity.field_70161_v - item.field_70161_v;
                double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (!entity.field_70170_p.field_72995_K) {
                    item.field_70159_w += dx / len * 0.015;
                    item.field_70181_x = item.field_70122_E ? (item.field_70181_x += 0.015) : (item.field_70181_x += dy / len * 0.015);
                    item.field_70179_y += dz / len * 0.015;
                    item.field_70133_I = true;
                    continue;
                }
                this.spawnParticles(item);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnParticles(EntityItem item) {
        if (item.field_70173_aa % 4 == 0) {
            BLParticles.CORRUPTED.spawn(item.field_70170_p, item.field_70165_t, item.field_70163_u + (double)(item.field_70131_O / 2.0f) + 0.25, item.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withScale(0.5f));
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return 8;
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return 32;
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return 16;
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return 38;
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack magnet;
        if (!event.player.field_70170_p.field_72995_K && !(magnet = EquipmentHelper.getEquipment(EnumEquipmentInventory.MISC, (Entity)event.player, ItemRegistry.MAGIC_ITEM_MAGNET)).func_190926_b()) {
            magnet.func_77972_a(1, (EntityLivingBase)event.player);
        }
    }
}

