/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IPortalCapability;
import thebetweenlands.client.audio.PortalSound;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationPortal;
import thebetweenlands.common.world.teleporter.TeleporterHandler;

public class PlayerPortalHandler {
    public static final int MAX_PORTAL_TIME = 120;

    @SubscribeEvent
    public static void teleportCheck(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        IPortalCapability cap;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && (cap = (IPortalCapability)(player = (EntityPlayer)entity).getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) != null) {
            if (cap.isInPortal()) {
                AxisAlignedBB aabb;
                BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                boolean inPortalBlock = false;
                if (state.func_177230_c() instanceof BlockTreePortal && (aabb = state.func_185900_c((IBlockAccess)player.field_70170_p, pos)) != null && aabb.func_186670_a(pos).func_72326_a(player.func_174813_aQ())) {
                    inPortalBlock = true;
                }
                if (inPortalBlock) {
                    if (!cap.wasTeleported()) {
                        if (cap.getTicksUntilTeleport() <= 0 || player.field_71075_bZ.field_75098_d) {
                            if (player.field_70170_p instanceof WorldServer) {
                                WorldServer otherDim;
                                BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(player.field_70170_p);
                                AxisAlignedBB entityAabb = player.func_174813_aQ();
                                List<LocationPortal> portals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, entityAabb, loc -> loc.intersects(entityAabb));
                                LocationPortal portal = null;
                                if (!portals.isEmpty()) {
                                    portal = portals.get(0);
                                }
                                int targetDim = BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId;
                                if (portal != null && (portal.getOtherPortalPosition() != null || portal.hasTargetDimension())) {
                                    targetDim = portal.getOtherPortalDimension();
                                } else if (player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                                    targetDim = BetweenlandsConfig.WORLD_AND_DIMENSION.portalDefaultReturnDimension;
                                }
                                if (targetDim != player.field_71093_bK && (otherDim = ((WorldServer)player.field_70170_p).func_73046_m().func_71218_a(targetDim)) != null) {
                                    TeleporterHandler.transferToDim((Entity)player, (World)otherDim);
                                }
                            }
                            player.field_71088_bW = 10;
                            cap.setInPortal(false);
                            cap.setTicksUntilTeleport(120);
                        } else {
                            cap.setTicksUntilTeleport(cap.getTicksUntilTeleport() - 1);
                        }
                    }
                } else {
                    cap.setTicksUntilTeleport(120);
                    cap.setInPortal(false);
                    cap.setWasTeleported(false);
                }
            } else {
                cap.setTicksUntilTeleport(120);
                if (!cap.isInPortal()) {
                    cap.setWasTeleported(false);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        IPortalCapability cap;
        EntityPlayerSP player;
        if (event.phase == TickEvent.Phase.END && (player = Minecraft.func_71410_x().field_71439_g) != null && (cap = (IPortalCapability)player.getCapability(CapabilityRegistry.CAPABILITY_PORTAL, null)) != null) {
            int timer;
            boolean renderPortalEffect;
            boolean bl = renderPortalEffect = cap.isInPortal() && !cap.wasTeleported();
            if (renderPortalEffect && (timer = cap.getTicksUntilTeleport()) < 120) {
                player.func_71053_j();
                if (timer == 119) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PortalSound(SoundRegistry.PORTAL_TRIGGER, SoundCategory.BLOCKS, (EntityPlayer)player));
                }
                if (timer == 2) {
                    player.func_184185_a((SoundEvent)SoundRegistry.PORTAL_TRAVEL, 1.0f, 0.8f);
                }
            }
            if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
                WorldShader shader = ShaderHelper.INSTANCE.getWorldShader();
                if (!renderPortalEffect) {
                    shader.setSwirlAngle(0.0f);
                } else {
                    float swirl = shader.getSwirlAngle(1.0f);
                    if (swirl < 2.0f) {
                        shader.setSwirlAngle(swirl + swirl * 0.055f + 5.0E-4f);
                    } else {
                        shader.setSwirlAngle(swirl + swirl * 0.055f / (swirl - 1.0f) + 5.0E-4f);
                    }
                }
            }
        }
    }
}

