/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.entity.IEntityCustomBlockCollisions;

public final class CustomEntityBlockCollisionsHandler {
    private static boolean gathering = false;

    private CustomEntityBlockCollisionsHandler() {
    }

    @SubscribeEvent
    public static void onGatherCollisionBoxes(GetCollisionBoxesEvent event) {
        if (!gathering && event.getEntity() instanceof IEntityCustomBlockCollisions) {
            gathering = true;
            ((IEntityCustomBlockCollisions)event.getEntity()).getCustomCollisionBoxes(event.getAabb(), event.getCollisionBoxesList());
            gathering = false;
        }
    }

    public static void getCollisionBoxes(Entity entity, AxisAlignedBB aabb, EntityCollisionPredicate entityPredicate, BlockCollisionPredicate blockPredicate, List<AxisAlignedBB> collisionBoxes) {
        CustomEntityBlockCollisionsHandler.getBlockCollisionBoxes(entity, aabb, blockPredicate, collisionBoxes);
        CustomEntityBlockCollisionsHandler.getEntityCollisionBoxes(entity, aabb, entityPredicate, collisionBoxes);
        MinecraftForge.EVENT_BUS.post((Event)new GetCollisionBoxesEvent(entity.field_70170_p, entity, aabb, collisionBoxes));
    }

    private static void getEntityCollisionBoxes(Entity entity, AxisAlignedBB aabb, EntityCollisionPredicate entityPredicate, List<AxisAlignedBB> collisionBoxes) {
        if (entity != null) {
            List otherEntities = entity.field_70170_p.func_72839_b(entity, aabb.func_186662_g(0.25));
            for (Entity otherEntity : otherEntities) {
                if (entity.func_184223_x(otherEntity)) continue;
                AxisAlignedBB otherAABB = otherEntity.func_70046_E();
                if (otherAABB != null && otherAABB.func_72326_a(aabb) && entityPredicate.isColliding(entity, aabb, otherEntity, otherAABB)) {
                    collisionBoxes.add(otherAABB);
                }
                if ((otherAABB = entity.func_70114_g(otherEntity)) == null || !otherAABB.func_72326_a(aabb) || !entityPredicate.isColliding(entity, aabb, otherEntity, otherAABB)) continue;
                collisionBoxes.add(otherAABB);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBlockCollisionBoxes(Entity entity, AxisAlignedBB aabb, BlockCollisionPredicate blockPredicate, List<AxisAlignedBB> collisionBoxes) {
        World world = entity.field_70170_p;
        int xs = MathHelper.func_76128_c((double)aabb.field_72340_a) - 1;
        int xe = MathHelper.func_76143_f((double)aabb.field_72336_d) + 1;
        int ys = MathHelper.func_76128_c((double)aabb.field_72338_b) - 1;
        int ye = MathHelper.func_76143_f((double)aabb.field_72337_e) + 1;
        int zs = MathHelper.func_76128_c((double)aabb.field_72339_c) - 1;
        int ze = MathHelper.func_76143_f((double)aabb.field_72334_f) + 1;
        WorldBorder worldBorder = world.func_175723_af();
        boolean isOutsideWorldBorder = entity.func_174832_aS();
        boolean isInsideWorldBorder = world.func_191503_g(entity);
        IBlockState defaultBlockState = Blocks.field_150348_b.func_176223_P();
        BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int x = xs; x < xe; ++x) {
                for (int z = zs; z < ze; ++z) {
                    boolean borderZ;
                    boolean borderX = x == xs || x == xe - 1;
                    boolean bl = borderZ = z == zs || z == ze - 1;
                    if (borderX && borderZ || !world.func_175667_e((BlockPos)checkPos.func_181079_c(x, 64, z))) continue;
                    for (int y = ys; y < ye; ++y) {
                        if ((borderX || borderZ) && y == ye - 1) continue;
                        if (entity != null && isOutsideWorldBorder == isInsideWorldBorder) {
                            entity.func_174821_h(!isInsideWorldBorder);
                        }
                        checkPos.func_181079_c(x, y, z);
                        IBlockState state = !worldBorder.func_177746_a((BlockPos)checkPos) && isInsideWorldBorder ? defaultBlockState : world.func_180495_p((BlockPos)checkPos);
                        if (!blockPredicate.isColliding(entity, aabb, (BlockPos.MutableBlockPos)checkPos, state)) continue;
                        state.func_185908_a(world, (BlockPos)checkPos, aabb, collisionBoxes, entity, false);
                    }
                }
            }
        }
        finally {
            checkPos.func_185344_t();
        }
    }

    @FunctionalInterface
    public static interface BlockCollisionPredicate {
        public static final EntityCollisionPredicate ALL = (entity, aabb, pos, state) -> true;
        public static final EntityCollisionPredicate NONE = (entity, aabb, pos, state) -> false;

        public boolean isColliding(Entity var1, AxisAlignedBB var2, BlockPos.MutableBlockPos var3, IBlockState var4);
    }

    @FunctionalInterface
    public static interface EntityCollisionPredicate {
        public static final EntityCollisionPredicate ALL = (entity, aabb, otherEntity, otherAabb) -> true;
        public static final EntityCollisionPredicate NONE = (entity, aabb, otherEntity, otherAabb) -> false;

        public boolean isColliding(Entity var1, AxisAlignedBB var2, Entity var3, AxisAlignedBB var4);
    }
}

