/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.BossInfoClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.entity.BossType;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.common.TheBetweenlands;

public class BossHandler<T extends Entity> {
    private static final ResourceLocation BOSS_BAR_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/boss_health_bar.png");
    private static final ResourceLocation MINIBOSS_BAR_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/miniboss_health_bar.png");
    private static final Listener LISTENER = new Listener();
    public static final Set<IBLBoss> BOSS_ENTITIES = new HashSet<IBLBoss>();

    private BossHandler() {
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)LISTENER);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        event.getWorld().func_72848_b((IWorldEventListener)LISTENER);
        Iterator<IBLBoss> it = BOSS_ENTITIES.iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            if (entity.func_130014_f_() != event.getWorld()) continue;
            it.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onBossBarRender(RenderGameOverlayEvent.BossInfo event) {
        Minecraft mc = Minecraft.func_71410_x();
        IBLBoss boss = null;
        for (IBLBoss candidate : BOSS_ENTITIES) {
            if (!event.getBossInfo().func_186737_d().equals(candidate.getBossInfoUuid())) continue;
            boss = candidate;
            break;
        }
        if (boss != null) {
            event.setCanceled(true);
            if (boss.getBossType() == BossType.NORMAL_BOSS) {
                BossInfoClient info = event.getBossInfo();
                float percent = info.func_186738_f();
                ITextComponent name = info.func_186744_e();
                int texWidth = 256;
                int texHeight = 16;
                event.setIncrement(texHeight + 2);
                double renderWidth = 250.0;
                double renderHeight = (double)texHeight / (double)texWidth * renderWidth;
                double renderHealth = renderWidth - (double)(16.0f / (float)texWidth) * renderWidth - (renderWidth - (double)(16.0f / (float)texWidth) * renderWidth) * (double)percent;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                mc.func_110434_K().func_110577_a(BOSS_BAR_TEXTURE);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)(event.getResolution().func_78326_a() / 2) - renderWidth / 2.0), (double)(event.getY() - 2), (double)0.0);
                GlStateManager.func_187447_r((int)7);
                GlStateManager.func_187426_b((float)0.0f, (float)0.0f);
                GL11.glVertex2d((double)0.0, (double)0.0);
                GlStateManager.func_187426_b((float)0.0f, (float)0.5f);
                GL11.glVertex2d((double)0.0, (double)renderHeight);
                GlStateManager.func_187426_b((float)1.0f, (float)0.5f);
                GL11.glVertex2d((double)renderWidth, (double)renderHeight);
                GlStateManager.func_187426_b((float)1.0f, (float)0.0f);
                GL11.glVertex2d((double)renderWidth, (double)0.0);
                if (percent > 0.0f) {
                    GlStateManager.func_187426_b((float)0.0f, (float)0.5f);
                    GL11.glVertex2d((double)0.0, (double)0.0);
                    GlStateManager.func_187426_b((float)0.0f, (float)1.0f);
                    GL11.glVertex2d((double)0.0, (double)renderHeight);
                    GlStateManager.func_187426_b((float)(16.0f / (float)texWidth + (1.0f - 16.0f / (float)texWidth) * percent), (float)1.0f);
                    GL11.glVertex2d((double)(renderWidth - renderHealth), (double)renderHeight);
                    GlStateManager.func_187426_b((float)(16.0f / (float)texWidth + (1.0f - 16.0f / (float)texWidth) * percent), (float)0.5f);
                    GL11.glVertex2d((double)(renderWidth - renderHealth), (double)0.0);
                }
                GlStateManager.func_187437_J();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int strWidth = TheBetweenlands.proxy.getCustomFontRenderer().func_78256_a(name.func_150254_d());
                TheBetweenlands.proxy.getCustomFontRenderer().func_78276_b(name.func_150254_d(), event.getResolution().func_78326_a() / 2 - strWidth / 2, event.getY() + 1, -1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Specials.Post<EntityLivingBase> event) {
        BossInfo info;
        IBLBoss boss;
        EntityLivingBase entity = event.getEntity();
        if (entity instanceof IBLBoss && (boss = (IBLBoss)entity).getBossType() == BossType.MINI_BOSS && (info = (BossInfo)Minecraft.func_71410_x().field_71456_v.func_184046_j().field_184060_g.get(boss.getBossInfoUuid())) != null) {
            double width;
            RenderManager renderManager = event.getRenderer().func_177068_d();
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            Framebuffer fbo = Minecraft.func_71410_x().func_147110_a();
            Tessellator tessellator = Tessellator.func_178181_a();
            float viewerYaw = renderManager.field_78735_i;
            float viewerPitch = renderManager.field_78732_j;
            boolean isThirdPersonFrontal = renderManager.field_78733_k.field_74320_O == 2;
            Vec3d offset = boss.getMiniBossTagOffset(event.getPartialRenderTick());
            double x = event.getX() + offset.field_72450_a;
            double y = event.getY() + offset.field_72448_b;
            double z = event.getZ() + offset.field_72449_c;
            double emptyPercentage = 1.0 - (double)info.func_186738_f();
            textureManager.func_110577_a(MINIBOSS_BAR_TEXTURE);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(isThirdPersonFrontal ? -1 : 1) * viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179098_w();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179132_a((boolean)false);
            boolean useStencil = false;
            int stencilBit = MinecraftForgeClient.reserveStencilBit();
            int stencilMask = 1 << stencilBit;
            if (stencilBit >= 0) {
                useStencil = fbo.isStencilEnabled() ? true : fbo.enableStencil();
            }
            double height = width = (double)boss.getMiniBossTagSize(event.getPartialRenderTick());
            if (useStencil) {
                GL11.glEnable((int)2960);
                GL11.glStencilMask((int)stencilMask);
                GL11.glClearStencil((int)0);
                GL11.glClear((int)1024);
                GL11.glStencilMask((int)-1);
                GL11.glStencilFunc((int)519, (int)stencilMask, (int)stencilMask);
                GL11.glStencilOp((int)7681, (int)7681, (int)7681);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.5f);
                BossHandler.renderTagQuad(tessellator, -width, -height - (height - 0.2) * emptyPercentage, width, height - height * emptyPercentage, 0.0, 0.5, 0.5, 1.0);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GL11.glStencilFunc((int)514, (int)stencilMask, (int)stencilMask);
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
            }
            BossHandler.renderTag(tessellator, fbo, textureManager, width, height, emptyPercentage, useStencil);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            BossHandler.renderTag(tessellator, fbo, textureManager, width, height, emptyPercentage, useStencil);
            if (stencilBit >= 0) {
                MinecraftForgeClient.releaseStencilBit((int)stencilBit);
            }
            if (useStencil) {
                GL11.glDisable((int)2960);
            }
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTag(Tessellator tessellator, Framebuffer fbo, TextureManager textureManager, double width, double height, double emptyPercentage, boolean useStencil) {
        GL11.glDisable((int)2960);
        BossHandler.renderTagQuad(tessellator, -width, -height, width, height, 0.0, 0.0, 0.5, 0.5);
        if (useStencil) {
            GL11.glEnable((int)2960);
        }
        BossHandler.renderTagQuad(tessellator, -width, -height, width, height, 0.5, 0.0, 1.0, 0.5);
        if (useStencil) {
            GL11.glDisable((int)2960);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTagQuad(Tessellator tessellator, double minX, double minY, double maxX, double maxY, double minU, double minV, double maxU, double maxV) {
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(minX, minY, 0.0).func_187315_a(minU, maxV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(minX, maxY, 0.0).func_187315_a(minU, minV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(maxX, maxY, 0.0).func_187315_a(maxU, minV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, 0.0).func_187315_a(maxU, maxV).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    private static class Listener
    implements IWorldEventListener {
        private Listener() {
        }

        public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }

        public void func_72703_a(Entity entityIn) {
            if (entityIn instanceof IBLBoss) {
                BOSS_ENTITIES.add((IBLBoss)entityIn);
            }
        }

        public void func_72709_b(Entity entityIn) {
            if (entityIn instanceof IBLBoss) {
                BOSS_ENTITIES.remove((IBLBoss)entityIn);
            }
        }
    }
}

