/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFace;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceSmall;

public class EntityTamedSpiritTreeFace
extends EntitySpiritTreeFaceSmall {
    public EntityTamedSpiritTreeFace(World world) {
        super(world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, false, false, e -> IMob.field_175450_e.apply(e) && !(e instanceof EntityTamedSpiritTreeFace)));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntitySpiritTreeFace.AITrackTarget(this, true, 16.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntitySpiritTreeFace.AIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntitySpiritTreeFace.AISpit(this, 5.0f, 30, 70){

            @Override
            protected float getSpitDamage() {
                return (float)EntityTamedSpiritTreeFace.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIWander(this, 8.0, 0.33, 200));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f){

            public void func_75246_d() {
                EntityTamedSpiritTreeFace.this.getLookHelper().setSpeed(0.33);
                super.func_75246_d();
            }
        });
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this){

            public void func_75246_d() {
                EntityTamedSpiritTreeFace.this.getLookHelper().setSpeed(0.33);
                super.func_75246_d();
            }
        });
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void fixUnsuitablePosition(int violatedChecks) {
        if (this.isAnchored() && (violatedChecks & 3) != 0) {
            this.setAnchored(false);
        }
        super.fixUnsuitablePosition(violatedChecks);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityPlayer) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public static class AIWander
    extends EntityAIBase {
        protected final EntitySpiritTreeFace entity;
        protected int findWoodCooldown = 0;
        protected List<BlockPos> woodBlocks;
        protected int checkCooldown = 0;
        protected double speed;
        protected int chance;
        protected double range;
        protected double rangeSq;
        protected boolean wandered = false;

        public AIWander(EntitySpiritTreeFace entity, double range, double speed) {
            this(entity, range, speed, 120);
        }

        public AIWander(EntitySpiritTreeFace entity, double range, double speed, int chance) {
            this.entity = entity;
            this.range = range;
            this.rangeSq = range * range;
            this.speed = speed;
            this.chance = chance;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return this.entity.isActive() && !this.entity.isAttacking() && !this.entity.isMoving() && this.entity.func_70654_ax() < 100 && this.entity.func_70681_au().nextInt(this.chance) == 0;
        }

        public void func_75249_e() {
            this.checkCooldown = 0;
            this.findWoodCooldown = 20 + this.entity.func_70681_au().nextInt(30);
            this.woodBlocks = null;
            this.wandered = false;
        }

        public void func_75246_d() {
            if (this.findWoodCooldown <= 0 && (this.woodBlocks == null || this.woodBlocks.isEmpty())) {
                this.findWoodCooldown = 40 + this.entity.func_70681_au().nextInt(60);
                this.woodBlocks = this.entity.findNearbyWoodBlocks();
            }
            if (this.woodBlocks != null && !this.woodBlocks.isEmpty() && this.checkCooldown <= 0) {
                this.checkCooldown = 5 + this.entity.func_70681_au().nextInt(15);
                for (int i = 0; i < 16 && !this.woodBlocks.isEmpty(); ++i) {
                    double dz;
                    double dy;
                    double dx;
                    Vec3d center;
                    BlockPos pos = this.woodBlocks.remove(this.entity.func_70681_au().nextInt(this.woodBlocks.size()));
                    if (!(this.entity.func_174831_c(pos) <= this.rangeSq) || !this.entity.func_180485_d(pos) || this.entity.checkAnchorAt(center = new Vec3d((double)pos.func_177958_n() + (double)this.entity.getBlockWidth() / 2.0, (double)pos.func_177956_o() + (double)this.entity.getBlockHeight() / 2.0, (double)pos.func_177952_p() + (double)this.entity.getBlockWidth() / 2.0), new Vec3d(dx = this.entity.func_70681_au().nextDouble() - 0.5, dy = this.entity.func_70681_au().nextDouble() - 0.5, dz = this.entity.func_70681_au().nextDouble() - 0.5), 7) != 0) continue;
                    this.entity.getMoveHelper().func_75642_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, this.speed);
                    this.entity.getLookHelper().setLookDirection(dx, dy, dz);
                    this.wandered = true;
                    return;
                }
            }
            --this.checkCooldown;
            --this.findWoodCooldown;
        }

        public boolean func_75253_b() {
            return !this.wandered && this.entity.isActive() && !this.entity.isMoving() && !this.entity.isAttacking();
        }
    }
}

