/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFace;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;

public class EntitySpiritTreeFaceSmall
extends EntitySpiritTreeFace
implements IEntityAdditionalSpawnData {
    private int variant;

    public EntitySpiritTreeFaceSmall(World world) {
        super(world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved(this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntitySpiritTreeFace.AITrackTarget(this, true, 28.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntitySpiritTreeFace.AIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntitySpiritTreeFace.AISpit(this, 3.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setVariant(this.field_70146_Z.nextInt(2));
        return super.func_180482_a(difficulty, livingdata);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SPIRIT_TREE_FACE_SMALL;
    }

    @Override
    public List<BlockPos> findNearbyWoodBlocks() {
        List<LocationSpiritTree> locations = BetweenlandsWorldStorage.forWorld(this.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, this.func_174813_aQ(), loc -> loc.isInside((Entity)this));
        if (!locations.isEmpty()) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            positions.addAll(locations.get(0).getSmallFacePositions());
            if (!positions.isEmpty()) {
                return positions;
            }
        }
        return super.findNearbyWoodBlocks();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAnchored()) {
            this.func_70105_a(0.9f, 0.9f);
        } else {
            this.func_70105_a(0.9f, 0.2f);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("variant", this.getVariant());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setVariant(nbt.func_74762_e("variant"));
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.variant);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.variant = additionalData.readInt();
    }

    @Override
    protected void playSpitSound() {
        this.func_184185_a(SoundRegistry.SPIRIT_TREE_FACE_SMALL_SPIT, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
    }

    @Override
    protected void playEmergeSound() {
        this.func_184185_a(SoundRegistry.SPIRIT_TREE_FACE_SMALL_EMERGE, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SPIRIT_TREE_FACE_SMALL_LIVING;
    }

    public void func_70642_aH() {
        SoundEvent sound = this.func_184639_G();
        if (sound != null) {
            this.func_184185_a(sound, this.func_70599_aP() * 0.5f, this.func_70647_i() * 1.3f);
        }
    }
}

