/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.model.ControlledAnimation;
import thebetweenlands.common.entity.attributes.BooleanAttribute;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;

public class EntitySludge
extends EntityLiving
implements IMob,
IEntityBL {
    public static final DataParameter<Boolean> IS_ACTIVE = EntityDataManager.func_187226_a(EntitySludge.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final IAttribute SLUDGE_TRAIL = new BooleanAttribute(null, "bl.sludgeTrail", false).func_111117_a("Whether this Sludge should leave a Sludge trail");
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private float squishAmount;
    private float squishFactor;
    private float prevSquishFactor;
    private boolean wasOnGround;
    public ControlledAnimation scale = new ControlledAnimation(5);

    public EntitySludge(World worldIn) {
        super(worldIn);
        this.field_70765_h = new SludgeMoveHelper(this);
        this.field_70178_ae = true;
        this.func_70105_a(1.1f, 1.2f);
        this.field_70728_aV = 4;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISludgeFloat(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISludgeAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISludgeFaceRandom(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISludgeHop(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_ACTIVE, (Object)true);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setActive(this.field_70170_p.field_73012_v.nextInt(5) == 0 || !this.canHideIn(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b())));
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SLUDGE_TRAIL).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("wasOnGround")) {
            this.wasOnGround = compound.func_74767_n("wasOnGround");
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        if (!this.field_70170_p.field_72995_K) {
            if ((this.getIsPlayerNearby(7.0, 3.0, 7.0, 7.0) || this.func_70638_az() != null || this.field_70170_p.field_73012_v.nextInt(2200) == 0) && !this.isActive()) {
                this.setActive(true);
                this.field_70181_x += 0.6;
            }
            if (this.isActive()) {
                BlockPos position;
                if (this.func_110148_a(SLUDGE_TRAIL).func_111126_e() == 1.0 && this.field_70170_p.func_175623_d(position = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                    this.createTrail(position);
                }
                if (this.func_70638_az() == null && this.field_70122_E && this.field_70170_p.field_73012_v.nextInt(350) == 0 && !this.func_70090_H() && this.canHideIn(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()))) {
                    this.setActive(false);
                }
            } else if (this.func_70090_H() || !this.field_70122_E) {
                this.setActive(true);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x -= 0.1;
                this.field_70179_y = 0.0;
            }
        }
        super.func_70071_h_();
        if (this.isActive()) {
            this.setNormalSize();
        } else {
            this.setSmallSize();
        }
        if (this.field_70122_E && !this.wasOnGround) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            this.scale.updateTimer();
            if (this.isActive()) {
                this.scale.increaseTimer();
            } else {
                this.scale.decreaseTimer();
            }
        }
    }

    protected boolean canHideIn(IBlockState state) {
        Material ground = state.func_185904_a();
        return ground == Material.field_151578_c || ground == Material.field_151595_p || ground == Material.field_151577_b;
    }

    protected void createTrail(BlockPos pos) {
        if (BlockRegistry.SLUDGE.func_176196_c(this.field_70170_p, pos)) {
            BlockRegistry.SLUDGE.generateBlockTemporary(this.field_70170_p, pos);
        }
    }

    protected void setSmallSize() {
        this.func_70105_a(0.5f, 0.6f);
    }

    protected void setNormalSize() {
        this.func_70105_a(1.1f, 1.2f);
    }

    public float getSquishFactor(float partialTicks) {
        return this.prevSquishFactor + (this.squishFactor - this.prevSquishFactor) * partialTicks;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.8f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || !this.isActive();
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        this.dealDamage((EntityLivingBase)entityIn);
    }

    protected void dealDamage(EntityLivingBase entityIn) {
        if (this.isActive() && this.func_70685_l((Entity)entityIn) && this.func_70068_e((Entity)entityIn) < 2.5 && entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return true;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.42;
        this.field_70160_al = true;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SLUDGE;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187882_fq;
    }

    public void setActive(boolean active) {
        this.func_184212_Q().func_187227_b(IS_ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ACTIVE);
    }

    protected boolean getIsPlayerNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        for (Entity entityNeighbor : entities) {
            if (!(entityNeighbor instanceof EntityPlayer) || !((double)this.func_70032_d(entityNeighbor) <= radius) || ((EntityPlayer)entityNeighbor).field_71075_bZ.field_75098_d || ((EntityPlayer)entityNeighbor).func_175149_v() || !this.func_70635_at().func_75522_a(entityNeighbor)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || this.isActive() ? this.func_174813_aQ() : ZERO_AABB;
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
        if (this.isActive()) {
            super.func_70653_a(entityIn, strenght, xRatio, zRatio);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isActive() && !source.func_180136_u()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setActive(true);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    static class SludgeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntitySludge sludge;
        private boolean isAggressive;

        public SludgeMoveHelper(EntitySludge slimeIn) {
            super((EntityLiving)slimeIn);
            this.sludge = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yaw, boolean aggressive) {
            this.yRot = yaw;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            if (!this.sludge.isActive()) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                return;
            }
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.sludge.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.sludge.func_70683_ar().func_75660_a();
                        if (this.sludge.makesSoundOnJump()) {
                            this.sludge.func_184185_a(this.sludge.getJumpSound(), this.sludge.func_70599_aP(), ((this.sludge.func_70681_au().nextFloat() - this.sludge.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.sludge.field_70702_br = 0.0f;
                        this.sludge.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISludgeHop
    extends EntityAIBase {
        private final EntitySludge slime;

        public AISludgeHop(EntitySludge slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SludgeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISludgeFloat
    extends EntityAIBase {
        private final EntitySludge sludge;

        public AISludgeFloat(EntitySludge slimeIn) {
            this.sludge = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.sludge.func_70090_H() || this.sludge.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.sludge.func_70681_au().nextFloat() < 0.8f) {
                this.sludge.func_70683_ar().func_75660_a();
                this.sludge.field_70181_x += 0.01;
            }
            ((SludgeMoveHelper)this.sludge.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISludgeFaceRandom
    extends EntityAIBase {
        private final EntitySludge sludge;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISludgeFaceRandom(EntitySludge slimeIn) {
            this.sludge = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.sludge.func_70638_az() == null && (this.sludge.field_70122_E || this.sludge.func_70090_H() || this.sludge.func_180799_ab() || this.sludge.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.sludge.func_70681_au().nextInt(60);
                this.chosenDegrees = this.sludge.func_70681_au().nextInt(360);
            }
            ((SludgeMoveHelper)this.sludge.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISludgeAttack
    extends EntityAIBase {
        private final EntitySludge sludge;
        private int growTieredTimer;

        public AISludgeAttack(EntitySludge slimeIn) {
            this.sludge = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.sludge.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.sludge.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a ? false : --this.growTieredTimer > 0));
        }

        public void func_75246_d() {
            EntityLivingBase target = this.sludge.func_70638_az();
            if (target != null) {
                this.sludge.func_70625_a((Entity)target, 10.0f, 10.0f);
                ((SludgeMoveHelper)this.sludge.func_70605_aq()).setDirection(this.sludge.field_70177_z, true);
            }
        }
    }
}

