/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.equipment;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EquipmentHelper {
    public static ItemStack getEquipment(EnumEquipmentInventory inventory, Entity entity, Item item) {
        IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            IInventory mainInv = cap.getInventory(inventory);
            for (int i = 0; i < mainInv.func_70302_i_(); ++i) {
                ItemStack stack = mainInv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack equipItem(@Nullable EntityPlayer player, Entity target, ItemStack stack, boolean simulate) {
        IEquippable equippable;
        IEquipmentCapability cap;
        if (stack.func_77973_b() instanceof IEquippable && (cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) != null && (equippable = (IEquippable)stack.func_77973_b()).canEquip(stack, player, target)) {
            EnumEquipmentInventory type = equippable.getEquipmentCategory(stack);
            stack = stack.func_77946_l();
            if (target instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.EQUIP.trigger((EntityPlayerMP)target, stack);
            }
            IInventory inv = cap.getInventory(type);
            InvWrapper wrapper = new InvWrapper(inv);
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (boolean)true);
            if (simulate) {
                return result;
            }
            if (result.func_190926_b() || result.func_190916_E() != stack.func_190916_E()) {
                equippable.onEquip(stack, target, inv);
                return ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (boolean)false);
            }
        }
        return stack;
    }

    public static ItemStack equipItem(@Nullable EntityPlayer player, Entity target, ItemStack stack, int slot, boolean simulate) {
        EnumEquipmentInventory type;
        IInventory inv;
        IEquippable equippable;
        IEquipmentCapability cap;
        if (slot >= 0 && stack.func_77973_b() instanceof IEquippable && (cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) != null && (equippable = (IEquippable)stack.func_77973_b()).canEquip(stack, player, target) && slot < (inv = cap.getInventory(type = equippable.getEquipmentCategory(stack))).func_70302_i_()) {
            InvWrapper wrapper = new InvWrapper(inv);
            stack = stack.func_77946_l();
            if (target instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.EQUIP.trigger((EntityPlayerMP)target, stack);
            }
            ItemStack result = wrapper.insertItem(slot, stack, simulate);
            if (simulate) {
                return result;
            }
            if (result.func_190926_b() || result.func_190916_E() != stack.func_190916_E()) {
                equippable.onEquip(stack, target, inv);
                return ItemHandlerHelper.insertItem((IItemHandler)wrapper, (ItemStack)stack, (boolean)false);
            }
        }
        return stack;
    }

    public static ItemStack unequipItem(@Nullable EntityPlayer player, Entity target, boolean simulate) {
        IEquipmentCapability cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            for (EnumEquipmentInventory type : EnumEquipmentInventory.VALUES) {
                IInventory inv = cap.getInventory(type);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof IEquippable && !((IEquippable)stack.func_77973_b()).canUnequip(stack, player, target, cap.getInventory(((IEquippable)stack.func_77973_b()).getEquipmentCategory(stack)))) continue;
                    if (simulate) {
                        return stack;
                    }
                    if (stack.func_190926_b()) continue;
                    if (stack.func_77973_b() instanceof IEquippable) {
                        ((IEquippable)stack.func_77973_b()).onUnequip(stack, target, inv);
                    }
                    inv.func_70299_a(i, ItemStack.field_190927_a);
                    return stack;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack unequipItem(@Nullable EntityPlayer player, Entity target, EnumEquipmentInventory type, int slot, boolean simulate) {
        IEquipmentCapability cap = (IEquipmentCapability)target.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            IInventory inv = cap.getInventory(type);
            if (slot >= 0 && slot < inv.func_70302_i_()) {
                ItemStack stack = inv.func_70301_a(slot);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof IEquippable && !((IEquippable)stack.func_77973_b()).canUnequip(stack, player, target, cap.getInventory(((IEquippable)stack.func_77973_b()).getEquipmentCategory(stack)))) {
                    return stack;
                }
                if (simulate) {
                    return stack;
                }
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof IEquippable) {
                    ((IEquippable)stack.func_77973_b()).onUnequip(stack, target, inv);
                }
                inv.func_70299_a(slot, ItemStack.field_190927_a);
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean tryPlayerUnequip(EntityPlayer player, Entity target) {
        ItemStack unequipped = EquipmentHelper.unequipItem(player, target, false);
        if (!unequipped.func_190926_b()) {
            if (!player.field_71071_by.func_70441_a(unequipped)) {
                target.func_70099_a(unequipped, target.func_70047_e());
            }
            return true;
        }
        return false;
    }
}

