/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.audio.GemSingerEchoSound;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;

public class ParticleSoundRipple
extends Particle {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/particle/sound_ripple.png");
    private boolean spawnMore;
    private int delay;

    public ParticleSoundRipple(World world, double x, double y, double z, float scale, int delay) {
        this(world, x, y, z, scale, delay, true);
    }

    protected ParticleSoundRipple(World world, double x, double y, double z, float scale, int delay, boolean spawnMore) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187126_f = this.field_187123_c = x;
        this.field_187127_g = this.field_187124_d = y;
        this.field_187128_h = this.field_187125_e = z;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_190017_n = false;
        this.field_70544_f = scale;
        this.func_82338_g(0.0f);
        this.spawnMore = spawnMore;
        this.delay = delay;
        this.field_70547_e = this.spawnMore ? 100 + this.delay : 20;
    }

    public void func_180434_a(BufferBuilder vertexBuffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.spawnMore) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            float umin = 0.0f;
            float umax = 1.0f;
            float vmin = 0.0f;
            float vmax = 1.0f;
            float scale = this.field_70544_f * (((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e);
            Vec3d camPos = ActiveRenderInfo.getCameraPosition();
            float ipx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - (field_70556_an + camPos.field_72450_a));
            float ipy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - (field_70554_ao + camPos.field_72448_b));
            float ipz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - (field_70555_ap + camPos.field_72449_c));
            float len = (float)Math.sqrt(ipx * ipx + ipy * ipy + ipz * ipz);
            if (len > 0.0f) {
                ipx /= len;
                ipy /= len;
                ipz /= len;
            }
            ipx = (float)((double)ipx + camPos.field_72450_a);
            ipy = (float)((double)ipy + camPos.field_72448_b);
            ipz = (float)((double)ipz + camPos.field_72449_c);
            Vec3d[] rotation = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
            if (this.field_190014_F != 0.0f) {
                float interpolatedRoll = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
                float cos = MathHelper.func_76134_b((float)(interpolatedRoll * 0.5f));
                float lookX = MathHelper.func_76126_a((float)(interpolatedRoll * 0.5f)) * (float)ParticleSoundRipple.field_190016_K.field_72450_a;
                float lookY = MathHelper.func_76126_a((float)(interpolatedRoll * 0.5f)) * (float)ParticleSoundRipple.field_190016_K.field_72448_b;
                float lookZ = MathHelper.func_76126_a((float)(interpolatedRoll * 0.5f)) * (float)ParticleSoundRipple.field_190016_K.field_72449_c;
                Vec3d look = new Vec3d((double)lookX, (double)lookY, (double)lookZ);
                for (int l = 0; l < 4; ++l) {
                    rotation[l] = look.func_186678_a(2.0 * rotation[l].func_72430_b(look)).func_178787_e(rotation[l].func_186678_a((double)(cos * cos) - look.func_72430_b(look))).func_178787_e(look.func_72431_c(rotation[l]).func_186678_a((double)(2.0f * cos)));
                }
            }
            float alpha = MathHelper.func_76131_a((float)(((float)this.field_70547_e - ((float)this.field_70546_d + partialTicks)) / 10.0f), (float)0.0f, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            vertexBuffer.func_181662_b((double)ipx + rotation[0].field_72450_a, (double)ipy + rotation[0].field_72448_b, (double)ipz + rotation[0].field_72449_c).func_187315_a((double)umax, (double)vmax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(240, 240).func_181675_d();
            vertexBuffer.func_181662_b((double)ipx + rotation[1].field_72450_a, (double)ipy + rotation[1].field_72448_b, (double)ipz + rotation[1].field_72449_c).func_187315_a((double)umax, (double)vmin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(240, 240).func_181675_d();
            vertexBuffer.func_181662_b((double)ipx + rotation[2].field_72450_a, (double)ipy + rotation[2].field_72448_b, (double)ipz + rotation[2].field_72449_c).func_187315_a((double)umin, (double)vmin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(240, 240).func_181675_d();
            vertexBuffer.func_181662_b((double)ipx + rotation[3].field_72450_a, (double)ipy + rotation[3].field_72448_b, (double)ipz + rotation[3].field_72449_c).func_187315_a((double)umin, (double)vmax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(240, 240).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    public void func_189213_a() {
        if (this.spawnMore && this.field_70546_d >= this.delay) {
            if (this.field_70546_d == this.delay && Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new GemSingerEchoSound(new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h)).setVolumeAndPitch(0.7f, 0.98f + this.field_187122_b.field_73012_v.nextFloat() * 0.06f - 0.03f));
            }
            if ((this.field_70546_d - this.delay) % 10 == 0) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.UNBATCHED, new ParticleSoundRipple(this.field_187122_b, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_70544_f, 0, false));
            }
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public int func_70537_b() {
        return 3;
    }

    public boolean func_187111_c() {
        return true;
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleSoundRipple> {
        public Factory() {
            super(ParticleSoundRipple.class);
        }

        @Override
        public ParticleSoundRipple createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleSoundRipple(args.world, args.x, args.y, args.z, args.scale, args.data.getInt(0));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withScale(0.125f)).withData(20);
        }
    }
}

