/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class ParticleLifeEssence
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private static final int MAX_PARTICLES = 9;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private double radius;
    private final EntityLivingBase entity;
    private TextureAtlasSprite glowSprite;
    private TextureAnimation[] animations;
    private int rotationTicks;
    private int particles = 9;

    public ParticleLifeEssence(World world, EntityLivingBase entity, double offsetX, double offsetY, double offsetZ, double radius, int rotationTicks) {
        super(world, entity.field_70165_t + offsetX, entity.field_70163_u + offsetY, entity.field_70161_v + offsetZ);
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.radius = radius;
        this.entity = entity;
        this.particles = MathHelper.func_76125_a((int)MathHelper.func_76123_f((float)(entity.func_110143_aJ() / entity.func_110138_aP() * 9.0f)), (int)0, (int)9);
        this.rotationTicks = rotationTicks;
        this.field_70547_e = 60;
        this.field_190017_n = false;
        this.animations = new TextureAnimation[9];
        for (int i = 0; i < 9; ++i) {
            this.animations[i] = new TextureAnimation().setRandomStart(entity.func_70681_au());
        }
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        for (int i = 0; i < 9; ++i) {
            this.animations[i].setFrames(frames[0]);
        }
        this.glowSprite = frames[1][0].getSprite();
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.particles = MathHelper.func_76125_a((int)MathHelper.func_76123_f((float)(this.entity.func_110143_aJ() / this.entity.func_110138_aP() * 9.0f)), (int)0, (int)9);
        ++this.rotationTicks;
        for (int i = 0; i < this.particles; ++i) {
            this.animations[i].update();
        }
        this.func_187109_b(this.entity.field_70165_t + this.offsetX, this.entity.field_70163_u + this.offsetY, this.entity.field_70161_v + this.offsetZ);
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.field_82339_as = this.field_70546_d > this.field_70547_e - 10 ? (float)(this.field_70547_e - this.field_70546_d) / 10.0f : (this.field_70546_d < 10 ? (float)this.field_70546_d / 10.0f : 1.0f);
        double px = this.field_187126_f;
        double py = this.field_187127_g;
        double pz = this.field_187128_h;
        double ppx = this.field_187123_c;
        double ppy = this.field_187124_d;
        double ppz = this.field_187125_e;
        float interval = (float)Math.PI * 2 / (float)this.particles;
        float prevAngle = (float)(this.rotationTicks - 1) / 120.0f * (float)Math.PI * 2.0f;
        float angle = (float)this.rotationTicks / 120.0f * (float)Math.PI * 2.0f;
        float scale = (float)this.radius * 2.0f * (0.25f + (float)this.particles / 9.0f * 0.75f);
        for (int i = 0; i < this.particles; ++i) {
            double prevXo = Math.cos(prevAngle + interval * (float)i) * this.radius;
            double prevYo = Math.cos(prevAngle + interval * (float)i * 5.678f) * (double)0.05f;
            double prevZo = Math.sin(prevAngle + interval * (float)i) * this.radius;
            double xo = Math.cos(angle + interval * (float)i) * this.radius;
            double yo = Math.cos(angle + interval * (float)i * 5.678f) * (double)0.05f;
            double zo = Math.sin(angle + interval * (float)i) * this.radius;
            this.field_187123_c = ppx + prevXo;
            this.field_187125_e = ppz + prevZo;
            this.field_187126_f = px + xo;
            this.field_187128_h = pz + zo;
            this.field_187124_d = ppy + prevYo - (double)(scale * 0.025f);
            this.field_187127_g = py + yo - (double)(scale * 0.025f);
            this.field_70552_h = 0.1f;
            this.field_70545_g = 0.1f;
            this.field_70551_j = 1.0f;
            this.field_70544_f = scale * 2.5f;
            this.field_187119_C = this.glowSprite;
            float prevAlpha = this.field_82339_as;
            this.field_82339_as *= 0.05f;
            super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            this.field_82339_as *= 2.0f;
            this.field_70552_h = 1.0f;
            this.field_70545_g = 1.0f;
            this.field_70551_j = 1.0f;
            this.field_70544_f = scale * 1.25f;
            super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            this.field_70551_j = 1.0f;
            this.field_70553_i = 1.0f;
            this.field_70552_h = 1.0f;
            this.field_82339_as = prevAlpha;
            this.field_187124_d = ppy + prevYo;
            this.field_187127_g = py + yo;
            this.field_70544_f = scale;
            this.field_187119_C = this.animations[i].getCurrentSprite();
            super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
        this.field_187126_f = px;
        this.field_187127_g = py;
        this.field_187128_h = pz;
        this.field_187123_c = ppx;
        this.field_187124_d = ppy;
        this.field_187125_e = ppz;
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleLifeEssence> {
        public Factory() {
            super(ParticleLifeEssence.class, ParticleTextureStitcher.create(ParticleLifeEssence.class, new ResourceLocation("thebetweenlands:particle/life_essence"), new ResourceLocation("thebetweenlands:particle/wisp")).setSplitAnimations(true));
        }

        @Override
        public ParticleLifeEssence createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleLifeEssence(args.world, args.data.getObject(EntityLivingBase.class, 0), args.x, args.y, args.z, args.scale, args.data.getInt(1));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withDataBuilder().setData(1, 20).buildData();
        }
    }
}

