/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;

public class ModelCombined
implements IModel {
    private IModel baseModel;
    private IModel additionalModel;

    public ModelCombined() {
    }

    public ModelCombined(IModel baseModel, IModel additionalModel) {
        this.baseModel = baseModel;
        this.additionalModel = additionalModel;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> dependencies = new ArrayList<ResourceLocation>();
        if (this.baseModel != null) {
            dependencies.addAll(this.baseModel.getDependencies());
        }
        if (this.additionalModel != null) {
            dependencies.addAll(this.additionalModel.getDependencies());
        }
        return dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        if (this.baseModel != null) {
            textures.addAll(this.baseModel.getTextures());
        }
        if (this.additionalModel != null) {
            textures.addAll(this.additionalModel.getTextures());
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.baseModel != null && this.additionalModel != null) {
            IBakedModel baseBakedModel = this.baseModel.bake(state, format, bakedTextureGetter);
            IBakedModel additionalBakedModel = this.additionalModel.bake(state, format, bakedTextureGetter);
            return new BakedCombinedModel(baseBakedModel, additionalBakedModel);
        }
        return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return this.baseModel.getDefaultState();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        IModel baseModel = this.baseModel;
        if (customData.containsKey((Object)"model_base") || baseModel == null) {
            ResourceLocation baseModelLocation = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"model_base")), (String)"model_base"));
            baseModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)baseModelLocation, (String)"Could not find base model for combined model");
        }
        if (customData.containsKey((Object)"model_base_data")) {
            baseModel = baseModel.process(LoaderExtension.parseJsonElementList(parser, (String)customData.get((Object)"model_base_data"), "model_base_data"));
        }
        IModel additionalModel = this.additionalModel;
        if (customData.containsKey((Object)"model_additional") || additionalModel == null) {
            ResourceLocation additionalModelLocation = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"model_additional")), (String)"model_additional"));
            additionalModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)additionalModelLocation, (String)"Could not find additional model for combined model");
        }
        if (customData.containsKey((Object)"model_additional_data")) {
            additionalModel = additionalModel.process(LoaderExtension.parseJsonElementList(parser, (String)customData.get((Object)"model_additional_data"), "model_additional_data"));
        }
        return new ModelCombined(baseModel, additionalModel);
    }

    public static class BakedCombinedModel
    implements IBakedModel {
        private final IBakedModel baseBakedModel;
        private final IBakedModel additionalBakedModel;

        public BakedCombinedModel(IBakedModel baseBakedModel, IBakedModel additionalBakedModel) {
            this.baseBakedModel = baseBakedModel;
            this.additionalBakedModel = additionalBakedModel;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(this.baseBakedModel.func_188616_a(state, side, rand));
            quads.addAll(this.additionalBakedModel.func_188616_a(state, side, rand));
            return quads;
        }

        public boolean func_177555_b() {
            return this.baseBakedModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.baseBakedModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.baseBakedModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.baseBakedModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.baseBakedModel.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return this.baseBakedModel.func_188617_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair result = this.baseBakedModel instanceof PerspectiveMapWrapper ? ((PerspectiveMapWrapper)this.baseBakedModel).handlePerspective(cameraTransformType) : PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.func_177552_f().func_181688_b(cameraTransformType), (ItemCameraTransforms.TransformType)cameraTransformType);
            return Pair.of((Object)this, (Object)result.getValue());
        }
    }
}

