/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import nc.config.NCConfig;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.TileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.util.EnergyHelper;
import nc.util.ItemStackHelper;
import nc.util.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileDecayGenerator
extends TileEnergy
implements IInterfaceable {
    Random rand = new Random();
    public int tickCount;
    public final NCRecipes.Type decayGenRecipeType;
    protected ProcessorRecipe[] recipes = new ProcessorRecipe[6];
    public static final double DEFAULT_LIFETIME = 1200.0 / (double)NCConfig.machine_update_rate;
    protected int generatorCount;

    public TileDecayGenerator() {
        super(TileDecayGenerator.maxPower(), ITileEnergy.energyConnectionAll(EnergyConnection.OUT));
        this.decayGenRecipeType = NCRecipes.Type.DECAY_GENERATOR;
    }

    public ProcessorRecipeHandler getRecipeHandler() {
        return this.decayGenRecipeType.getRecipeHandler();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tickGenerator();
            if (this.generatorCount == 0) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    List<ItemStack> input = Arrays.asList(ItemStackHelper.blockStateToStack(this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(side))));
                    if (this.recipes[side.func_176745_a()] != null && this.recipes[side.func_176745_a()].matchingInputs(input, new ArrayList<Tank>())) continue;
                    this.recipes[side.func_176745_a()] = (ProcessorRecipe)this.getRecipeHandler().getRecipeFromInputs(input, new ArrayList<Tank>());
                }
                this.getEnergyStorage().changeEnergyStored(this.getGenerated());
                this.getRadiationSource().setRadiationLevel(this.getRadiation());
            }
            this.pushEnergy();
        }
    }

    public void tickGenerator() {
        ++this.generatorCount;
        this.generatorCount %= NCConfig.machine_update_rate;
    }

    private static int maxPower() {
        int max = 0;
        List recipes = NCRecipes.Type.DECAY_GENERATOR.getRecipeHandler().getRecipes();
        for (ProcessorRecipe recipe : recipes) {
            if (recipe == null) continue;
            max = Math.max(max, recipe.getDecayPower());
        }
        return 20 * max;
    }

    public int getGenerated() {
        int power = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            power += this.decayGen(side);
        }
        return power;
    }

    public double getRadiation() {
        double radiation = 0.0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getDecayRecipe(side) == null) continue;
            radiation += this.getDecayRecipe(side).getDecayRadiation();
        }
        return radiation;
    }

    public int decayGen(EnumFacing side) {
        ProcessorRecipe recipe = this.getDecayRecipe(side);
        if (recipe == null) {
            return 0;
        }
        ItemStack stack = this.getOutput(side);
        if (stack.func_190926_b() || stack == null) {
            return 0;
        }
        Block block = ItemStackHelper.getBlockFromStack(stack);
        if (block == null) {
            return 0;
        }
        int meta = stack.func_77952_i();
        if (this.rand.nextDouble() * this.getRecipeLifetime(side) < 1.0) {
            this.func_145831_w().func_175656_a(this.func_174877_v().func_177972_a(side), block.func_176203_a(meta));
        }
        return this.getRecipePower(side);
    }

    @Override
    public int getEUSourceTier() {
        return EnergyHelper.getEUTier(TileDecayGenerator.maxPower());
    }

    @Override
    public int getEUSinkTier() {
        return 4;
    }

    public ProcessorRecipe getDecayRecipe(EnumFacing side) {
        return this.recipes[side.func_176745_a()];
    }

    public double getRecipeLifetime(EnumFacing side) {
        if (this.getDecayRecipe(side) == null) {
            return DEFAULT_LIFETIME;
        }
        return this.getDecayRecipe(side).getDecayLifetime();
    }

    public int getRecipePower(EnumFacing side) {
        if (this.getDecayRecipe(side) == null) {
            return 0;
        }
        return this.getDecayRecipe(side).getDecayPower();
    }

    public ItemStack getOutput(EnumFacing side) {
        ProcessorRecipe recipe = this.getDecayRecipe(side);
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        List<IItemIngredient> outputs = recipe.itemProducts();
        ItemStack output = RecipeHelper.getItemStackFromIngredientList(outputs, 0);
        if (output != null) {
            return output;
        }
        return ItemStack.field_190927_a;
    }
}

