/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.dummy;

import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.dummy.IDummyMaster;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.inventory.ITileInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileDummy<T extends IDummyMaster>
extends TileEnergyFluidSidedInventory {
    public BlockPos masterPosition = null;
    protected final int updateRate;
    protected int checkCount;
    protected final Class<T> tClass;

    public TileDummy(Class<T> tClass, String name, int updateRate, List<String> allowedFluids) {
        this(tClass, name, ITileEnergy.energyConnectionAll(EnergyConnection.NON), updateRate, allowedFluids, ITileFluid.fluidConnectionAll(TankSorption.NON));
    }

    public TileDummy(Class<T> tClass, String name, EnergyConnection[] energyConnections, int updateRate, List<String> allowedFluids) {
        this(tClass, name, energyConnections, updateRate, allowedFluids, ITileFluid.fluidConnectionAll(TankSorption.NON));
    }

    public TileDummy(Class<T> tClass, String name, int updateRate, List<String> allowedFluids, @Nonnull FluidConnection[] fluidConnections) {
        this(tClass, name, ITileEnergy.energyConnectionAll(EnergyConnection.NON), updateRate, allowedFluids, fluidConnections);
    }

    public TileDummy(Class<T> tClass, String name, EnergyConnection[] energyConnections, int updateRate, List<String> allowedFluids, @Nonnull FluidConnection[] fluidConnections) {
        super(name, 1, 1, energyConnections, 1, allowedFluids, fluidConnections);
        this.updateRate = updateRate;
        this.tClass = tClass;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.findMaster();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.checkCount == 0) {
                this.findMaster();
            }
            this.tickDummy();
        }
    }

    public void tickDummy() {
        ++this.checkCount;
        this.checkCount %= this.updateRate;
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        if (this.hasMaster()) {
            this.getMaster().onDummyNeighborChanged(state, world, pos, fromPos);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryStacks() {
        if (this.getMaster() instanceof ITileInventory) {
            return ((ITileInventory)this.getMaster()).getInventoryStacks();
        }
        return this.inventoryStacks;
    }

    @Override
    public int func_70302_i_() {
        return this.getInventoryStacks().size();
    }

    @Override
    public boolean func_191420_l() {
        if (this.getMaster() instanceof IInventory) {
            ((IInventory)this.getMaster()).func_191420_l();
        }
        for (ItemStack itemstack : this.inventoryStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.getInventoryStacks().get(slot);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.getInventoryStacks(), (int)index, (int)count);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getInventoryStacks(), (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (this.getMaster() instanceof IInventory) {
            ((IInventory)this.getMaster()).func_70299_a(index, stack);
            return;
        }
        ItemStack itemstack = (ItemStack)this.inventoryStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && nc.util.ItemStackHelper.areItemStackTagsEqual(stack, itemstack);
        this.inventoryStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.getMaster() instanceof IInventory) {
            return ((IInventory)this.getMaster()).func_94041_b(slot, stack);
        }
        return false;
    }

    @Override
    public int func_70297_j_() {
        if (this.getMaster() instanceof IInventory) {
            return ((IInventory)this.getMaster()).func_70297_j_();
        }
        return 1;
    }

    @Override
    public void func_174888_l() {
        this.getInventoryStacks().clear();
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (this.getMaster() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getMaster()).func_180463_a(side);
        }
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        if (this.getMaster() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getMaster()).func_180462_a(slot, stack, direction);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        if (this.getMaster() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getMaster()).func_180461_b(slot, stack, direction);
        }
        return false;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyStorage();
        }
        return super.getEnergyStorage();
    }

    @Override
    public EnergyConnection getEnergyConnection(@Nonnull EnumFacing side) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyConnection(side);
        }
        return super.getEnergyConnection(side);
    }

    @Override
    public int getEnergyStored() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEnergyStored();
        }
        return super.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getMaxEnergyStored();
        }
        return super.getMaxEnergyStored();
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).canReceiveEnergy(side);
        }
        return false;
    }

    @Override
    public boolean canExtractEnergy(EnumFacing side) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).canExtractEnergy(side);
        }
        return false;
    }

    @Override
    public int receiveEnergy(int maxReceive, EnumFacing side, boolean simulate) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).receiveEnergy(maxReceive, side, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(int maxExtract, EnumFacing side, boolean simulate) {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).extractEnergy(maxExtract, side, simulate);
        }
        return 0;
    }

    @Override
    public int getEUSourceTier() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEUSourceTier();
        }
        return 1;
    }

    @Override
    public int getEUSinkTier() {
        if (this.getMaster() instanceof ITileEnergy) {
            return ((ITileEnergy)this.getMaster()).getEUSinkTier();
        }
        return 4;
    }

    @Override
    public void pushEnergy() {
        if (this.getMaster() == null) {
            return;
        }
        super.pushEnergy();
    }

    @Override
    public void spreadEnergy() {
        if (this.getMaster() == null) {
            return;
        }
        super.spreadEnergy();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getTanks();
        }
        return super.getTanks();
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getFluidConnections();
        }
        return super.getFluidConnections();
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setFluidConnections(connections);
        }
        super.setFluidConnections(connections);
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getFluidSides();
        }
        return super.getFluidSides();
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getGasWrapper();
        }
        return super.getGasWrapper();
    }

    @Override
    public boolean getInputTanksSeparated() {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getInputTanksSeparated();
        }
        return super.getInputTanksSeparated();
    }

    @Override
    public void setInputTanksSeparated(boolean shared) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setInputTanksSeparated(shared);
        } else {
            super.setInputTanksSeparated(shared);
        }
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getVoidUnusableFluidInput(tankNumber);
        }
        return super.getVoidUnusableFluidInput(tankNumber);
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setVoidUnusableFluidInput(tankNumber, voidUnusableFluidInput);
        } else {
            super.setVoidUnusableFluidInput(tankNumber, voidUnusableFluidInput);
        }
    }

    @Override
    public boolean getVoidExcessFluidOutput(int tankNumber) {
        if (this.getMaster() instanceof ITileFluid) {
            return ((ITileFluid)this.getMaster()).getVoidExcessFluidOutput(tankNumber);
        }
        return super.getVoidExcessFluidOutput(tankNumber);
    }

    @Override
    public void setVoidExcessFluidOutput(int tankNumber, boolean voidExcessFluidOutput) {
        if (this.getMaster() instanceof ITileFluid) {
            ((ITileFluid)this.getMaster()).setVoidExcessFluidOutput(tankNumber, voidExcessFluidOutput);
        } else {
            super.setVoidExcessFluidOutput(tankNumber, voidExcessFluidOutput);
        }
    }

    @Override
    public void pushFluid() {
        if (this.getMaster() == null) {
            return;
        }
        super.pushFluid();
    }

    @Override
    public void spreadFluid() {
        if (this.getMaster() == null) {
            return;
        }
        super.spreadFluid();
    }

    public abstract void findMaster();

    public boolean hasMaster() {
        if (this.masterPosition == null) {
            return false;
        }
        return this.isMaster(this.masterPosition);
    }

    public boolean isMaster(BlockPos pos) {
        return this.tClass.isInstance(this.field_145850_b.func_175625_s(pos));
    }

    public T getMaster() {
        if (this.hasMaster()) {
            return (T)((IDummyMaster)this.field_145850_b.func_175625_s(this.masterPosition));
        }
        return null;
    }
}

