/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.recipe.IRecipe;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidArrayIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemArrayIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FluidRegHelper;
import nc.util.GasHelper;
import nc.util.ItemStackHelper;
import nc.util.OreDictHelper;
import nc.util.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractRecipeHandler<T extends IRecipe> {
    public List<T> recipes = new ArrayList<T>();
    public List<Class<?>> validItemInputs = Lists.newArrayList((Object[])new Class[]{IItemIngredient.class, ArrayList.class, String.class, Item.class, Block.class, ItemStack.class, ItemStack[].class});
    public List<Class<?>> validFluidInputs = Lists.newArrayList((Object[])new Class[]{IFluidIngredient.class, ArrayList.class, String.class, Fluid.class, FluidStack.class, FluidStack[].class});
    public List<Class<?>> validItemOutputs = Lists.newArrayList((Object[])new Class[]{IItemIngredient.class, String.class, Item.class, Block.class, ItemStack.class});
    public List<Class<?>> validFluidOutputs = Lists.newArrayList((Object[])new Class[]{IFluidIngredient.class, String.class, Fluid.class, FluidStack.class});
    public List<Class<?>> needItemAltering = Lists.newArrayList((Object[])new Class[]{Item.class, Block.class});
    public List<Class<?>> needFluidAltering = Lists.newArrayList((Object[])new Class[]{Fluid.class});
    public static final List<Integer> INVALID = Lists.newArrayList((Object[])new Integer[]{-1});

    public abstract void addRecipes();

    public abstract String getRecipeName();

    public List<T> getRecipes() {
        return this.recipes;
    }

    public abstract void addRecipe(Object ... var1);

    @Nullable
    public T getRecipeFromInputs(List<ItemStack> itemInputs, List<Tank> fluidInputs) {
        if (this.isFullNull(itemInputs, fluidInputs)) {
            return null;
        }
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchingInputs(itemInputs, fluidInputs)) continue;
            return (T)recipe;
        }
        return null;
    }

    @Nullable
    public T getRecipeFromOutputs(List<ItemStack> itemOutputs, List<Tank> fluidOutputs) {
        if (this.isFullNull(itemOutputs, fluidOutputs)) {
            return null;
        }
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchingOutputs(itemOutputs, fluidOutputs)) continue;
            return (T)recipe;
        }
        return null;
    }

    private boolean isFullNull(List<ItemStack> items, List<Tank> tanks) {
        for (ItemStack item : items) {
            if (item == null || item.func_190926_b()) continue;
            return false;
        }
        for (Tank tank : tanks) {
            if (tank.getFluid() == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public T getRecipeFromIngredients(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchingIngredients(itemIngredients, fluidIngredients)) continue;
            return (T)recipe;
        }
        return null;
    }

    @Nullable
    public T getRecipeFromProducts(List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchingProducts(itemProducts, fluidProducts)) continue;
            return (T)recipe;
        }
        return null;
    }

    public boolean addRecipe(T recipe) {
        return recipe != null ? this.recipes.add(recipe) : false;
    }

    public boolean removeRecipe(T recipe) {
        return recipe != null ? this.recipes.remove(recipe) : false;
    }

    public void removeAllRecipes() {
        this.recipes.clear();
    }

    public void addValidItemInput(Class itemInputType) {
        this.validItemInputs.add(itemInputType);
    }

    public void addValidFluidInput(Class fluidInputType) {
        this.validFluidInputs.add(fluidInputType);
    }

    public void addValidItemOutput(Class itemOutputType) {
        this.validItemOutputs.add(itemOutputType);
    }

    public void addValidFluidOutput(Class fluidOutputType) {
        this.validFluidOutputs.add(fluidOutputType);
    }

    protected boolean isValidItemInputType(Object itemInput) {
        for (Class<?> itemInputType : this.validItemInputs) {
            if (itemInput instanceof ArrayList && itemInputType == ArrayList.class) {
                ArrayList list = (ArrayList)itemInput;
                for (Object obj : list) {
                    if (!this.isValidItemInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!itemInputType.isInstance(itemInput)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidFluidInputType(Object fluidInput) {
        for (Class<?> fluidInputType : this.validFluidInputs) {
            if (fluidInput instanceof ArrayList && fluidInputType == ArrayList.class) {
                ArrayList list = (ArrayList)fluidInput;
                for (Object obj : list) {
                    if (!this.isValidFluidInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!fluidInputType.isInstance(fluidInput)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidItemOutputType(Object itemOutput) {
        for (Class<?> itemOutputType : this.validItemOutputs) {
            if (!itemOutputType.isInstance(itemOutput)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidFluidOutputType(Object fluidOutput) {
        for (Class<?> fluidOutputType : this.validFluidOutputs) {
            if (!fluidOutputType.isInstance(fluidOutput)) continue;
            return true;
        }
        return false;
    }

    protected boolean requiresItemFixing(Object object) {
        for (Class<?> objectType : this.needItemAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    protected boolean requiresFluidFixing(Object object) {
        for (Class<?> objectType : this.needFluidAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IItemIngredient buildItemIngredient(Object object) {
        if (this.requiresItemFixing(object)) {
            object = RecipeHelper.fixItemStack(object);
        }
        if (object instanceof IItemIngredient) {
            return this.checkedItemIngredient((IItemIngredient)object);
        }
        if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            ArrayList<IItemIngredient> buildList = new ArrayList<IItemIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IItemIngredient recipeObject;
                    if (listObject instanceof IItemIngredient) {
                        buildList.add((IItemIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = this.checkedItemIngredient(this.buildItemIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return this.checkedItemIngredient(new ItemArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return this.checkedItemIngredient(RecipeHelper.oreStackFromString((String)object));
        }
        if (object instanceof ItemStack) {
            return this.checkedItemIngredient(new ItemIngredient((ItemStack)object));
        }
        return null;
    }

    @Nullable
    public IItemIngredient checkedItemIngredient(IItemIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    @Nullable
    public IFluidIngredient buildFluidIngredient(Object object) {
        if (this.requiresFluidFixing(object)) {
            object = RecipeHelper.fixFluidStack(object);
        }
        if (this.needsExpanding() && object instanceof FluidIngredient) {
            return this.checkedFluidIngredient(this.buildFluidIngredient(this.expandedFluidStackList((FluidIngredient)object)));
        }
        if (object instanceof IFluidIngredient) {
            return this.checkedFluidIngredient((IFluidIngredient)object);
        }
        if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            ArrayList<IFluidIngredient> buildList = new ArrayList<IFluidIngredient>();
            if (!list.isEmpty()) {
                for (Object listObject : list) {
                    IFluidIngredient recipeObject;
                    if (listObject instanceof IFluidIngredient) {
                        buildList.add((IFluidIngredient)listObject);
                        continue;
                    }
                    if (listObject == null || (recipeObject = this.checkedFluidIngredient(this.buildFluidIngredient(listObject))) == null) continue;
                    buildList.add(recipeObject);
                }
                if (buildList.isEmpty()) {
                    return null;
                }
                return this.checkedFluidIngredient(new FluidArrayIngredient(buildList));
            }
            return null;
        }
        if (object instanceof String) {
            return this.checkedFluidIngredient(RecipeHelper.fluidStackFromString((String)object));
        }
        if (object instanceof FluidStack) {
            return this.checkedFluidIngredient(new FluidIngredient((FluidStack)object));
        }
        return null;
    }

    @Nullable
    public IFluidIngredient checkedFluidIngredient(IFluidIngredient ingredient) {
        return ingredient == null || !ingredient.isValid() ? null : ingredient;
    }

    public boolean needsExpanding() {
        return ModCheck.mekanismLoaded() || ModCheck.techRebornLoaded();
    }

    public boolean isValidItemInput(ItemStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IItemIngredient input : recipe.itemIngredients()) {
                if (!input.matches(stack, IngredientSorption.NEUTRAL)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidFluidInput(FluidStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IFluidIngredient input : recipe.fluidIngredients()) {
                if (!input.matches(stack, IngredientSorption.NEUTRAL)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidItemOutput(ItemStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IItemIngredient output : recipe.itemProducts()) {
                if (!output.matches(stack, IngredientSorption.OUTPUT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidFluidOutput(FluidStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IFluidIngredient output : recipe.fluidProducts()) {
                if (!output.matches(stack, IngredientSorption.OUTPUT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidItemInput(ItemStack stack, ItemStack slotStack, List<ItemStack> otherInputs) {
        if (otherInputs.isEmpty() || stack.func_77969_a(slotStack) && ItemStackHelper.areItemStackTagsEqual(stack, slotStack)) {
            return this.isValidItemInput(stack);
        }
        ArrayList<ItemStack> otherStacks = new ArrayList<ItemStack>();
        for (ItemStack otherInput : otherInputs) {
            if (otherInput.func_190926_b()) continue;
            otherStacks.add(otherInput);
        }
        if (otherStacks.isEmpty()) {
            return this.isValidItemInput(stack);
        }
        ArrayList allStacks = Lists.newArrayList((Object[])new ItemStack[]{stack});
        allStacks.addAll(otherStacks);
        ArrayList<T> recipeList = new ArrayList<T>(this.recipes);
        block1: for (IRecipe recipe : this.recipes) {
            block2: for (ItemStack obj : allStacks) {
                for (IItemIngredient input : recipe.itemIngredients()) {
                    if (!input.matches(obj, IngredientSorption.NEUTRAL)) continue;
                    continue block2;
                }
                recipeList.remove(recipe);
                continue block1;
            }
        }
        for (IRecipe recipe : recipeList) {
            for (IItemIngredient input : recipe.itemIngredients()) {
                if (!input.matches(stack, IngredientSorption.NEUTRAL)) continue;
                for (ItemStack other : otherStacks) {
                    if (!input.matches(other, IngredientSorption.NEUTRAL)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public OreIngredient oreStack(String oreType, int stackSize) {
        if (!OreDictHelper.oreExists(oreType)) {
            return null;
        }
        return new OreIngredient(oreType, stackSize);
    }

    public FluidIngredient fluidStack(String fluidName, int stackSize) {
        if (!FluidRegHelper.fluidExists(fluidName)) {
            return null;
        }
        return new FluidIngredient(fluidName, stackSize);
    }

    public List<OreIngredient> oreStackList(List<String> oreTypes, int stackSize) {
        ArrayList<OreIngredient> oreStackList = new ArrayList<OreIngredient>();
        for (String oreType : oreTypes) {
            if (this.oreStack(oreType, stackSize) == null) continue;
            oreStackList.add(this.oreStack(oreType, stackSize));
        }
        return oreStackList;
    }

    public List<FluidIngredient> fluidStackList(List<String> fluidNames, int stackSize) {
        ArrayList<FluidIngredient> fluidStackList = new ArrayList<FluidIngredient>();
        for (String fluidName : fluidNames) {
            if (this.fluidStack(fluidName, stackSize) == null) continue;
            fluidStackList.add(this.fluidStack(fluidName, stackSize));
        }
        return fluidStackList;
    }

    public EmptyItemIngredient emptyItemStack() {
        return new EmptyItemIngredient();
    }

    public EmptyFluidIngredient emptyFluidStack() {
        return new EmptyFluidIngredient();
    }

    public ChanceItemIngredient chanceItemStack(ItemStack stack, int chancePercent) {
        if (stack == null) {
            return null;
        }
        return new ChanceItemIngredient(new ItemIngredient(stack), chancePercent);
    }

    public ChanceItemIngredient chanceItemStack(ItemStack stack, int chancePercent, int minStackSize) {
        if (stack == null) {
            return null;
        }
        return new ChanceItemIngredient(new ItemIngredient(stack), chancePercent, minStackSize);
    }

    public ChanceItemIngredient chanceOreStack(String oreType, int stackSize, int chancePercent) {
        if (!OreDictHelper.oreExists(oreType)) {
            return null;
        }
        return new ChanceItemIngredient(this.oreStack(oreType, stackSize), chancePercent);
    }

    public ChanceItemIngredient chanceOreStack(String oreType, int stackSize, int chancePercent, int minStackSize) {
        if (!OreDictHelper.oreExists(oreType)) {
            return null;
        }
        return new ChanceItemIngredient(this.oreStack(oreType, stackSize), chancePercent, minStackSize);
    }

    public ChanceFluidIngredient chanceFluidStack(String fluidName, int stackSize, int chancePercent, int stackDiff) {
        if (!FluidRegHelper.fluidExists(fluidName)) {
            return null;
        }
        return new ChanceFluidIngredient(this.fluidStack(fluidName, stackSize), chancePercent, stackDiff);
    }

    public ChanceFluidIngredient chanceFluidStack(String fluidName, int stackSize, int chancePercent, int stackDiff, int minStackSize) {
        if (!FluidRegHelper.fluidExists(fluidName)) {
            return null;
        }
        return new ChanceFluidIngredient(this.fluidStack(fluidName, stackSize), chancePercent, stackDiff, minStackSize);
    }

    public List<ChanceItemIngredient> chanceOreStackList(List<String> oreTypes, int stackSize, int chancePercent) {
        ArrayList<ChanceItemIngredient> oreStackList = new ArrayList<ChanceItemIngredient>();
        for (String oreType : oreTypes) {
            if (this.chanceOreStack(oreType, stackSize, chancePercent) == null) continue;
            oreStackList.add(this.chanceOreStack(oreType, stackSize, chancePercent));
        }
        return oreStackList;
    }

    public List<ChanceItemIngredient> chanceOreStackList(List<String> oreTypes, int stackSize, int chancePercent, int minStackSize) {
        ArrayList<ChanceItemIngredient> oreStackList = new ArrayList<ChanceItemIngredient>();
        for (String oreType : oreTypes) {
            if (this.chanceOreStack(oreType, stackSize, chancePercent, minStackSize) == null) continue;
            oreStackList.add(this.chanceOreStack(oreType, stackSize, chancePercent, minStackSize));
        }
        return oreStackList;
    }

    public List<ChanceFluidIngredient> chanceFluidStackList(List<String> fluidNames, int stackSize, int chancePercent, int stackDiff) {
        ArrayList<ChanceFluidIngredient> fluidStackList = new ArrayList<ChanceFluidIngredient>();
        for (String fluidName : fluidNames) {
            if (this.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff) == null) continue;
            fluidStackList.add(this.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff));
        }
        return fluidStackList;
    }

    public List<ChanceFluidIngredient> chanceFluidStackList(List<String> fluidNames, int stackSize, int chancePercent, int stackDiff, int minStackSize) {
        ArrayList<ChanceFluidIngredient> fluidStackList = new ArrayList<ChanceFluidIngredient>();
        for (String fluidName : fluidNames) {
            if (this.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff, minStackSize) == null) continue;
            fluidStackList.add(this.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff, minStackSize));
        }
        return fluidStackList;
    }

    public List<FluidIngredient> expandedFluidStackList(FluidIngredient stack) {
        ArrayList fluidStackList = Lists.newArrayList((Object[])new FluidIngredient[]{stack});
        if (ModCheck.mekanismLoaded() && !stack.fluidName.equals("helium")) {
            if (GasHelper.TRANSLATION_MAP.containsKey(stack.fluidName)) {
                fluidStackList.add(this.fluidStack(GasHelper.TRANSLATION_MAP.get(stack.fluidName), stack.amount));
            } else {
                fluidStackList.add(this.fluidStack("liquid" + stack.fluidName, stack.amount));
            }
        }
        if (ModCheck.techRebornLoaded()) {
            fluidStackList.add(this.fluidStack("fluid" + stack.fluidName, stack.amount));
        }
        return fluidStackList;
    }
}

