/*
 * Decompiled with CFR 0.152.
 */
package nc.network.radiation;

import io.netty.buffer.ByteBuf;
import nc.capability.radiation.entity.IEntityRads;
import nc.util.NCUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerRadsUpdatePacket
implements IMessage {
    boolean messageValid;
    protected double totalRads;
    protected double radiationLevel;
    protected double radiationResistance;
    protected boolean radXWoreOff;
    protected double radawayBuffer;
    protected boolean consumed;
    protected double radawayCooldown;
    protected double radXCooldown;
    protected double radiationImmunityTime;

    public PlayerRadsUpdatePacket() {
        this.messageValid = false;
    }

    public PlayerRadsUpdatePacket(IEntityRads playerRads) {
        this.totalRads = playerRads.getTotalRads();
        this.radiationLevel = playerRads.getRadiationLevel();
        this.radiationResistance = playerRads.getRadiationResistance();
        this.radXWoreOff = playerRads.getRadXWoreOff();
        this.radawayBuffer = playerRads.getRadawayBuffer();
        this.consumed = playerRads.getConsumedMedicine();
        this.radawayCooldown = playerRads.getRadawayCooldown();
        this.radXCooldown = playerRads.getRadXCooldown();
        this.radiationImmunityTime = playerRads.getRadiationImmunityTime();
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.totalRads = buf.readDouble();
            this.radiationLevel = buf.readDouble();
            this.radiationResistance = buf.readDouble();
            this.radXWoreOff = buf.readBoolean();
            this.radawayBuffer = buf.readDouble();
            this.consumed = buf.readBoolean();
            this.radawayCooldown = buf.readDouble();
            this.radXCooldown = buf.readDouble();
            this.radiationImmunityTime = buf.readDouble();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeDouble(this.totalRads);
        buf.writeDouble(this.radiationLevel);
        buf.writeDouble(this.radiationResistance);
        buf.writeBoolean(this.radXWoreOff);
        buf.writeDouble(this.radawayBuffer);
        buf.writeBoolean(this.consumed);
        buf.writeDouble(this.radawayCooldown);
        buf.writeDouble(this.radXCooldown);
        buf.writeDouble(this.radiationImmunityTime);
    }

    public static class Handler
    implements IMessageHandler<PlayerRadsUpdatePacket, IMessage> {
        public IMessage onMessage(PlayerRadsUpdatePacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            return null;
        }

        void processMessage(PlayerRadsUpdatePacket message) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
                return;
            }
            IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (playerRads == null) {
                return;
            }
            playerRads.setTotalRads(message.totalRads, false);
            playerRads.setRadiationLevel(message.radiationLevel);
            playerRads.setRadiationResistance(message.radiationResistance);
            playerRads.setRadXWoreOff(message.radXWoreOff);
            playerRads.setRadawayBuffer(message.radawayBuffer);
            playerRads.setConsumedMedicine(message.consumed);
            playerRads.setRadawayCooldown(message.radawayCooldown);
            playerRads.setRadXCooldown(message.radXCooldown);
            playerRads.setRadiationImmunityTime(message.radiationImmunityTime);
        }
    }
}

