/*
 * Decompiled with CFR 0.152.
 */
package nc.item.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.Random;
import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.item.NCItem;
import nc.util.Lang;
import nc.util.RadiationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemGeigerCounter
extends NCItem
implements IBauble {
    private Random rand = new Random();
    private static final String RADIATION = Lang.localise("item.nuclearcraft.geiger_counter.rads");

    public ItemGeigerCounter(String nameIn, String ... tooltip) {
        super(nameIn, tooltip);
        this.field_77777_bU = 1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        IEntityRads playerRads;
        if (worldIn.field_72995_K && playerIn.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null) && (playerRads = (IEntityRads)playerIn.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) != null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(RadiationHelper.getRadsTextColor(playerRads) + RADIATION + " " + (playerRads.isTotalRadsNegligible() ? "0 Rads" : RadiationHelper.radsPrefix(playerRads.getTotalRads(), false)) + " [" + Math.round(playerRads.getRadsPercentage()) + "%], " + RadiationHelper.getRadiationTextColor(playerRads) + (playerRads.isRadiationNegligible() ? "0 Rads/t" : RadiationHelper.radsPrefix(playerRads.getRadiationLevel(), true))));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(world.field_72995_K && NCConfig.radiation_require_counter && entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.isStackOnHotbar(stack, player) && player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
            IEntityRads entityRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (entityRads == null || entityRads.isRadiationUndetectable()) {
                return;
            }
            double soundChance = Math.cbrt(entityRads.getRadiationLevel() / 200.0);
            float soundVolume = MathHelper.func_76131_a((float)((float)(8.0 * soundChance)), (float)0.55f, (float)1.1f);
            for (int i = 0; i < 2; ++i) {
                if (!(this.rand.nextDouble() < soundChance)) continue;
                player.func_184185_a(SoundHandler.geiger_tick, soundVolume + this.rand.nextFloat() * 0.12f, 0.92f + this.rand.nextFloat() * 0.16f);
            }
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }
}

