/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import nc.config.NCConfig;
import nc.init.NCItems;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DungeonLootHandler {
    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName() != null && event.getTable() != null) {
            LootCondition[] noCondition = new LootCondition[]{};
            LootPool pool = event.getTable().getPool("main");
            if (pool == null) {
                pool = new LootPool(new LootEntry[0], noCondition, new RandomValueRange(5.0f, 10.0f), new RandomValueRange(0.0f), "main");
                event.getTable().addPool(pool);
            }
            boolean addPlating = false;
            boolean addSolenoids = false;
            boolean addMachinery = false;
            boolean addOther = false;
            if (NCConfig.dungeon_loot) {
                if (LootTableList.field_186422_d.equals((Object)event.getName())) {
                    addPlating = true;
                    addMachinery = true;
                    addOther = true;
                } else if (LootTableList.field_186424_f.equals((Object)event.getName())) {
                    addPlating = true;
                    addMachinery = true;
                } else if (LootTableList.field_186423_e.equals((Object)event.getName())) {
                    addPlating = true;
                    addSolenoids = true;
                    addOther = true;
                } else if (LootTableList.field_186426_h.equals((Object)event.getName())) {
                    addOther = true;
                } else if (LootTableList.field_186427_i.equals((Object)event.getName())) {
                    addPlating = true;
                    addSolenoids = true;
                    addMachinery = true;
                } else if (LootTableList.field_186428_j.equals((Object)event.getName())) {
                    addPlating = true;
                    addSolenoids = true;
                    addMachinery = true;
                } else if (LootTableList.field_186431_m.equals((Object)event.getName())) {
                    addSolenoids = true;
                    addMachinery = true;
                } else if (LootTableList.field_186429_k.equals((Object)event.getName())) {
                    addSolenoids = true;
                    addOther = true;
                } else if (LootTableList.field_186425_g.equals((Object)event.getName())) {
                    addPlating = true;
                    addSolenoids = true;
                    addMachinery = true;
                } else if (LootTableList.field_186421_c.equals((Object)event.getName())) {
                    addPlating = true;
                    addSolenoids = true;
                    addMachinery = true;
                } else if (LootTableList.field_191192_o.equals((Object)event.getName())) {
                    addOther = true;
                } else if (LootTableList.field_186430_l.equals((Object)event.getName())) {
                    addPlating = true;
                    addSolenoids = true;
                    addMachinery = true;
                }
            }
            if (addOther) {
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.dominos, 3, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 2.0f, 4.0f), noCondition, "nuclearcraft:dominos"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.milk_chocolate, 4, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 2.0f, 4.0f), noCondition, "nuclearcraft:milk_chocolate"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.marshmallow, 4, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 2.0f, 4.0f), noCondition, "nuclearcraft:marshmallow"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.smore, 3, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 2.0f, 4.0f), noCondition, "nuclearcraft:smore"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.record_end_of_the_world, 3, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 1.0f, 1.0f), noCondition, "nuclearcraft:record_end_of_the_world"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.record_money_for_nothing, 3, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 1.0f, 1.0f), noCondition, "nuclearcraft:record_money_for_nothing"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.record_wanderer, 3, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 1.0f, 1.0f), noCondition, "nuclearcraft:record_wanderer"));
                pool.addEntry((LootEntry)new LootEntryItem(NCItems.record_hyperspace, 3, 0, DungeonLootHandler.lootFunctions(0.0f, 0.0f, 1.0f, 1.0f), noCondition, "nuclearcraft:record_hyperspace"));
            }
        }
    }

    private static LootFunction[] lootFunctions(float metaMin, float metaMax, float countMin, float countMax) {
        LootCondition[] noCondition = new LootCondition[]{};
        SetMetadata damage = new SetMetadata(noCondition, new RandomValueRange(metaMin, metaMax));
        SetCount amount = new SetCount(noCondition, new RandomValueRange(countMin, countMax));
        return new LootFunction[]{damage, amount};
    }
}

